/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation;

import com.azure.core.credentials.TokenCredential;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.exception.UnexpectedLengthException;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.http.policy.CookiePolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.http.rest.Page;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.implementation.Base64Url;
import com.azure.core.implementation.EncodedParameter;
import com.azure.core.implementation.OperationDescription;
import com.azure.core.implementation.SwaggerInterfaceParser;
import com.azure.core.implementation.SwaggerMethodParser;
import com.azure.core.implementation.UnexpectedExceptionInformation;
import com.azure.core.implementation.annotation.ResumeOperation;
import com.azure.core.implementation.http.PagedResponseBase;
import com.azure.core.implementation.http.UrlBuilder;
import com.azure.core.implementation.serializer.HttpResponseDecoder;
import com.azure.core.implementation.serializer.SerializerAdapter;
import com.azure.core.implementation.serializer.SerializerEncoding;
import com.azure.core.implementation.serializer.jackson.JacksonAdapter;
import com.azure.core.implementation.tracing.TracerProxy;
import com.azure.core.implementation.util.FluxUtil;
import com.azure.core.implementation.util.ImplUtils;
import com.azure.core.implementation.util.TypeUtil;
import com.azure.core.util.logging.ClientLogger;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import reactor.core.Exceptions;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Signal;
import reactor.util.context.Context;

public class RestProxy
implements InvocationHandler {
    private final ClientLogger logger = new ClientLogger(RestProxy.class);
    private final HttpPipeline httpPipeline;
    private final SerializerAdapter serializer;
    private final SwaggerInterfaceParser interfaceParser;
    private final HttpResponseDecoder decoder;

    public RestProxy(HttpPipeline httpPipeline, SerializerAdapter serializer, SwaggerInterfaceParser interfaceParser) {
        this.httpPipeline = httpPipeline;
        this.serializer = serializer;
        this.interfaceParser = interfaceParser;
        this.decoder = new HttpResponseDecoder(this.serializer);
    }

    private SwaggerMethodParser methodParser(Method method) {
        return this.interfaceParser.methodParser(method);
    }

    public SerializerAdapter serializer() {
        return this.serializer;
    }

    public Mono<HttpResponse> send(HttpRequest request, com.azure.core.util.Context contextData) {
        return this.httpPipeline.send(request, contextData);
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) {
        try {
            if (method.isAnnotationPresent(ResumeOperation.class)) {
                OperationDescription opDesc = ImplUtils.findFirstOfType(args, OperationDescription.class);
                Method resumeMethod = this.determineResumeMethod(method, opDesc.methodName());
                SwaggerMethodParser methodParser = this.methodParser(resumeMethod);
                HttpRequest request = this.createHttpRequest(opDesc, methodParser, args);
                Type returnType = methodParser.returnType();
                return this.handleResumeOperation(request, opDesc, methodParser, returnType, this.startTracingSpan(resumeMethod, com.azure.core.util.Context.NONE));
            }
            SwaggerMethodParser methodParser = this.methodParser(method);
            HttpRequest request = this.createHttpRequest(methodParser, args);
            com.azure.core.util.Context context = methodParser.context(args).addData("caller-method", methodParser.fullyQualifiedMethodName());
            context = this.startTracingSpan(method, context);
            if (request.body() != null) {
                request.body(this.validateLength(request));
            }
            Mono<HttpResponse> asyncResponse = this.send(request, context);
            Mono<HttpResponseDecoder.HttpDecodedResponse> asyncDecodedResponse = this.decoder.decode(asyncResponse, methodParser);
            return this.handleHttpResponse(request, asyncDecodedResponse, methodParser, methodParser.returnType(), context);
        }
        catch (Exception e) {
            throw this.logger.logExceptionAsError(Exceptions.propagate((Throwable)e));
        }
    }

    private Flux<ByteBuffer> validateLength(HttpRequest request) {
        Flux<ByteBuffer> bbFlux = request.body();
        if (bbFlux == null) {
            return Flux.empty();
        }
        return Flux.defer(() -> {
            Long expectedLength = Long.valueOf(request.headers().value("Content-Length"));
            long[] currentTotalLength = new long[1];
            return bbFlux.doOnEach(s -> {
                if (s.isOnNext()) {
                    ByteBuffer byteBuffer = (ByteBuffer)s.get();
                    int currentLength = byteBuffer == null ? 0 : byteBuffer.remaining();
                    currentTotalLength[0] = currentTotalLength[0] + (long)currentLength;
                    if (currentTotalLength[0] > expectedLength) {
                        throw this.logger.logExceptionAsError(new UnexpectedLengthException(String.format("Request body emitted %d bytes more than the expected %d bytes.", currentTotalLength[0], expectedLength), currentTotalLength[0], expectedLength));
                    }
                } else if (s.isOnComplete() && expectedLength.compareTo(currentTotalLength[0]) != 0) {
                    throw this.logger.logExceptionAsError(new UnexpectedLengthException(String.format("Request body emitted %d bytes less than the expected %d bytes.", currentTotalLength[0], expectedLength), currentTotalLength[0], expectedLength));
                }
            });
        });
    }

    private Method determineResumeMethod(Method method, String resumeMethodName) {
        for (Method potentialResumeMethod : method.getDeclaringClass().getMethods()) {
            if (!potentialResumeMethod.getName().equals(resumeMethodName)) continue;
            return potentialResumeMethod;
        }
        return null;
    }

    private com.azure.core.util.Context startTracingSpan(Method method, com.azure.core.util.Context context) {
        String spanName = String.format("Azure.%s/%s", this.interfaceParser.serviceName(), method.getName());
        context = TracerProxy.setSpanName(spanName, context);
        return TracerProxy.start(spanName, context);
    }

    private HttpRequest createHttpRequest(SwaggerMethodParser methodParser, Object[] args) throws IOException {
        UrlBuilder urlBuilder;
        String path = methodParser.path(args);
        UrlBuilder pathUrlBuilder = UrlBuilder.parse(path);
        if (pathUrlBuilder.scheme() != null) {
            urlBuilder = pathUrlBuilder;
        } else {
            urlBuilder = new UrlBuilder();
            String scheme = methodParser.scheme(args);
            urlBuilder.scheme(scheme);
            String host = methodParser.host(args);
            urlBuilder.host(host);
            if (path != null && !path.isEmpty() && !path.equals("/")) {
                String hostPath = urlBuilder.path();
                if (hostPath == null || hostPath.isEmpty() || hostPath.equals("/")) {
                    urlBuilder.path(path);
                } else {
                    urlBuilder.path(hostPath + "/" + path);
                }
            }
        }
        for (EncodedParameter queryParameter : methodParser.encodedQueryParameters(args)) {
            urlBuilder.setQueryParameter(queryParameter.name(), queryParameter.encodedValue());
        }
        URL url = urlBuilder.toURL();
        HttpRequest request = this.configRequest(new HttpRequest(methodParser.httpMethod(), url), methodParser, args);
        for (HttpHeader header : methodParser.headers(args)) {
            request.header(header.name(), header.value());
        }
        return request;
    }

    private HttpRequest createHttpRequest(OperationDescription operationDescription, SwaggerMethodParser methodParser, Object[] args) throws IOException {
        HttpRequest request = this.configRequest(new HttpRequest(methodParser.httpMethod(), operationDescription.url()), methodParser, args);
        for (String headerName : operationDescription.headers().keySet()) {
            request.header(headerName, operationDescription.headers().get(headerName));
        }
        return request;
    }

    private HttpRequest configRequest(HttpRequest request, SwaggerMethodParser methodParser, Object[] args) throws IOException {
        Object bodyContentObject = methodParser.body(args);
        if (bodyContentObject == null) {
            request.headers().put("Content-Length", "0");
        } else {
            String bodyContentString;
            String[] contentTypeParts;
            String contentType = methodParser.bodyContentType();
            if (contentType == null || contentType.isEmpty()) {
                contentType = bodyContentObject instanceof byte[] || bodyContentObject instanceof String ? "application/octet-stream" : "application/json";
            }
            request.headers().put("Content-Type", contentType);
            boolean isJson = false;
            for (String contentTypePart : contentTypeParts = contentType.split(";")) {
                if (!contentTypePart.trim().equalsIgnoreCase("application/json")) continue;
                isJson = true;
                break;
            }
            if (isJson) {
                bodyContentString = this.serializer.serialize(bodyContentObject, SerializerEncoding.JSON);
                request.body(bodyContentString);
            } else if (FluxUtil.isFluxByteBuffer(methodParser.bodyJavaType())) {
                request.body((Flux<ByteBuffer>)((Flux)bodyContentObject));
            } else if (bodyContentObject instanceof byte[]) {
                request.body((byte[])bodyContentObject);
            } else if (bodyContentObject instanceof String) {
                bodyContentString = (String)bodyContentObject;
                if (!bodyContentString.isEmpty()) {
                    request.body(bodyContentString);
                }
            } else if (bodyContentObject instanceof ByteBuffer) {
                request.body((Flux<ByteBuffer>)Flux.just((Object)((ByteBuffer)bodyContentObject)));
            } else {
                bodyContentString = this.serializer.serialize(bodyContentObject, SerializerEncoding.fromHeaders(request.headers()));
                request.body(bodyContentString);
            }
        }
        return request;
    }

    private Mono<HttpResponseDecoder.HttpDecodedResponse> ensureExpectedStatus(Mono<HttpResponseDecoder.HttpDecodedResponse> asyncDecodedResponse, SwaggerMethodParser methodParser) {
        return asyncDecodedResponse.flatMap(decodedHttpResponse -> this.ensureExpectedStatus((HttpResponseDecoder.HttpDecodedResponse)decodedHttpResponse, methodParser, null));
    }

    private static Exception instantiateUnexpectedException(UnexpectedExceptionInformation exception, HttpResponse httpResponse, String responseContent, Object responseDecodedContent) {
        Exception result;
        int responseStatusCode = httpResponse.statusCode();
        String contentType = httpResponse.headerValue("Content-Type");
        String bodyRepresentation = "application/octet-stream".equalsIgnoreCase(contentType) ? "(" + httpResponse.headerValue("Content-Length") + "-byte body)" : (responseContent.isEmpty() ? "(empty body)" : "\"" + responseContent + "\"");
        try {
            Constructor<? extends HttpResponseException> exceptionConstructor = exception.exceptionType().getConstructor(String.class, HttpResponse.class, exception.exceptionBodyType());
            result = exceptionConstructor.newInstance("Status code " + responseStatusCode + ", " + bodyRepresentation, httpResponse, responseDecodedContent);
        }
        catch (ReflectiveOperationException e) {
            String message = "Status code " + responseStatusCode + ", but an instance of " + exception.exceptionType().getCanonicalName() + " cannot be created. Response body: " + bodyRepresentation;
            result = new IOException(message, e);
        }
        return result;
    }

    public Mono<HttpResponseDecoder.HttpDecodedResponse> ensureExpectedStatus(HttpResponseDecoder.HttpDecodedResponse decodedResponse, SwaggerMethodParser methodParser, int[] additionalAllowedStatusCodes) {
        Mono asyncResult;
        int responseStatusCode = decodedResponse.sourceResponse().statusCode();
        if (!methodParser.isExpectedResponseStatusCode(responseStatusCode, additionalAllowedStatusCodes)) {
            Mono<String> bodyAsString = decodedResponse.sourceResponse().bodyAsString();
            asyncResult = bodyAsString.flatMap(responseContent -> {
                Mono<Object> decodedErrorBody = decodedResponse.decodedBody();
                return decodedErrorBody.flatMap(responseDecodedErrorObject -> {
                    Exception exception = RestProxy.instantiateUnexpectedException(methodParser.getUnexpectedException(responseStatusCode), decodedResponse.sourceResponse(), responseContent, responseDecodedErrorObject);
                    return Mono.error((Throwable)exception);
                }).switchIfEmpty(Mono.defer(() -> {
                    Exception exception = RestProxy.instantiateUnexpectedException(methodParser.getUnexpectedException(responseStatusCode), decodedResponse.sourceResponse(), responseContent, null);
                    return Mono.error((Throwable)exception);
                }));
            }).switchIfEmpty(Mono.defer(() -> {
                Exception exception = RestProxy.instantiateUnexpectedException(methodParser.getUnexpectedException(responseStatusCode), decodedResponse.sourceResponse(), "", null);
                return Mono.error((Throwable)exception);
            }));
        } else {
            asyncResult = Mono.just((Object)decodedResponse);
        }
        return asyncResult;
    }

    private Mono<?> handleRestResponseReturnType(HttpResponseDecoder.HttpDecodedResponse response, SwaggerMethodParser methodParser, Type entityType) {
        Type bodyType;
        Mono asyncResult = TypeUtil.isTypeOrSubTypeOf(entityType, Response.class) ? (TypeUtil.isTypeOrSubTypeOf(bodyType = TypeUtil.getRestResponseBodyType(entityType), Void.class) ? response.sourceResponse().body().ignoreElements().then(Mono.just(this.createResponse(response, entityType, null))) : this.handleBodyReturnType(response, methodParser, bodyType).map(bodyAsObject -> this.createResponse(response, entityType, bodyAsObject)).switchIfEmpty(Mono.defer(() -> Mono.just(this.createResponse(response, entityType, null))))) : this.handleBodyReturnType(response, methodParser, entityType);
        return asyncResult;
    }

    private Response<?> createResponse(HttpResponseDecoder.HttpDecodedResponse response, Type entityType, Object bodyAsObject) {
        HttpResponse httpResponse = response.sourceResponse();
        HttpRequest httpRequest = httpResponse.request();
        int responseStatusCode = httpResponse.statusCode();
        HttpHeaders responseHeaders = httpResponse.headers();
        Class<Object> cls = TypeUtil.getRawClass(entityType);
        if (cls.equals(Response.class)) {
            cls = ResponseBase.class;
        } else if (cls.equals(PagedResponse.class)) {
            cls = PagedResponseBase.class;
            if (bodyAsObject != null && !TypeUtil.isTypeOrSubTypeOf(bodyAsObject.getClass(), Page.class)) {
                throw this.logger.logExceptionAsError(new RuntimeException("Unable to create PagedResponse<T>. Body must be of a type that implements: " + Page.class));
            }
        }
        List constructors = Arrays.stream(cls.getDeclaredConstructors()).filter(constructor -> {
            int paramCount = constructor.getParameterCount();
            return paramCount >= 3 && paramCount <= 5;
        }).sorted(Comparator.comparingInt(Constructor::getParameterCount)).collect(Collectors.toList());
        if (constructors.isEmpty()) {
            throw this.logger.logExceptionAsError(new RuntimeException("Cannot find suitable constructor for class " + cls));
        }
        Iterator iterator = constructors.iterator();
        if (iterator.hasNext()) {
            Constructor constructor2;
            Constructor ctor = constructor2 = (Constructor)iterator.next();
            try {
                int paramCount = constructor2.getParameterCount();
                switch (paramCount) {
                    case 3: {
                        return (Response)ctor.newInstance(httpRequest, responseStatusCode, responseHeaders);
                    }
                    case 4: {
                        return (Response)ctor.newInstance(httpRequest, responseStatusCode, responseHeaders, bodyAsObject);
                    }
                    case 5: {
                        return (Response)ctor.newInstance(httpRequest, responseStatusCode, responseHeaders, bodyAsObject, response.decodedHeaders().block());
                    }
                }
                throw this.logger.logExceptionAsError(new IllegalStateException("Response constructor with expected parameters not found."));
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw this.logger.logExceptionAsError(Exceptions.propagate((Throwable)e));
            }
        }
        throw this.logger.logExceptionAsError(new RuntimeException("Cannot find suitable constructor for class " + cls));
    }

    protected final Mono<?> handleBodyReturnType(HttpResponseDecoder.HttpDecodedResponse response, SwaggerMethodParser methodParser, Type entityType) {
        Mono asyncResult;
        int responseStatusCode = response.sourceResponse().statusCode();
        HttpMethod httpMethod = methodParser.httpMethod();
        Type returnValueWireType = methodParser.returnValueWireType();
        if (httpMethod == HttpMethod.HEAD && (TypeUtil.isTypeOrSubTypeOf(entityType, Boolean.TYPE) || TypeUtil.isTypeOrSubTypeOf(entityType, Boolean.class))) {
            boolean isSuccess = responseStatusCode / 100 == 2;
            asyncResult = Mono.just((Object)isSuccess);
        } else if (TypeUtil.isTypeOrSubTypeOf(entityType, byte[].class)) {
            Mono responseBodyBytesAsync = response.sourceResponse().bodyAsByteArray();
            if (returnValueWireType == Base64Url.class) {
                responseBodyBytesAsync = responseBodyBytesAsync.map(base64UrlBytes -> new Base64Url((byte[])base64UrlBytes).decodedBytes());
            }
            asyncResult = responseBodyBytesAsync;
        } else {
            asyncResult = FluxUtil.isFluxByteBuffer(entityType) ? Mono.just(response.sourceResponse().body()) : response.decodedBody();
        }
        return asyncResult;
    }

    protected Object handleHttpResponse(HttpRequest httpRequest, Mono<HttpResponseDecoder.HttpDecodedResponse> asyncDecodedHttpResponse, SwaggerMethodParser methodParser, Type returnType, com.azure.core.util.Context context) {
        return this.handleRestReturnType(asyncDecodedHttpResponse, methodParser, returnType, context);
    }

    protected Object handleResumeOperation(HttpRequest httpRequest, OperationDescription operationDescription, SwaggerMethodParser methodParser, Type returnType, com.azure.core.util.Context context) {
        throw this.logger.logExceptionAsError(Exceptions.propagate((Throwable)new Exception("The resume operation is not available in the base RestProxy class.")));
    }

    public final Object handleRestReturnType(Mono<HttpResponseDecoder.HttpDecodedResponse> asyncHttpDecodedResponse, SwaggerMethodParser methodParser, Type returnType, com.azure.core.util.Context context) {
        Object result;
        Mono asyncExpectedResponse = this.ensureExpectedStatus(asyncHttpDecodedResponse, methodParser).doOnEach(RestProxy::endTracingSpan).subscriberContext(Context.of((Object)"TRACING_CONTEXT", (Object)context));
        if (TypeUtil.isTypeOrSubTypeOf(returnType, Mono.class)) {
            Type monoTypeParam = TypeUtil.getTypeArgument(returnType);
            result = TypeUtil.isTypeOrSubTypeOf(monoTypeParam, Void.class) ? asyncExpectedResponse.then() : asyncExpectedResponse.flatMap(response -> this.handleRestResponseReturnType((HttpResponseDecoder.HttpDecodedResponse)response, methodParser, monoTypeParam));
        } else if (FluxUtil.isFluxByteBuffer(returnType)) {
            result = asyncExpectedResponse.flatMapMany(ar -> ar.sourceResponse().body());
        } else if (TypeUtil.isTypeOrSubTypeOf(returnType, Void.TYPE) || TypeUtil.isTypeOrSubTypeOf(returnType, Void.class)) {
            asyncExpectedResponse.block();
            result = null;
        } else {
            result = asyncExpectedResponse.flatMap(httpResponse -> this.handleRestResponseReturnType((HttpResponseDecoder.HttpDecodedResponse)httpResponse, methodParser, returnType)).block();
        }
        return result;
    }

    private static void endTracingSpan(Signal<HttpResponseDecoder.HttpDecodedResponse> signal) {
        if (signal.isOnComplete() || signal.isOnSubscribe()) {
            return;
        }
        Context context = signal.getContext();
        Optional tracingContext = context.getOrEmpty((Object)"TRACING_CONTEXT");
        if (!tracingContext.isPresent()) {
            return;
        }
        int statusCode = 0;
        Throwable throwable = null;
        if (signal.hasValue()) {
            HttpResponseDecoder.HttpDecodedResponse httpDecodedResponse = (HttpResponseDecoder.HttpDecodedResponse)signal.get();
            statusCode = httpDecodedResponse.sourceResponse().statusCode();
        } else if (signal.hasError() && (throwable = signal.getThrowable()) instanceof HttpResponseException) {
            HttpResponseException exception = (HttpResponseException)throwable;
            statusCode = exception.response().statusCode();
        }
        TracerProxy.end(statusCode, throwable, (com.azure.core.util.Context)tracingContext.get());
    }

    private static SerializerAdapter createDefaultSerializer() {
        return JacksonAdapter.createDefaultSerializerAdapter();
    }

    public static HttpPipeline createDefaultPipeline() {
        return RestProxy.createDefaultPipeline((HttpPipelinePolicy)null);
    }

    public static HttpPipeline createDefaultPipeline(TokenCredential credentials) {
        return RestProxy.createDefaultPipeline(new BearerTokenAuthenticationPolicy(credentials, new String[0]));
    }

    public static HttpPipeline createDefaultPipeline(HttpPipelinePolicy credentialsPolicy) {
        ArrayList<HttpPipelinePolicy> policies = new ArrayList<HttpPipelinePolicy>();
        policies.add(new UserAgentPolicy());
        policies.add(new RetryPolicy());
        policies.add(new CookiePolicy());
        if (credentialsPolicy != null) {
            policies.add(credentialsPolicy);
        }
        return new HttpPipelineBuilder().policies(policies.toArray(new HttpPipelinePolicy[0])).build();
    }

    public static <A> A create(Class<A> swaggerInterface) {
        return RestProxy.create(swaggerInterface, RestProxy.createDefaultPipeline(), RestProxy.createDefaultSerializer());
    }

    public static <A> A create(Class<A> swaggerInterface, HttpPipeline httpPipeline) {
        return RestProxy.create(swaggerInterface, httpPipeline, RestProxy.createDefaultSerializer());
    }

    public static <A> A create(Class<A> swaggerInterface, HttpPipeline httpPipeline, SerializerAdapter serializer) {
        SwaggerInterfaceParser interfaceParser = new SwaggerInterfaceParser(swaggerInterface, serializer);
        RestProxy restProxy = new RestProxy(httpPipeline, serializer, interfaceParser);
        return (A)Proxy.newProxyInstance(swaggerInterface.getClassLoader(), new Class[]{swaggerInterface}, (InvocationHandler)restProxy);
    }
}

