/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.http;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpResponse;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class BufferedHttpResponse
extends HttpResponse {
    private final HttpResponse innerHttpResponse;
    private final Mono<byte[]> cachedBody;

    public BufferedHttpResponse(HttpResponse innerHttpResponse) {
        this.innerHttpResponse = innerHttpResponse;
        this.cachedBody = innerHttpResponse.bodyAsByteArray().cache();
        this.request(innerHttpResponse.request());
    }

    @Override
    public int statusCode() {
        return this.innerHttpResponse.statusCode();
    }

    @Override
    public String headerValue(String name) {
        return this.innerHttpResponse.headerValue(name);
    }

    @Override
    public HttpHeaders headers() {
        return this.innerHttpResponse.headers();
    }

    @Override
    public Mono<byte[]> bodyAsByteArray() {
        return this.cachedBody;
    }

    @Override
    public Flux<ByteBuffer> body() {
        return this.bodyAsByteArray().flatMapMany(bytes -> Flux.just((Object)ByteBuffer.wrap(bytes)));
    }

    @Override
    public Mono<String> bodyAsString() {
        return this.bodyAsByteArray().map(bytes -> bytes == null ? null : new String((byte[])bytes, StandardCharsets.UTF_8));
    }

    @Override
    public Mono<String> bodyAsString(Charset charset) {
        return this.bodyAsByteArray().map(bytes -> bytes == null ? null : new String((byte[])bytes, charset));
    }

    @Override
    public BufferedHttpResponse buffer() {
        return this;
    }
}

