/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.http.spi;

import com.azure.core.http.HttpClient;
import com.azure.core.implementation.http.spi.HttpClientProvider;
import java.util.Iterator;
import java.util.ServiceLoader;

public final class HttpClientProviders {
    private static HttpClientProvider defaultProvider;
    private static final String CANNOT_FIND_HTTP_CLIENT = "Cannot find any HttpClient provider on the classpath - unable to create a default HttpClient instance";

    private HttpClientProviders() {
    }

    public static HttpClient createInstance() {
        if (defaultProvider == null) {
            throw new IllegalStateException(CANNOT_FIND_HTTP_CLIENT);
        }
        return defaultProvider.createInstance();
    }

    static {
        ServiceLoader<HttpClientProvider> serviceLoader = ServiceLoader.load(HttpClientProvider.class);
        Iterator<HttpClientProvider> it = serviceLoader.iterator();
        if (it.hasNext()) {
            defaultProvider = it.next();
        }
    }
}

