/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.serializer;

import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Page;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.implementation.Base64Url;
import com.azure.core.implementation.DateTimeRfc1123;
import com.azure.core.implementation.UnixTime;
import com.azure.core.implementation.http.PagedResponseBase;
import com.azure.core.implementation.serializer.HttpResponseDecodeData;
import com.azure.core.implementation.serializer.ItemPage;
import com.azure.core.implementation.serializer.MalformedValueException;
import com.azure.core.implementation.serializer.SerializerAdapter;
import com.azure.core.implementation.serializer.SerializerEncoding;
import com.azure.core.implementation.util.FluxUtil;
import com.azure.core.implementation.util.TypeUtil;
import java.io.IOException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

final class HttpResponseBodyDecoder {
    HttpResponseBodyDecoder() {
    }

    static Mono<Object> decode(HttpResponse httpResponse, SerializerAdapter serializer, HttpResponseDecodeData decodeData) {
        HttpResponseBodyDecoder.ensureRequestSet(httpResponse);
        return Mono.defer(() -> {
            if (HttpResponseBodyDecoder.isErrorStatus(httpResponse, decodeData)) {
                return httpResponse.bodyAsString().flatMap(bodyString -> {
                    try {
                        Object decodedErrorEntity = HttpResponseBodyDecoder.deserializeBody(bodyString, decodeData.getUnexpectedException(httpResponse.statusCode()).exceptionBodyType(), null, serializer, SerializerEncoding.fromHeaders(httpResponse.headers()));
                        return decodedErrorEntity == null ? Mono.empty() : Mono.just((Object)decodedErrorEntity);
                    }
                    catch (MalformedValueException | IOException exception) {
                        return Mono.empty();
                    }
                });
            }
            if (httpResponse.request().httpMethod() == HttpMethod.HEAD) {
                return Mono.empty();
            }
            if (!HttpResponseBodyDecoder.isReturnTypeDecodable(decodeData)) {
                return Mono.empty();
            }
            return httpResponse.bodyAsString().flatMap(bodyString -> {
                try {
                    Object decodedSuccessEntity = HttpResponseBodyDecoder.deserializeBody(bodyString, HttpResponseBodyDecoder.extractEntityTypeFromReturnType(decodeData), decodeData.returnValueWireType(), serializer, SerializerEncoding.fromHeaders(httpResponse.headers()));
                    return decodedSuccessEntity == null ? Mono.empty() : Mono.just((Object)decodedSuccessEntity);
                }
                catch (MalformedValueException e) {
                    return Mono.error((Throwable)new HttpResponseException("HTTP response has a malformed body.", httpResponse, e));
                }
                catch (IOException e) {
                    return Mono.error((Throwable)new HttpResponseException("Deserialization Failed.", httpResponse, e));
                }
            });
        });
    }

    static boolean isDecodable(HttpResponse httpResponse, HttpResponseDecodeData decodeData) {
        HttpResponseBodyDecoder.ensureRequestSet(httpResponse);
        if (HttpResponseBodyDecoder.isErrorStatus(httpResponse, decodeData)) {
            return true;
        }
        if (httpResponse.request().httpMethod() == HttpMethod.HEAD) {
            return false;
        }
        return HttpResponseBodyDecoder.isReturnTypeDecodable(decodeData);
    }

    static Type decodedType(HttpResponse httpResponse, HttpResponseDecodeData decodeData) {
        HttpResponseBodyDecoder.ensureRequestSet(httpResponse);
        if (HttpResponseBodyDecoder.isErrorStatus(httpResponse, decodeData)) {
            return decodeData.getUnexpectedException(httpResponse.statusCode()).exceptionBodyType();
        }
        if (httpResponse.request().httpMethod() == HttpMethod.HEAD) {
            return null;
        }
        if (!HttpResponseBodyDecoder.isReturnTypeDecodable(decodeData)) {
            return null;
        }
        return HttpResponseBodyDecoder.extractEntityTypeFromReturnType(decodeData);
    }

    static boolean isErrorStatus(HttpResponse httpResponse, HttpResponseDecodeData decodeData) {
        int[] expectedStatuses = decodeData.expectedStatusCodes();
        if (expectedStatuses != null) {
            return !HttpResponseBodyDecoder.contains(expectedStatuses, httpResponse.statusCode());
        }
        return httpResponse.statusCode() / 100 != 2;
    }

    private static Object deserializeBody(String value, Type resultType, Type wireType, SerializerAdapter serializer, SerializerEncoding encoding) throws IOException {
        if (wireType == null) {
            return serializer.deserialize(value, resultType, encoding);
        }
        if (TypeUtil.isTypeOrSubTypeOf(wireType, Page.class)) {
            return HttpResponseBodyDecoder.deserializePage(value, resultType, wireType, serializer, encoding);
        }
        Type wireResponseType = HttpResponseBodyDecoder.constructWireResponseType(resultType, wireType);
        Object wireResponse = serializer.deserialize(value, wireResponseType, encoding);
        return HttpResponseBodyDecoder.convertToResultType(wireResponse, resultType, wireType);
    }

    private static Type constructWireResponseType(Type resultType, Type wireType) {
        Objects.requireNonNull(resultType);
        Objects.requireNonNull(wireType);
        Object wireResponseType = resultType;
        if (resultType == byte[].class) {
            if (wireType == Base64Url.class) {
                wireResponseType = Base64Url.class;
            }
        } else if (resultType == OffsetDateTime.class) {
            if (wireType == DateTimeRfc1123.class) {
                wireResponseType = DateTimeRfc1123.class;
            } else if (wireType == UnixTime.class) {
                wireResponseType = UnixTime.class;
            }
        } else if (TypeUtil.isTypeOrSubTypeOf(resultType, List.class)) {
            Type resultElementType = TypeUtil.getTypeArgument(resultType);
            Type wireResponseElementType = HttpResponseBodyDecoder.constructWireResponseType(resultElementType, wireType);
            wireResponseType = TypeUtil.createParameterizedType((Class)((ParameterizedType)resultType).getRawType(), wireResponseElementType);
        } else if (TypeUtil.isTypeOrSubTypeOf(resultType, Map.class) || TypeUtil.isTypeOrSubTypeOf(resultType, Response.class)) {
            Type[] typeArguments = TypeUtil.getTypeArguments(resultType);
            Type resultValueType = typeArguments[1];
            Type wireResponseValueType = HttpResponseBodyDecoder.constructWireResponseType(resultValueType, wireType);
            wireResponseType = TypeUtil.createParameterizedType((Class)((ParameterizedType)resultType).getRawType(), typeArguments[0], wireResponseValueType);
        }
        return wireResponseType;
    }

    private static Object deserializePage(String value, Type resultType, Type wireType, SerializerAdapter serializer, SerializerEncoding encoding) throws IOException {
        Type wireResponseType = wireType == Page.class ? TypeUtil.createParameterizedType(ItemPage.class, resultType) : wireType;
        return serializer.deserialize(value, wireResponseType, encoding);
    }

    private static Object convertToResultType(Object wireResponse, Type resultType, Type wireType) {
        Response result = wireResponse;
        if (wireResponse != null) {
            if (resultType == byte[].class) {
                if (wireType == Base64Url.class) {
                    result = (Response)((Base64Url)wireResponse).decodedBytes();
                }
            } else if (resultType == OffsetDateTime.class) {
                if (wireType == DateTimeRfc1123.class) {
                    result = ((DateTimeRfc1123)wireResponse).dateTime();
                } else if (wireType == UnixTime.class) {
                    result = ((UnixTime)wireResponse).dateTime();
                }
            } else if (TypeUtil.isTypeOrSubTypeOf(resultType, List.class)) {
                Type resultElementType = TypeUtil.getTypeArgument(resultType);
                List wireResponseList = (List)wireResponse;
                int wireResponseListSize = wireResponseList.size();
                for (int i = 0; i < wireResponseListSize; ++i) {
                    Object resultElement;
                    Object wireResponseElement = wireResponseList.get(i);
                    if (wireResponseElement == (resultElement = HttpResponseBodyDecoder.convertToResultType(wireResponseElement, resultElementType, wireType))) continue;
                    wireResponseList.set(i, resultElement);
                }
                result = wireResponseList;
            } else if (TypeUtil.isTypeOrSubTypeOf(resultType, Map.class)) {
                Type resultValueType = TypeUtil.getTypeArguments(resultType)[1];
                Map wireResponseMap = (Map)wireResponse;
                Set wireResponseEntries = wireResponseMap.entrySet();
                for (Map.Entry wireResponseEntry : wireResponseEntries) {
                    Object resultValue;
                    Object wireResponseValue = wireResponseEntry.getValue();
                    if (wireResponseValue == (resultValue = HttpResponseBodyDecoder.convertToResultType(wireResponseValue, resultValueType, wireType))) continue;
                    wireResponseMap.put(wireResponseEntry.getKey(), resultValue);
                }
                result = wireResponseMap;
            } else if (TypeUtil.isTypeOrSubTypeOf(resultType, PagedResponseBase.class)) {
                PagedResponseBase restResponse = (PagedResponseBase)wireResponse;
                result = new PagedResponseBase(restResponse.request(), restResponse.statusCode(), restResponse.headers(), restResponse.items(), restResponse.nextLink(), restResponse.deserializedHeaders());
            } else if (TypeUtil.isTypeOrSubTypeOf(resultType, ResponseBase.class)) {
                Object resultBody;
                ResponseBase restResponseBase = (ResponseBase)wireResponse;
                Object wireResponseBody = restResponseBase.value();
                result = wireResponseBody != (resultBody = HttpResponseBodyDecoder.convertToResultType(wireResponseBody, TypeUtil.getTypeArguments(resultType)[1], wireType)) ? new ResponseBase(restResponseBase.request(), restResponseBase.statusCode(), restResponseBase.headers(), resultBody, restResponseBase.deserializedHeaders()) : restResponseBase;
            } else if (TypeUtil.isTypeOrSubTypeOf(resultType, Response.class)) {
                Object resultBody;
                Response restResponse = (Response)wireResponse;
                Object wireResponseBody = restResponse.value();
                result = wireResponseBody != (resultBody = HttpResponseBodyDecoder.convertToResultType(wireResponseBody, TypeUtil.getTypeArguments(resultType)[1], wireType)) ? new SimpleResponse<Object>(restResponse.request(), restResponse.statusCode(), restResponse.headers(), resultBody) : restResponse;
            }
        }
        return result;
    }

    private static Type extractEntityTypeFromReturnType(HttpResponseDecodeData decodeData) {
        Type token = decodeData.returnType();
        if (token != null) {
            if (TypeUtil.isTypeOrSubTypeOf(token, Mono.class)) {
                token = TypeUtil.getTypeArgument(token);
            } else if (TypeUtil.isTypeOrSubTypeOf(token, Flux.class)) {
                Type t = TypeUtil.getTypeArgument(token);
                try {
                    if (TypeUtil.isTypeOrSubTypeOf(t, Class.forName("com.azure.core.management.implementation.OperationStatus"))) {
                        token = t;
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            if (TypeUtil.isTypeOrSubTypeOf(token, Response.class)) {
                token = TypeUtil.getRestResponseBodyType(token);
            }
            try {
                if (TypeUtil.isTypeOrSubTypeOf(token, Class.forName("com.azure.core.management.implementation.OperationStatus"))) {
                    token = TypeUtil.getTypeArgument(token);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return token;
    }

    private static boolean isReturnTypeDecodable(HttpResponseDecodeData decodeData) {
        ParameterizedType parameterizedType;
        Type returnType = decodeData.returnType();
        if (returnType == null) {
            return false;
        }
        if (TypeUtil.isTypeOrSubTypeOf(returnType, Mono.class)) {
            returnType = TypeUtil.getTypeArgument(returnType);
        }
        if (TypeUtil.isTypeOrSubTypeOf(returnType, ResponseBase.class) && (parameterizedType = (ParameterizedType)TypeUtil.getSuperType(returnType, ResponseBase.class)).getActualTypeArguments().length == 2) {
            returnType = parameterizedType.getActualTypeArguments()[1];
        }
        return !FluxUtil.isFluxByteBuffer(returnType) && !TypeUtil.isTypeOrSubTypeOf(returnType, byte[].class) && !TypeUtil.isTypeOrSubTypeOf(returnType, Void.TYPE) && !TypeUtil.isTypeOrSubTypeOf(returnType, Void.class);
    }

    private static boolean contains(int[] values, int searchValue) {
        Objects.requireNonNull(values);
        for (int value : values) {
            if (searchValue != value) continue;
            return true;
        }
        return false;
    }

    private static HttpResponse ensureRequestSet(HttpResponse httpResponse) {
        Objects.requireNonNull(httpResponse.request());
        Objects.requireNonNull(httpResponse.request().httpMethod());
        return httpResponse;
    }
}

