/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.serializer.jackson;

import com.azure.core.implementation.annotation.JsonFlatten;
import com.azure.core.implementation.util.TypeUtil;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.lang.reflect.Field;

final class FlatteningDeserializer
extends StdDeserializer<Object>
implements ResolvableDeserializer {
    private final JsonDeserializer<?> defaultDeserializer;
    private final ObjectMapper mapper;

    protected FlatteningDeserializer(Class<?> vc, JsonDeserializer<?> defaultDeserializer, ObjectMapper mapper) {
        super(vc);
        this.defaultDeserializer = defaultDeserializer;
        this.mapper = mapper;
    }

    public static SimpleModule getModule(final ObjectMapper mapper) {
        SimpleModule module = new SimpleModule();
        module.setDeserializerModifier(new BeanDeserializerModifier(){

            public JsonDeserializer<?> modifyDeserializer(DeserializationConfig config, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
                if (beanDesc.getBeanClass().getAnnotation(JsonFlatten.class) != null) {
                    return new FlatteningDeserializer(beanDesc.getBeanClass(), deserializer, mapper);
                }
                return deserializer;
            }
        });
        return module;
    }

    public Object deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        JsonNode root = (JsonNode)this.mapper.readTree(jp);
        Class tClass = this.defaultDeserializer.handledType();
        for (Class<Object> clazz : TypeUtil.getAllClasses(tClass)) {
            if (clazz.isAssignableFrom(Object.class)) continue;
            for (Field field : clazz.getDeclaredFields()) {
                String[] values;
                String value;
                JsonNode node = root;
                JsonProperty property = field.getAnnotation(JsonProperty.class);
                if (property == null || !(value = property.value()).matches(".+[^\\\\]\\..+")) continue;
                for (String val : values = value.split("((?<!\\\\))\\.")) {
                    if ((node = node.get(val = val.replace("\\.", "."))) == null) break;
                }
                ((ObjectNode)root).put(value, node);
            }
        }
        JsonParser parser = new JsonFactory().createParser(root.toString());
        parser.nextToken();
        return this.defaultDeserializer.deserialize(parser, ctxt);
    }

    public void resolve(DeserializationContext ctxt) throws JsonMappingException {
        ((ResolvableDeserializer)this.defaultDeserializer).resolve(ctxt);
    }
}

