/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.util;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class TypeUtil {
    public static List<Class<?>> getAllClasses(Class<?> clazz) {
        ArrayList types = new ArrayList();
        while (clazz != null) {
            types.add(clazz);
            clazz = clazz.getSuperclass();
        }
        return types;
    }

    public static Type[] getTypeArguments(Type type) {
        if (!(type instanceof ParameterizedType)) {
            return new Type[0];
        }
        return ((ParameterizedType)type).getActualTypeArguments();
    }

    public static Type getTypeArgument(Type type) {
        if (!(type instanceof ParameterizedType)) {
            return null;
        }
        return ((ParameterizedType)type).getActualTypeArguments()[0];
    }

    public static Class<?> getRawClass(Type type) {
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        return (Class)type;
    }

    public static Type getSuperType(Type type) {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            final Type genericSuperClass = ((Class)parameterizedType.getRawType()).getGenericSuperclass();
            if (genericSuperClass instanceof ParameterizedType) {
                final Type[] superTypeArguments = TypeUtil.getTypeArguments(genericSuperClass);
                List typeParameters = Arrays.asList(((Class)parameterizedType.getRawType()).getTypeParameters());
                int j = 0;
                for (int i = 0; i != superTypeArguments.length; ++i) {
                    if (!typeParameters.contains(superTypeArguments[i])) continue;
                    superTypeArguments[i] = parameterizedType.getActualTypeArguments()[j++];
                }
                return new ParameterizedType(){

                    @Override
                    public Type[] getActualTypeArguments() {
                        return superTypeArguments;
                    }

                    @Override
                    public Type getRawType() {
                        return ((ParameterizedType)genericSuperClass).getRawType();
                    }

                    @Override
                    public Type getOwnerType() {
                        return null;
                    }
                };
            }
            return genericSuperClass;
        }
        return ((Class)type).getGenericSuperclass();
    }

    public static Type getSuperType(Type subType, Class<?> rawSuperType) {
        while (subType != null && TypeUtil.getRawClass(subType) != rawSuperType) {
            subType = TypeUtil.getSuperType(subType);
        }
        return subType;
    }

    public static boolean isTypeOrSubTypeOf(Type subType, Type superType) {
        Class<?> sub = TypeUtil.getRawClass(subType);
        Class<?> sup = TypeUtil.getRawClass(superType);
        return sup.isAssignableFrom(sub);
    }

    public static ParameterizedType createParameterizedType(final Class<?> rawClass, final Type ... genericTypes) {
        return new ParameterizedType(){

            @Override
            public Type[] getActualTypeArguments() {
                return genericTypes;
            }

            @Override
            public Type getRawType() {
                return rawClass;
            }

            @Override
            public Type getOwnerType() {
                return null;
            }
        };
    }

    public static boolean restResponseTypeExpectsBody(ParameterizedType restResponseReturnType) {
        return TypeUtil.getRestResponseBodyType(restResponseReturnType) != Void.class;
    }

    public static Type getRestResponseBodyType(Type restResponseReturnType) {
        Type[] restResponseTypeArguments = TypeUtil.getTypeArguments(restResponseReturnType);
        if (restResponseTypeArguments != null && restResponseTypeArguments.length > 0) {
            return restResponseTypeArguments[restResponseTypeArguments.length - 1];
        }
        return TypeUtil.getRestResponseBodyType(TypeUtil.getSuperType(restResponseReturnType));
    }

    private TypeUtil() {
    }
}

