/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.credentials;

import java.time.OffsetDateTime;

public class AccessToken {
    private final String token;
    private final OffsetDateTime expiresOn;

    public AccessToken(String token, OffsetDateTime expiresOn) {
        this.token = token;
        this.expiresOn = expiresOn.minusMinutes(2L);
    }

    public String getToken() {
        return this.token;
    }

    public OffsetDateTime getExpiresOn() {
        return this.expiresOn;
    }

    public boolean isExpired() {
        return OffsetDateTime.now().isAfter(this.expiresOn);
    }
}

