/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.policy;

import com.azure.core.http.policy.HttpLogDetailLevel;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class HttpLogOptions {
    private HttpLogDetailLevel logLevel = HttpLogDetailLevel.NONE;
    private Set<String> allowedHeaderNames = new HashSet<String>();
    private Set<String> allowedQueryParamNames = new HashSet<String>();

    public HttpLogDetailLevel getLogLevel() {
        return this.logLevel;
    }

    public HttpLogOptions setLogLevel(HttpLogDetailLevel logLevel) {
        this.logLevel = logLevel == null ? HttpLogDetailLevel.NONE : logLevel;
        return this;
    }

    public Set<String> getAllowedHeaderNames() {
        return this.allowedHeaderNames;
    }

    public HttpLogOptions setAllowedHeaderNames(Set<String> allowedHeaderNames) {
        this.allowedHeaderNames = allowedHeaderNames;
        return this;
    }

    public HttpLogOptions addAllowedHeaderName(String allowedHeaderName) {
        Objects.requireNonNull(allowedHeaderName);
        this.allowedHeaderNames.add(allowedHeaderName);
        return this;
    }

    public Set<String> getAllowedQueryParamNames() {
        return this.allowedQueryParamNames;
    }

    public HttpLogOptions setAllowedQueryParamNames(Set<String> allowedQueryParamNames) {
        this.allowedQueryParamNames = allowedQueryParamNames;
        return this;
    }

    public HttpLogOptions addAllowedQueryParamName(String allowedQueryParamName) {
        this.allowedQueryParamNames.add(allowedQueryParamName);
        return this;
    }
}

