/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.rest;

import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.util.IterableStream;
import java.util.stream.Stream;

public class PagedIterable<T>
extends IterableStream<T> {
    private final PagedFlux<T> pagedFlux;

    public PagedIterable(PagedFlux<T> pagedFlux) {
        super(pagedFlux);
        this.pagedFlux = pagedFlux;
    }

    public Stream<PagedResponse<T>> streamByPage() {
        return this.pagedFlux.byPage().toStream();
    }

    public Stream<PagedResponse<T>> streamByPage(String continuationToken) {
        return this.pagedFlux.byPage(continuationToken).toStream();
    }

    public Iterable<PagedResponse<T>> iterableByPage() {
        return this.pagedFlux.byPage().toIterable();
    }

    public Iterable<PagedResponse<T>> iterableByPage(String continuationToken) {
        return this.pagedFlux.byPage(continuationToken).toIterable();
    }
}

