/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.serializer;

import com.azure.core.annotation.HeaderCollection;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpResponse;
import com.azure.core.implementation.serializer.HttpResponseDecodeData;
import com.azure.core.implementation.serializer.SerializerAdapter;
import com.azure.core.implementation.serializer.SerializerEncoding;
import com.azure.core.implementation.util.TypeUtil;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import reactor.core.publisher.Mono;

final class HttpResponseHeaderDecoder {
    HttpResponseHeaderDecoder() {
    }

    static Mono<Object> decode(HttpResponse httpResponse, SerializerAdapter serializer, HttpResponseDecodeData decodeData) {
        Type headerType = decodeData.getHeadersType();
        if (headerType == null) {
            return Mono.empty();
        }
        return Mono.defer(() -> {
            try {
                return Mono.justOrEmpty((Object)HttpResponseHeaderDecoder.deserializeHeaders(httpResponse.getHeaders(), serializer, decodeData));
            }
            catch (IOException e) {
                return Mono.error((Throwable)new HttpResponseException("HTTP response has malformed headers", httpResponse, e));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object deserializeHeaders(HttpHeaders headers, SerializerAdapter serializer, HttpResponseDecodeData decodeData) throws IOException {
        Field[] declaredFields;
        Type deserializedHeadersType = decodeData.getHeadersType();
        if (deserializedHeadersType == null) {
            return null;
        }
        String headersJsonString = serializer.serialize(headers, SerializerEncoding.JSON);
        Object deserializedHeaders = serializer.deserialize(headersJsonString, deserializedHeadersType, SerializerEncoding.JSON);
        Class<?> deserializedHeadersClass = TypeUtil.getRawClass(deserializedHeadersType);
        for (Field declaredField : declaredFields = deserializedHeadersClass.getDeclaredFields()) {
            HeaderCollection headerCollectionAnnotation;
            String headerCollectionPrefix;
            int headerCollectionPrefixLength;
            Type[] mapTypeArguments;
            if (!declaredField.isAnnotationPresent(HeaderCollection.class)) continue;
            Type declaredFieldType = declaredField.getGenericType();
            if (!TypeUtil.isTypeOrSubTypeOf(declaredField.getType(), Map.class) || (mapTypeArguments = TypeUtil.getTypeArguments(declaredFieldType)).length != 2 || mapTypeArguments[0] != String.class || mapTypeArguments[1] != String.class || (headerCollectionPrefixLength = (headerCollectionPrefix = (headerCollectionAnnotation = declaredField.getAnnotation(HeaderCollection.class)).value().toLowerCase(Locale.ROOT)).length()) <= 0) continue;
            HashMap<String, String> headerCollection = new HashMap<String, String>();
            for (HttpHeader header : headers) {
                String headerName = header.getName();
                if (!headerName.toLowerCase(Locale.ROOT).startsWith(headerCollectionPrefix)) continue;
                headerCollection.put(headerName.substring(headerCollectionPrefixLength), header.getValue());
            }
            boolean declaredFieldAccessibleBackup = declaredField.isAccessible();
            try {
                if (!declaredFieldAccessibleBackup) {
                    declaredField.setAccessible(true);
                }
                declaredField.set(deserializedHeaders, headerCollection);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            finally {
                if (!declaredFieldAccessibleBackup) {
                    declaredField.setAccessible(declaredFieldAccessibleBackup);
                }
            }
        }
        return deserializedHeaders;
    }
}

