/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.util;

import java.util.List;
import java.util.Objects;

public final class ScopeUtil {
    private static final String DEFAULT_SUFFIX = "/.default";

    public static String scopesToResource(List<String> scopes) {
        Objects.requireNonNull(scopes);
        if (scopes.size() != 1) {
            throw new IllegalArgumentException("To convert to a resource string the specified array must be exactly length 1");
        }
        if (!scopes.get(0).endsWith(DEFAULT_SUFFIX)) {
            return scopes.get(0);
        }
        return scopes.get(0).substring(0, scopes.get(0).lastIndexOf(DEFAULT_SUFFIX));
    }

    public static String[] resourceToScopes(String resource) {
        Objects.requireNonNull(resource);
        return new String[]{resource + DEFAULT_SUFFIX};
    }

    private ScopeUtil() {
    }
}

