/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class ExpandableStringEnum<T extends ExpandableStringEnum<T>> {
    private static final ConcurrentMap<String, ? extends ExpandableStringEnum<?>> VALUES_BY_NAME = new ConcurrentHashMap();
    private String name;
    private Class<T> clazz;

    private static String uniqueKey(Class<?> clazz, String name) {
        if (clazz != null) {
            return (clazz.getName() + "#" + name).toLowerCase(Locale.ROOT);
        }
        throw new IllegalArgumentException();
    }

    T nameValue(String name, T value, Class<T> clazz) {
        this.name = name;
        this.clazz = clazz;
        VALUES_BY_NAME.put(ExpandableStringEnum.uniqueKey(clazz, name), (ExpandableStringEnum<?>)value);
        return (T)this;
    }

    protected static <T extends ExpandableStringEnum<T>> T fromString(String name, Class<T> clazz) {
        ExpandableStringEnum value;
        if (name == null) {
            return null;
        }
        if (VALUES_BY_NAME != null && (value = (ExpandableStringEnum)VALUES_BY_NAME.get(ExpandableStringEnum.uniqueKey(clazz, name))) != null) {
            return (T)value;
        }
        try {
            value = (ExpandableStringEnum)clazz.newInstance();
            return (T)value.nameValue(name, value, clazz);
        }
        catch (IllegalAccessException | InstantiationException e) {
            return null;
        }
    }

    protected static <T extends ExpandableStringEnum<T>> Collection<T> values(Class<T> clazz) {
        ArrayList values = new ArrayList(VALUES_BY_NAME.values());
        HashSet<ExpandableStringEnum> list = new HashSet<ExpandableStringEnum>();
        for (ExpandableStringEnum value : values) {
            if (!value.getClass().isAssignableFrom(clazz)) continue;
            list.add(value);
        }
        return list;
    }

    @JsonValue
    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return ExpandableStringEnum.uniqueKey(this.clazz, this.name).hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.clazz == null || !this.clazz.isAssignableFrom(obj.getClass())) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (this.name == null) {
            return ((ExpandableStringEnum)obj).name == null;
        }
        return this.name.equals(((ExpandableStringEnum)obj).name);
    }
}

