/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.policy;

import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.implementation.http.UrlBuilder;
import com.azure.core.util.logging.ClientLogger;
import java.net.MalformedURLException;
import reactor.core.publisher.Mono;

public class HostPolicy
implements HttpPipelinePolicy {
    private final String host;
    private final ClientLogger logger = new ClientLogger(HostPolicy.class);

    public HostPolicy(String host) {
        this.host = host;
    }

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        Mono<HttpResponse> result;
        this.logger.info("Setting host to {}", this.host);
        UrlBuilder urlBuilder = UrlBuilder.parse(context.getHttpRequest().getUrl());
        try {
            context.getHttpRequest().setUrl(urlBuilder.setHost(this.host).toURL());
            result = next.process();
        }
        catch (MalformedURLException e) {
            result = Mono.error((Throwable)e);
        }
        return result;
    }
}

