/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.policy;

import com.azure.core.http.policy.AfterRetryPolicyProvider;
import com.azure.core.http.policy.BeforeRetryPolicyProvider;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.PolicyProvider;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.function.Supplier;

public final class HttpPolicyProviders {
    private static final Map<Class<? extends PolicyProvider>, ServiceLoader<? extends PolicyProvider>> SERVICE_LOADERS = new HashMap<Class<? extends PolicyProvider>, ServiceLoader<? extends PolicyProvider>>();

    private HttpPolicyProviders() {
    }

    public static void addBeforeRetryPolicies(List<HttpPipelinePolicy> policies) {
        HttpPolicyProviders.addRetryPolicies(policies, () -> HttpPolicyProviders.getPolicyProviders(false, BeforeRetryPolicyProvider.class));
    }

    public static void addAfterRetryPolicies(List<HttpPipelinePolicy> policies) {
        HttpPolicyProviders.addRetryPolicies(policies, () -> HttpPolicyProviders.getPolicyProviders(false, AfterRetryPolicyProvider.class));
    }

    private static void addRetryPolicies(List<HttpPipelinePolicy> policies, Supplier<Iterator<? extends PolicyProvider>> policySupplier) {
        Iterator<? extends PolicyProvider> it = policySupplier.get();
        while (it.hasNext()) {
            PolicyProvider policyProvider = it.next();
            HttpPipelinePolicy policy = policyProvider.create();
            if (policy == null) {
                throw new NullPointerException("HttpPipelinePolicy created with " + policyProvider.getClass() + " resulted in a null policy");
            }
            policies.add(policy);
        }
    }

    private static Iterator<? extends PolicyProvider> getPolicyProviders(boolean reload, Class<? extends PolicyProvider> cls) {
        ServiceLoader serviceLoader = SERVICE_LOADERS.computeIfAbsent(cls, ServiceLoader::load);
        if (reload) {
            serviceLoader.reload();
        }
        return serviceLoader.iterator();
    }
}

