/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.policy;

import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.implementation.http.UrlBuilder;
import com.azure.core.util.logging.ClientLogger;
import java.net.MalformedURLException;
import reactor.core.publisher.Mono;

public class PortPolicy
implements HttpPipelinePolicy {
    private final int port;
    private final boolean overwrite;
    private final ClientLogger logger = new ClientLogger(PortPolicy.class);

    public PortPolicy(int port, boolean overwrite) {
        this.port = port;
        this.overwrite = overwrite;
    }

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        UrlBuilder urlBuilder = UrlBuilder.parse(context.getHttpRequest().getUrl());
        if (this.overwrite || urlBuilder.getPort() == null) {
            this.logger.info("Changing port to {}", this.port);
            try {
                context.getHttpRequest().setUrl(urlBuilder.setPort(this.port).toURL());
            }
            catch (MalformedURLException e) {
                return Mono.error((Throwable)e);
            }
        }
        return next.process();
    }
}

