/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.rest;

import com.azure.core.http.rest.PagedResponse;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.reactivestreams.Publisher;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PagedFluxBase<T, P extends PagedResponse<T>>
extends Flux<T> {
    private final Supplier<Mono<P>> firstPageRetriever;
    private final Function<String, Mono<P>> nextPageRetriever;

    public PagedFluxBase(Supplier<Mono<P>> firstPageRetriever) {
        this(firstPageRetriever, token -> Mono.empty());
    }

    public PagedFluxBase(Supplier<Mono<P>> firstPageRetriever, Function<String, Mono<P>> nextPageRetriever) {
        Objects.requireNonNull(firstPageRetriever, "'firstPageRetriever' cannot be null.");
        Objects.requireNonNull(nextPageRetriever, "'nextPageRetriever' function cannot be null.");
        this.firstPageRetriever = firstPageRetriever;
        this.nextPageRetriever = nextPageRetriever;
    }

    public Flux<P> byPage() {
        return this.firstPageRetriever.get().flatMapMany(this::extractAndFetchPage);
    }

    public Flux<P> byPage(String continuationToken) {
        return this.nextPageRetriever.apply(continuationToken).flatMapMany(this::extractAndFetchPage);
    }

    public void subscribe(CoreSubscriber<? super T> coreSubscriber) {
        this.byT(null).subscribe(coreSubscriber);
    }

    private Flux<T> byT(String continuationToken) {
        if (continuationToken == null) {
            return this.firstPageRetriever.get().flatMapMany(this::extractAndFetchT);
        }
        return this.nextPageRetriever.apply(continuationToken).flatMapMany(this::extractAndFetchT);
    }

    private Publisher<T> extractAndFetchT(PagedResponse<T> page) {
        String nextPageLink = page.getNextLink();
        if (nextPageLink == null) {
            return Flux.fromIterable(page.getItems());
        }
        return Flux.fromIterable(page.getItems()).concatWith(this.byT(nextPageLink));
    }

    private Publisher<? extends P> extractAndFetchPage(P page) {
        String nextPageLink = page.getNextLink();
        if (nextPageLink == null) {
            return Flux.just(page);
        }
        return Flux.just(page).concatWith(this.byPage(page.getNextLink()));
    }
}

