/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.policy;

import com.azure.core.http.policy.HttpLogDetailLevel;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class HttpLogOptions {
    private HttpLogDetailLevel logLevel = HttpLogDetailLevel.NONE;
    private Set<String> allowedHeaderNames = new HashSet<String>(DEFAULT_HEADERS_WHITELIST);
    private Set<String> allowedQueryParamNames = new HashSet<String>();
    private static final List<String> DEFAULT_HEADERS_WHITELIST = Arrays.asList("x-ms-client-request-id", "x-ms-return-client-request-id", "traceparent", "Accept", "Cache-Control", "Connection", "Content-Length", "Content-Type", "Date", "ETag", "Expires", "If-Match", "If-Modified-Since", "If-None-Match", "If-Unmodified-Since", "Last-Modified", "Pragma", "Request-Id", "Retry-After", "Server", "Transfer-Encoding", "User-Agent");

    public HttpLogDetailLevel getLogLevel() {
        return this.logLevel;
    }

    public HttpLogOptions setLogLevel(HttpLogDetailLevel logLevel) {
        this.logLevel = logLevel == null ? HttpLogDetailLevel.NONE : logLevel;
        return this;
    }

    public Set<String> getAllowedHeaderNames() {
        return this.allowedHeaderNames;
    }

    public HttpLogOptions setAllowedHeaderNames(Set<String> allowedHeaderNames) {
        this.allowedHeaderNames = allowedHeaderNames == null ? new HashSet() : allowedHeaderNames;
        return this;
    }

    public HttpLogOptions addAllowedHeaderName(String allowedHeaderName) {
        Objects.requireNonNull(allowedHeaderName);
        this.allowedHeaderNames.add(allowedHeaderName);
        return this;
    }

    public Set<String> getAllowedQueryParamNames() {
        return this.allowedQueryParamNames;
    }

    public HttpLogOptions setAllowedQueryParamNames(Set<String> allowedQueryParamNames) {
        this.allowedQueryParamNames = allowedQueryParamNames == null ? new HashSet() : allowedQueryParamNames;
        return this;
    }

    public HttpLogOptions addAllowedQueryParamName(String allowedQueryParamName) {
        this.allowedQueryParamNames.add(allowedQueryParamName);
        return this;
    }
}

