/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.serializer.jackson;

import com.azure.core.annotation.HeaderCollection;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaders;
import com.azure.core.implementation.CollectionFormat;
import com.azure.core.implementation.serializer.MalformedValueException;
import com.azure.core.implementation.serializer.SerializerAdapter;
import com.azure.core.implementation.serializer.SerializerEncoding;
import com.azure.core.implementation.serializer.jackson.AdditionalPropertiesDeserializer;
import com.azure.core.implementation.serializer.jackson.AdditionalPropertiesSerializer;
import com.azure.core.implementation.serializer.jackson.Base64UrlSerializer;
import com.azure.core.implementation.serializer.jackson.ByteArraySerializer;
import com.azure.core.implementation.serializer.jackson.DateTimeRfc1123Serializer;
import com.azure.core.implementation.serializer.jackson.DateTimeSerializer;
import com.azure.core.implementation.serializer.jackson.DurationSerializer;
import com.azure.core.implementation.serializer.jackson.FlatteningDeserializer;
import com.azure.core.implementation.serializer.jackson.FlatteningSerializer;
import com.azure.core.implementation.serializer.jackson.HttpHeadersSerializer;
import com.azure.core.implementation.util.TypeUtil;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.dataformat.xml.ser.ToXmlGenerator;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class JacksonAdapter
implements SerializerAdapter {
    private final ClientLogger logger = new ClientLogger(JacksonAdapter.class);
    private final ObjectMapper mapper;
    private final ObjectMapper simpleMapper = JacksonAdapter.initializeObjectMapper(new ObjectMapper());
    private final XmlMapper xmlMapper = JacksonAdapter.initializeObjectMapper(new XmlMapper());
    private final ObjectMapper headerMapper;
    private static SerializerAdapter serializerAdapter;
    private static final String BOM = "\ufeff";

    public JacksonAdapter() {
        this.xmlMapper.configure(ToXmlGenerator.Feature.WRITE_XML_DECLARATION, true);
        this.xmlMapper.setDefaultUseWrapper(false);
        ObjectMapper flatteningMapper = JacksonAdapter.initializeObjectMapper(new ObjectMapper()).registerModule((Module)FlatteningSerializer.getModule(this.simpleMapper())).registerModule((Module)FlatteningDeserializer.getModule(this.simpleMapper()));
        this.mapper = JacksonAdapter.initializeObjectMapper(new ObjectMapper()).registerModule((Module)AdditionalPropertiesSerializer.getModule(flatteningMapper)).registerModule((Module)AdditionalPropertiesDeserializer.getModule(flatteningMapper)).registerModule((Module)FlatteningSerializer.getModule(this.simpleMapper())).registerModule((Module)FlatteningDeserializer.getModule(this.simpleMapper()));
        this.headerMapper = this.simpleMapper.copy().configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true);
    }

    protected ObjectMapper simpleMapper() {
        return this.simpleMapper;
    }

    public static synchronized SerializerAdapter createDefaultSerializerAdapter() {
        if (serializerAdapter == null) {
            serializerAdapter = new JacksonAdapter();
        }
        return serializerAdapter;
    }

    public ObjectMapper serializer() {
        return this.mapper;
    }

    @Override
    public String serialize(Object object, SerializerEncoding encoding) throws IOException {
        if (object == null) {
            return null;
        }
        StringWriter writer = new StringWriter();
        if (encoding == SerializerEncoding.XML) {
            this.xmlMapper.writeValue((Writer)writer, object);
        } else {
            this.serializer().writeValue((Writer)writer, object);
        }
        return writer.toString();
    }

    @Override
    public String serializeRaw(Object object) {
        if (object == null) {
            return null;
        }
        try {
            return this.serialize(object, SerializerEncoding.JSON).replaceAll("^\"*", "").replaceAll("\"*$", "");
        }
        catch (IOException ex) {
            this.logger.warning("Failed to serialize {} to JSON.", object.getClass(), ex);
            return null;
        }
    }

    @Override
    public String serializeList(List<?> list, CollectionFormat format) {
        if (list == null) {
            return null;
        }
        ArrayList<String> serialized = new ArrayList<String>();
        for (Object element : list) {
            String raw = this.serializeRaw(element);
            serialized.add(raw != null ? raw : "");
        }
        return String.join((CharSequence)format.getDelimiter(), serialized);
    }

    public <T> T deserialize(String value, Type type, SerializerEncoding encoding) throws IOException {
        if (value == null || value.isEmpty() || value.equals(BOM)) {
            return null;
        }
        if (value.startsWith(BOM)) {
            value = value.replaceFirst(BOM, "");
        }
        JavaType javaType = this.createJavaType(type);
        try {
            if (encoding == SerializerEncoding.XML) {
                return (T)this.xmlMapper.readValue(value, javaType);
            }
            return (T)this.serializer().readValue(value, javaType);
        }
        catch (JsonParseException jpe) {
            throw this.logger.logExceptionAsError(new MalformedValueException(jpe.getMessage(), jpe));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T deserialize(HttpHeaders headers, Type deserializedHeadersType) throws IOException {
        Field[] declaredFields;
        if (deserializedHeadersType == null) {
            return null;
        }
        String headersJsonString = this.headerMapper.writeValueAsString((Object)headers);
        Object deserializedHeaders = this.headerMapper.readValue(headersJsonString, this.createJavaType(deserializedHeadersType));
        Class<?> deserializedHeadersClass = TypeUtil.getRawClass(deserializedHeadersType);
        for (Field declaredField : declaredFields = deserializedHeadersClass.getDeclaredFields()) {
            HeaderCollection headerCollectionAnnotation;
            String headerCollectionPrefix;
            int headerCollectionPrefixLength;
            Type[] mapTypeArguments;
            if (!declaredField.isAnnotationPresent(HeaderCollection.class)) continue;
            Type declaredFieldType = declaredField.getGenericType();
            if (!TypeUtil.isTypeOrSubTypeOf(declaredField.getType(), Map.class) || (mapTypeArguments = TypeUtil.getTypeArguments(declaredFieldType)).length != 2 || mapTypeArguments[0] != String.class || mapTypeArguments[1] != String.class || (headerCollectionPrefixLength = (headerCollectionPrefix = (headerCollectionAnnotation = declaredField.getAnnotation(HeaderCollection.class)).value().toLowerCase(Locale.ROOT)).length()) <= 0) continue;
            HashMap<String, String> headerCollection = new HashMap<String, String>();
            for (HttpHeader header : headers) {
                String headerName = header.getName();
                if (!headerName.toLowerCase(Locale.ROOT).startsWith(headerCollectionPrefix)) continue;
                headerCollection.put(headerName.substring(headerCollectionPrefixLength), header.getValue());
            }
            boolean declaredFieldAccessibleBackup = declaredField.isAccessible();
            try {
                if (!declaredFieldAccessibleBackup) {
                    AccessController.doPrivileged(() -> {
                        declaredField.setAccessible(true);
                        return null;
                    });
                }
                declaredField.set(deserializedHeaders, headerCollection);
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            finally {
                if (!declaredFieldAccessibleBackup) {
                    AccessController.doPrivileged(() -> {
                        declaredField.setAccessible(declaredFieldAccessibleBackup);
                        return null;
                    });
                }
            }
        }
        return (T)deserializedHeaders;
    }

    private static <T extends ObjectMapper> T initializeObjectMapper(T mapper) {
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false).configure(SerializationFeature.WRITE_EMPTY_JSON_ARRAYS, true).configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false).configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true).configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false).configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true).setSerializationInclusion(JsonInclude.Include.NON_NULL).registerModule((Module)new JavaTimeModule()).registerModule((Module)ByteArraySerializer.getModule()).registerModule((Module)Base64UrlSerializer.getModule()).registerModule((Module)DateTimeSerializer.getModule()).registerModule((Module)DateTimeRfc1123Serializer.getModule()).registerModule((Module)DurationSerializer.getModule()).registerModule((Module)HttpHeadersSerializer.getModule());
        mapper.setVisibility(mapper.getSerializationConfig().getDefaultVisibilityChecker().withFieldVisibility(JsonAutoDetect.Visibility.ANY).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withIsGetterVisibility(JsonAutoDetect.Visibility.NONE));
        return mapper;
    }

    private JavaType createJavaType(Type type) {
        JavaType result;
        if (type == null) {
            result = null;
        } else if (type instanceof JavaType) {
            result = (JavaType)type;
        } else if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            JavaType[] javaTypeArguments = new JavaType[actualTypeArguments.length];
            for (int i = 0; i != actualTypeArguments.length; ++i) {
                javaTypeArguments[i] = this.createJavaType(actualTypeArguments[i]);
            }
            result = this.mapper.getTypeFactory().constructParametricType((Class)parameterizedType.getRawType(), javaTypeArguments);
        } else {
            result = this.mapper.getTypeFactory().constructType(type);
        }
        return result;
    }
}

