/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.logging;

import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import java.util.Arrays;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientLogger {
    private final Logger logger;
    private static final int VERBOSE_LEVEL = 1;
    private static final int INFORMATIONAL_LEVEL = 2;
    private static final int WARNING_LEVEL = 3;
    private static final int ERROR_LEVEL = 4;
    private static final int DISABLED_LEVEL = 5;

    public ClientLogger(Class<?> clazz) {
        this(clazz.getName());
    }

    public ClientLogger(String className) {
        this.logger = LoggerFactory.getLogger((String)className);
    }

    public void verbose(String format, Object ... args) {
        this.log(1, format, args);
    }

    public void info(String format, Object ... args) {
        this.log(2, format, args);
    }

    public void warning(String format, Object ... args) {
        this.log(3, format, args);
    }

    public void error(String format, Object ... args) {
        this.log(4, format, args);
    }

    private void log(int logLevel, String format, Object ... args) {
        int environmentLoggingLevel = this.getEnvironmentLoggingLevel();
        if (this.canLogAtLevel(logLevel, environmentLoggingLevel)) {
            this.performLogging(logLevel, environmentLoggingLevel, false, format, args);
        }
    }

    public RuntimeException logExceptionAsWarning(RuntimeException runtimeException) {
        return this.logException(runtimeException, 3);
    }

    public RuntimeException logExceptionAsError(RuntimeException runtimeException) {
        return this.logException(runtimeException, 4);
    }

    private RuntimeException logException(RuntimeException runtimeException, int logLevel) {
        Objects.requireNonNull(runtimeException, "'runtimeException' cannot be null.");
        int environmentLoggingLevel = this.getEnvironmentLoggingLevel();
        if (this.canLogAtLevel(logLevel, environmentLoggingLevel)) {
            this.performLogging(logLevel, environmentLoggingLevel, true, runtimeException.getMessage(), runtimeException);
        }
        return runtimeException;
    }

    private void performLogging(int logLevel, int environmentLogLevel, boolean isExceptionLogging, String format, Object ... args) {
        String throwableMessage = "";
        if (this.doesArgsHaveThrowable(args)) {
            Object throwable;
            if (!isExceptionLogging && (throwable = args[args.length - 1]) instanceof Throwable) {
                throwableMessage = ((Throwable)throwable).getMessage();
            }
            if (environmentLogLevel > 1) {
                args = this.removeThrowable(args);
            }
        }
        switch (logLevel) {
            case 1: {
                this.logger.debug(format, args);
                break;
            }
            case 2: {
                this.logger.info(format, args);
                break;
            }
            case 3: {
                if (!CoreUtils.isNullOrEmpty(throwableMessage)) {
                    format = format + System.lineSeparator() + throwableMessage;
                }
                this.logger.warn(format, args);
                break;
            }
            case 4: {
                if (!CoreUtils.isNullOrEmpty(throwableMessage)) {
                    format = format + System.lineSeparator() + throwableMessage;
                }
                this.logger.error(format, args);
                break;
            }
        }
    }

    private int getEnvironmentLoggingLevel() {
        return Configuration.getGlobalConfiguration().get("AZURE_LOG_LEVEL", 5);
    }

    private boolean canLogAtLevel(int logLevel, int environmentLoggingLevel) {
        if (logLevel < environmentLoggingLevel) {
            return false;
        }
        switch (logLevel) {
            case 1: {
                return this.logger.isDebugEnabled();
            }
            case 2: {
                return this.logger.isInfoEnabled();
            }
            case 3: {
                return this.logger.isWarnEnabled();
            }
            case 4: {
                return this.logger.isErrorEnabled();
            }
        }
        return false;
    }

    private boolean doesArgsHaveThrowable(Object ... args) {
        if (args.length == 0) {
            return false;
        }
        return args[args.length - 1] instanceof Throwable;
    }

    private Object[] removeThrowable(Object ... args) {
        return Arrays.copyOf(args, args.length - 1);
    }
}

