/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.serializer;

import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.JsonSerializer;
import com.azure.core.util.serializer.SerializerAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.azure.core.util.serializer.TypeReference;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import reactor.core.publisher.Mono;

public class JacksonSerializer
implements JsonSerializer {
    private final SerializerAdapter jacksonAdapter = JacksonAdapter.createDefaultSerializerAdapter();
    private final ClientLogger logger = new ClientLogger(JacksonSerializer.class);

    @Override
    public <T> T deserialize(InputStream stream, TypeReference<T> typeReference) {
        try {
            return this.jacksonAdapter.deserialize(stream, typeReference.getJavaType(), SerializerEncoding.JSON);
        }
        catch (IOException e) {
            throw this.logger.logExceptionAsError(new UncheckedIOException(e));
        }
    }

    @Override
    public <T> Mono<T> deserializeAsync(InputStream stream, TypeReference<T> typeReference) {
        return Mono.defer(() -> Mono.fromCallable(() -> this.deserialize(stream, typeReference)));
    }

    @Override
    public void serialize(OutputStream stream, Object value) {
        try {
            this.jacksonAdapter.serialize(value, SerializerEncoding.JSON, stream);
        }
        catch (IOException e) {
            throw this.logger.logExceptionAsError(new UncheckedIOException(e));
        }
    }

    @Override
    public Mono<Void> serializeAsync(OutputStream stream, Object value) {
        return Mono.fromRunnable(() -> this.serialize(stream, value));
    }
}

