/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JsonSerializer;
import com.azure.core.util.serializer.JsonSerializerProviders;
import com.azure.core.util.serializer.ObjectSerializer;
import com.azure.core.util.serializer.TypeReference;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Objects;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class BinaryData {
    private static final ClientLogger LOGGER = new ClientLogger(BinaryData.class);
    private static final BinaryData EMPTY_DATA = new BinaryData(new byte[0]);
    private static final int STREAM_READ_SIZE = 1024;
    private static final Object LOCK = new Object();
    private static volatile JsonSerializer defaultJsonSerializer;
    private final byte[] data;
    private String dataAsStringCache;

    BinaryData(byte[] data) {
        this.data = data;
    }

    public static BinaryData fromStream(InputStream inputStream) {
        if (Objects.isNull(inputStream)) {
            return EMPTY_DATA;
        }
        try {
            int nRead;
            ByteArrayOutputStream dataOutputBuffer = new ByteArrayOutputStream();
            byte[] data = new byte[1024];
            while ((nRead = inputStream.read(data, 0, data.length)) != -1) {
                dataOutputBuffer.write(data, 0, nRead);
            }
            return new BinaryData(dataOutputBuffer.toByteArray());
        }
        catch (IOException ex) {
            throw LOGGER.logExceptionAsError(new UncheckedIOException(ex));
        }
    }

    public static Mono<BinaryData> fromStreamAsync(InputStream inputStream) {
        return Mono.fromCallable(() -> BinaryData.fromStream(inputStream));
    }

    public static Mono<BinaryData> fromFlux(Flux<ByteBuffer> data) {
        if (Objects.isNull(data)) {
            return Mono.just((Object)EMPTY_DATA);
        }
        return FluxUtil.collectBytesInByteBufferStream(data).flatMap(bytes -> Mono.just((Object)new BinaryData((byte[])bytes)));
    }

    public static BinaryData fromString(String data) {
        if (CoreUtils.isNullOrEmpty(data)) {
            return EMPTY_DATA;
        }
        return new BinaryData(data.getBytes(StandardCharsets.UTF_8));
    }

    public static BinaryData fromBytes(byte[] data) {
        if (Objects.isNull(data) || data.length == 0) {
            return EMPTY_DATA;
        }
        return new BinaryData(Arrays.copyOf(data, data.length));
    }

    public static BinaryData fromObject(Object data) {
        return BinaryData.fromObject(data, BinaryData.getDefaultSerializer());
    }

    public static Mono<BinaryData> fromObjectAsync(Object data) {
        return BinaryData.fromObjectAsync(data, BinaryData.getDefaultSerializer());
    }

    public static BinaryData fromObject(Object data, ObjectSerializer serializer) {
        if (Objects.isNull(data)) {
            return EMPTY_DATA;
        }
        Objects.requireNonNull(serializer, "'serializer' cannot be null.");
        return new BinaryData(serializer.serializeToBytes(data));
    }

    public static Mono<BinaryData> fromObjectAsync(Object data, ObjectSerializer serializer) {
        return Mono.fromCallable(() -> BinaryData.fromObject(data, serializer));
    }

    public byte[] toBytes() {
        return Arrays.copyOf(this.data, this.data.length);
    }

    public String toString() {
        if (this.dataAsStringCache == null) {
            this.dataAsStringCache = new String(this.data, StandardCharsets.UTF_8);
        }
        return this.dataAsStringCache;
    }

    public <T> T toObject(Class<T> clazz) {
        return this.toObject(TypeReference.createInstance(clazz), (ObjectSerializer)BinaryData.getDefaultSerializer());
    }

    public <T> T toObject(TypeReference<T> typeReference) {
        return this.toObject(typeReference, (ObjectSerializer)BinaryData.getDefaultSerializer());
    }

    public <T> T toObject(Class<T> clazz, ObjectSerializer serializer) {
        return this.toObject(TypeReference.createInstance(clazz), serializer);
    }

    public <T> T toObject(TypeReference<T> typeReference, ObjectSerializer serializer) {
        Objects.requireNonNull(typeReference, "'typeReference' cannot be null.");
        Objects.requireNonNull(serializer, "'serializer' cannot be null.");
        return serializer.deserializeFromBytes(this.data, typeReference);
    }

    public <T> Mono<T> toObjectAsync(Class<T> clazz) {
        return this.toObjectAsync(TypeReference.createInstance(clazz), (ObjectSerializer)BinaryData.getDefaultSerializer());
    }

    public <T> Mono<T> toObjectAsync(TypeReference<T> typeReference) {
        return this.toObjectAsync(typeReference, (ObjectSerializer)BinaryData.getDefaultSerializer());
    }

    public <T> Mono<T> toObjectAsync(Class<T> clazz, ObjectSerializer serializer) {
        return this.toObjectAsync(TypeReference.createInstance(clazz), serializer);
    }

    public <T> Mono<T> toObjectAsync(TypeReference<T> typeReference, ObjectSerializer serializer) {
        return Mono.fromCallable(() -> this.toObject(typeReference, serializer));
    }

    public InputStream toStream() {
        return new ByteArrayInputStream(this.data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JsonSerializer getDefaultSerializer() {
        if (defaultJsonSerializer == null) {
            Object object = LOCK;
            synchronized (object) {
                if (defaultJsonSerializer == null) {
                    defaultJsonSerializer = JsonSerializerProviders.createInstance();
                }
            }
        }
        return defaultJsonSerializer;
    }
}

