/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.serializer;

import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpResponse;
import com.azure.core.implementation.serializer.HttpResponseDecodeData;
import com.azure.core.util.serializer.SerializerAdapter;
import java.io.IOException;
import java.lang.reflect.Type;
import reactor.core.publisher.Mono;

final class HttpResponseHeaderDecoder {
    private static final String MALFORMED_HEADERS_MESSAGE = "HTTP response has malformed headers";

    HttpResponseHeaderDecoder() {
    }

    static Mono<Object> decode(HttpResponse response, SerializerAdapter serializer, HttpResponseDecodeData decodeData) {
        Type headerType = decodeData.getHeadersType();
        if (headerType == null) {
            return Mono.empty();
        }
        return Mono.fromCallable(() -> serializer.deserialize(response.getHeaders(), headerType)).onErrorMap(IOException.class, e -> new HttpResponseException(MALFORMED_HEADERS_MESSAGE, response, (Throwable)e));
    }
}

