/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.serializer;

import com.azure.core.implementation.serializer.DefaultJsonSerializer;
import com.azure.core.util.serializer.JsonSerializer;
import com.azure.core.util.serializer.JsonSerializerProvider;
import java.util.Iterator;
import java.util.ServiceLoader;

public final class JsonSerializerProviders {
    private static final String CANNOT_FIND_JSON_SERIALIZER_PROVIDER = "A request was made to load the default JSON serializer provider but one could not be found on the classpath. If you are using a dependency manager, consider including a dependency on azure-core-serializer-json-jackson or azure-core-serializer-json-gson. Depending on your existing dependencies, you have the choice of Jackson or GSON implementations. Additionally, refer to https://aka.ms/azsdk/java/docs/custom-jsonserializer to learn about writing your own implementation.";
    private static JsonSerializerProvider jsonSerializerProvider;
    private static boolean attemptedLoad;

    public static JsonSerializer createInstance() {
        return JsonSerializerProviders.createInstance(false);
    }

    public static JsonSerializer createInstance(boolean useDefaultIfAbsent) {
        if (jsonSerializerProvider == null) {
            JsonSerializerProviders.loadDefaultSerializer();
        }
        if (jsonSerializerProvider != null) {
            return jsonSerializerProvider.createInstance();
        }
        if (useDefaultIfAbsent) {
            return new DefaultJsonSerializer();
        }
        throw new IllegalStateException(CANNOT_FIND_JSON_SERIALIZER_PROVIDER);
    }

    private static synchronized void loadDefaultSerializer() {
        if (attemptedLoad) {
            return;
        }
        attemptedLoad = true;
        Iterator<JsonSerializerProvider> iterator = ServiceLoader.load(JsonSerializerProvider.class).iterator();
        if (iterator.hasNext()) {
            jsonSerializerProvider = iterator.next();
        }
    }

    private JsonSerializerProviders() {
    }
}

