/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.credential;

import com.azure.core.credential.AzureNamedKey;
import com.azure.core.util.logging.ClientLogger;
import java.util.Objects;

public final class AzureNamedKeyCredential {
    private final ClientLogger logger = new ClientLogger(AzureNamedKeyCredential.class);
    private volatile AzureNamedKey credentials;

    public AzureNamedKeyCredential(String name, String key) {
        this.validateInputParameters(name, key);
        this.credentials = new AzureNamedKey(name, key);
    }

    public AzureNamedKey getAzureNamedKey() {
        return this.credentials;
    }

    public AzureNamedKeyCredential update(String name, String key) {
        this.validateInputParameters(name, key);
        this.credentials = new AzureNamedKey(name, key);
        return this;
    }

    private void validateInputParameters(String name, String key) {
        Objects.requireNonNull(name, "'name' cannot be null.");
        Objects.requireNonNull(key, "'key' cannot be null.");
        if (name.isEmpty()) {
            throw this.logger.logExceptionAsError(new IllegalArgumentException("'name' cannot be empty."));
        }
        if (key.isEmpty()) {
            throw this.logger.logExceptionAsError(new IllegalArgumentException("'key' cannot be empty."));
        }
    }
}

