/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util.serializer;

import com.azure.core.annotation.JsonFlatten;
import com.azure.core.util.logging.ClientLogger;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.jsontype.TypeSerializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.ResolvableSerializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

class FlatteningSerializer
extends StdSerializer<Object>
implements ResolvableSerializer {
    private static final long serialVersionUID = -6130180289951110573L;
    private static final Pattern CHECK_IF_FLATTEN_PROPERTY_PATTERN = Pattern.compile(".+[^\\\\]\\..+");
    private static final Pattern SPLIT_FLATTEN_PROPERTY_PATTERN = Pattern.compile("((?<!\\\\))\\.");
    private static final Pattern CREATE_ESCAPED_MAP_PATTERN = Pattern.compile("((?<!\\\\))\\.");
    private static final Pattern CHECK_IF_ESCAPED_MAP_PATTERN = Pattern.compile(".*[^\\\\]\\\\..+");
    private static final Pattern REPLACE_ESCAPED_MAP_PATTERN = Pattern.compile("\\\\.");
    private final ClientLogger logger = new ClientLogger(FlatteningSerializer.class);
    private final JsonSerializer<?> defaultSerializer;
    private final ObjectMapper mapper;
    private final boolean classHasJsonFlatten;
    private final Set<String> jsonPropertiesWithJsonFlatten;

    FlatteningSerializer(BeanDescription beanDesc, JsonSerializer<?> defaultSerializer, ObjectMapper mapper) {
        super(beanDesc.getBeanClass(), false);
        this.defaultSerializer = defaultSerializer;
        this.mapper = mapper;
        this.classHasJsonFlatten = beanDesc.getClassAnnotations().has(JsonFlatten.class);
        this.jsonPropertiesWithJsonFlatten = this.classHasJsonFlatten ? Collections.emptySet() : beanDesc.findProperties().stream().filter(BeanPropertyDefinition::hasField).filter(property -> property.getField().hasAnnotation(JsonFlatten.class)).map(BeanPropertyDefinition::getName).collect(Collectors.toSet());
    }

    public static SimpleModule getModule(final ObjectMapper mapper) {
        SimpleModule module = new SimpleModule();
        module.setSerializerModifier(new BeanSerializerModifier(){

            public JsonSerializer<?> modifySerializer(SerializationConfig config, BeanDescription beanDesc, JsonSerializer<?> serializer) {
                boolean hasJsonFlattenOnClass = beanDesc.getClassAnnotations().has(JsonFlatten.class);
                boolean hasJsonFlattenOnProperty = beanDesc.findProperties().stream().filter(BeanPropertyDefinition::hasField).map(BeanPropertyDefinition::getField).anyMatch(field -> field.hasAnnotation(JsonFlatten.class));
                if (hasJsonFlattenOnClass || hasJsonFlattenOnProperty) {
                    return new FlatteningSerializer(beanDesc, serializer, mapper);
                }
                return serializer;
            }
        });
        return module;
    }

    private List<Field> getAllDeclaredFields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        while (clazz != null && !clazz.equals(Object.class)) {
            for (Field f : clazz.getDeclaredFields()) {
                int mod = f.getModifiers();
                if (Modifier.isFinal(mod) || Modifier.isStatic(mod)) continue;
                fields.add(f);
            }
            clazz = clazz.getSuperclass();
        }
        return fields;
    }

    private void escapeMapKeys(Object value) {
        if (value == null) {
            return;
        }
        if (value.getClass().isPrimitive() || value.getClass().isEnum() || value instanceof OffsetDateTime || value instanceof Duration || value instanceof String) {
            return;
        }
        if (value instanceof Map) {
            for (String key : new HashSet(((Map)value).keySet())) {
                if (!key.contains(".")) continue;
                String newKey = CREATE_ESCAPED_MAP_PATTERN.matcher(key).replaceAll("\\\\.");
                Object val = ((Map)value).remove(key);
                ((Map)value).put(newKey, val);
            }
            for (Object val : ((Map)value).values()) {
                this.escapeMapKeys(val);
            }
            return;
        }
        if (value instanceof List) {
            for (Object val : (List)value) {
                this.escapeMapKeys(val);
            }
            return;
        }
        int mod = value.getClass().getModifiers();
        if (Modifier.isFinal(mod) || Modifier.isStatic(mod)) {
            return;
        }
        for (Field f : this.getAllDeclaredFields(value.getClass())) {
            f.setAccessible(true);
            try {
                this.escapeMapKeys(f.get(value));
            }
            catch (IllegalAccessException e) {
                throw this.logger.logExceptionAsError(new RuntimeException(e));
            }
        }
    }

    public void serialize(Object value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        if (value == null) {
            jgen.writeNull();
            return;
        }
        this.escapeMapKeys(value);
        ObjectNode root = (ObjectNode)this.mapper.valueToTree(value);
        ObjectNode res = root.deepCopy();
        LinkedBlockingQueue<ObjectNode> source = new LinkedBlockingQueue<ObjectNode>();
        LinkedBlockingQueue<ObjectNode> target = new LinkedBlockingQueue<ObjectNode>();
        source.add(root);
        target.add(res);
        while (!source.isEmpty()) {
            ObjectNode current = (ObjectNode)source.poll();
            ObjectNode resCurrent = (ObjectNode)target.poll();
            Iterator fields = current.fields();
            while (fields.hasNext()) {
                Map.Entry field = (Map.Entry)fields.next();
                ObjectNode node = resCurrent;
                String key = (String)field.getKey();
                JsonNode outNode = resCurrent.get(key);
                if (!this.classHasJsonFlatten && !this.jsonPropertiesWithJsonFlatten.contains(key)) continue;
                if (CHECK_IF_FLATTEN_PROPERTY_PATTERN.matcher(key).matches()) {
                    String[] values = SPLIT_FLATTEN_PROPERTY_PATTERN.split(key);
                    for (int i = 0; i < values.length; ++i) {
                        values[i] = values[i].replace("\\.", ".");
                        if (i == values.length - 1) break;
                        String val = values[i];
                        if (node.has(val)) {
                            node = (ObjectNode)node.get(val);
                            continue;
                        }
                        ObjectNode child = new ObjectNode(JsonNodeFactory.instance);
                        node.set(val, (JsonNode)child);
                        node = child;
                    }
                    node.set(values[values.length - 1], resCurrent.get(key));
                    resCurrent.remove(key);
                    outNode = node.get(values[values.length - 1]);
                } else if (CHECK_IF_ESCAPED_MAP_PATTERN.matcher(key).matches()) {
                    String originalKey = REPLACE_ESCAPED_MAP_PATTERN.matcher(key).replaceAll(".");
                    resCurrent.remove(key);
                    resCurrent.set(originalKey, outNode);
                }
                if (field.getValue() instanceof ObjectNode) {
                    source.add((ObjectNode)field.getValue());
                    target.add((ObjectNode)outNode);
                    continue;
                }
                if (!(field.getValue() instanceof ArrayNode) || ((JsonNode)field.getValue()).size() <= 0 || !(((JsonNode)field.getValue()).get(0) instanceof ObjectNode)) continue;
                Iterator sourceIt = ((JsonNode)field.getValue()).elements();
                Iterator targetIt = outNode.elements();
                while (sourceIt.hasNext()) {
                    source.add((ObjectNode)sourceIt.next());
                    target.add((ObjectNode)targetIt.next());
                }
            }
        }
        jgen.writeTree((TreeNode)res);
    }

    public void resolve(SerializerProvider provider) throws JsonMappingException {
        if (this.defaultSerializer instanceof ResolvableSerializer) {
            ((ResolvableSerializer)this.defaultSerializer).resolve(provider);
        }
    }

    public void serializeWithType(Object value, JsonGenerator gen, SerializerProvider provider, TypeSerializer typeSerializer) throws IOException {
        this.serialize(value, gen, provider);
    }
}

