/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.rest;

import com.azure.core.annotation.BodyParam;
import com.azure.core.annotation.Delete;
import com.azure.core.annotation.ExpectedResponses;
import com.azure.core.annotation.FormParam;
import com.azure.core.annotation.Get;
import com.azure.core.annotation.Head;
import com.azure.core.annotation.HeaderParam;
import com.azure.core.annotation.Headers;
import com.azure.core.annotation.HostParam;
import com.azure.core.annotation.Patch;
import com.azure.core.annotation.PathParam;
import com.azure.core.annotation.Post;
import com.azure.core.annotation.Put;
import com.azure.core.annotation.QueryParam;
import com.azure.core.annotation.ReturnValueWireType;
import com.azure.core.annotation.UnexpectedResponseExceptionType;
import com.azure.core.exception.HttpResponseException;
import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.rest.MissingRequiredAnnotationException;
import com.azure.core.http.rest.Page;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.http.rest.Substitution;
import com.azure.core.http.rest.UrlEscapers;
import com.azure.core.implementation.TypeUtil;
import com.azure.core.implementation.UnixTime;
import com.azure.core.implementation.http.UnexpectedExceptionInformation;
import com.azure.core.implementation.serializer.HttpResponseDecodeData;
import com.azure.core.util.Base64Url;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.core.util.UrlBuilder;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerAdapter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

class SwaggerMethodParser
implements HttpResponseDecodeData {
    private static final Pattern PATTERN_COLON_SLASH_SLASH = Pattern.compile("://");
    private final SerializerAdapter serializer;
    private final String rawHost;
    private final String fullyQualifiedMethodName;
    private final HttpMethod httpMethod;
    private final String relativePath;
    private final List<Substitution> hostSubstitutions = new ArrayList<Substitution>();
    private final List<Substitution> pathSubstitutions = new ArrayList<Substitution>();
    private final List<Substitution> querySubstitutions = new ArrayList<Substitution>();
    private final List<Substitution> formSubstitutions = new ArrayList<Substitution>();
    private final List<Substitution> headerSubstitutions = new ArrayList<Substitution>();
    private final HttpHeaders headers = new HttpHeaders();
    private final Integer bodyContentMethodParameterIndex;
    private final String bodyContentType;
    private final Type bodyJavaType;
    private final BitSet expectedStatusCodes;
    private final Type returnType;
    private final Type returnValueWireType;
    private final UnexpectedResponseExceptionType[] unexpectedResponseExceptionTypes;
    private Map<Integer, UnexpectedExceptionInformation> exceptionMapping;
    private UnexpectedExceptionInformation defaultException;

    SwaggerMethodParser(Method swaggerMethod, String rawHost) {
        this(swaggerMethod, rawHost, JacksonAdapter.createDefaultSerializerAdapter());
    }

    /*
     * WARNING - void declaration
     */
    SwaggerMethodParser(Method swaggerMethod, String rawHost, SerializerAdapter serializer) {
        void var7_11;
        ExpectedResponses expectedResponses;
        Class<?> returnValueWireType;
        this.serializer = serializer;
        this.rawHost = rawHost;
        Class<?> swaggerInterface = swaggerMethod.getDeclaringClass();
        this.fullyQualifiedMethodName = swaggerInterface.getName() + "." + swaggerMethod.getName();
        if (swaggerMethod.isAnnotationPresent(Get.class)) {
            this.httpMethod = HttpMethod.GET;
            this.relativePath = swaggerMethod.getAnnotation(Get.class).value();
        } else if (swaggerMethod.isAnnotationPresent(Put.class)) {
            this.httpMethod = HttpMethod.PUT;
            this.relativePath = swaggerMethod.getAnnotation(Put.class).value();
        } else if (swaggerMethod.isAnnotationPresent(Head.class)) {
            this.httpMethod = HttpMethod.HEAD;
            this.relativePath = swaggerMethod.getAnnotation(Head.class).value();
        } else if (swaggerMethod.isAnnotationPresent(Delete.class)) {
            this.httpMethod = HttpMethod.DELETE;
            this.relativePath = swaggerMethod.getAnnotation(Delete.class).value();
        } else if (swaggerMethod.isAnnotationPresent(Post.class)) {
            this.httpMethod = HttpMethod.POST;
            this.relativePath = swaggerMethod.getAnnotation(Post.class).value();
        } else if (swaggerMethod.isAnnotationPresent(Patch.class)) {
            this.httpMethod = HttpMethod.PATCH;
            this.relativePath = swaggerMethod.getAnnotation(Patch.class).value();
        } else {
            throw new MissingRequiredAnnotationException(Arrays.asList(Get.class, Put.class, Head.class, Delete.class, Post.class, Patch.class), swaggerMethod);
        }
        this.returnType = swaggerMethod.getGenericReturnType();
        ReturnValueWireType returnValueWireTypeAnnotation = swaggerMethod.getAnnotation(ReturnValueWireType.class);
        this.returnValueWireType = returnValueWireTypeAnnotation != null ? ((returnValueWireType = returnValueWireTypeAnnotation.value()) == Base64Url.class || returnValueWireType == UnixTime.class || returnValueWireType == DateTimeRfc1123.class ? returnValueWireType : (TypeUtil.isTypeOrSubTypeOf(returnValueWireType, List.class) ? returnValueWireType.getGenericInterfaces()[0] : (TypeUtil.isTypeOrSubTypeOf(returnValueWireType, Page.class) ? returnValueWireType : null))) : null;
        if (swaggerMethod.isAnnotationPresent(Headers.class)) {
            String[] stringArray;
            Headers headersAnnotation = swaggerMethod.getAnnotation(Headers.class);
            String[] stringArray2 = stringArray = headersAnnotation.value();
            int n = stringArray2.length;
            for (int i = 0; i < n; ++i) {
                String headerValue;
                String headerName;
                String header = stringArray2[i];
                int colonIndex = header.indexOf(":");
                if (colonIndex < 0 || (headerName = header.substring(0, colonIndex).trim()).isEmpty() || (headerValue = header.substring(colonIndex + 1).trim()).isEmpty()) continue;
                if (headerValue.contains(",")) {
                    this.headers.set(headerName, Arrays.asList(headerValue.split(",")));
                    continue;
                }
                this.headers.set(headerName, headerValue);
            }
        }
        if ((expectedResponses = swaggerMethod.getAnnotation(ExpectedResponses.class)) != null && expectedResponses.value().length > 0) {
            this.expectedStatusCodes = new BitSet();
            for (int code : expectedResponses.value()) {
                this.expectedStatusCodes.set(code);
            }
        } else {
            this.expectedStatusCodes = null;
        }
        this.unexpectedResponseExceptionTypes = (UnexpectedResponseExceptionType[])swaggerMethod.getAnnotationsByType(UnexpectedResponseExceptionType.class);
        Object var7_10 = null;
        String bodyContentType = null;
        Object bodyJavaType = null;
        Annotation[][] allParametersAnnotations = swaggerMethod.getParameterAnnotations();
        for (int parameterIndex = 0; parameterIndex < allParametersAnnotations.length; ++parameterIndex) {
            Annotation[] parameterAnnotations;
            for (Annotation annotation : parameterAnnotations = swaggerMethod.getParameterAnnotations()[parameterIndex]) {
                Class<? extends Annotation> annotationType = annotation.annotationType();
                if (annotationType.equals(HostParam.class)) {
                    HostParam hostParamAnnotation = (HostParam)annotation;
                    this.hostSubstitutions.add(new Substitution(hostParamAnnotation.value(), parameterIndex, !hostParamAnnotation.encoded()));
                    continue;
                }
                if (annotationType.equals(PathParam.class)) {
                    PathParam pathParamAnnotation = (PathParam)annotation;
                    this.pathSubstitutions.add(new Substitution(pathParamAnnotation.value(), parameterIndex, !pathParamAnnotation.encoded()));
                    continue;
                }
                if (annotationType.equals(QueryParam.class)) {
                    QueryParam queryParamAnnotation = (QueryParam)annotation;
                    this.querySubstitutions.add(new Substitution(queryParamAnnotation.value(), parameterIndex, !queryParamAnnotation.encoded()));
                    continue;
                }
                if (annotationType.equals(HeaderParam.class)) {
                    HeaderParam headerParamAnnotation = (HeaderParam)annotation;
                    this.headerSubstitutions.add(new Substitution(headerParamAnnotation.value(), parameterIndex, false));
                    continue;
                }
                if (annotationType.equals(BodyParam.class)) {
                    BodyParam bodyParamAnnotation = (BodyParam)annotation;
                    Integer n = parameterIndex;
                    bodyContentType = bodyParamAnnotation.value();
                    bodyJavaType = swaggerMethod.getGenericParameterTypes()[parameterIndex];
                    continue;
                }
                if (!annotationType.equals(FormParam.class)) continue;
                FormParam formParamAnnotation = (FormParam)annotation;
                this.formSubstitutions.add(new Substitution(formParamAnnotation.value(), parameterIndex, !formParamAnnotation.encoded()));
                bodyContentType = "application/x-www-form-urlencoded";
                bodyJavaType = String.class;
            }
        }
        this.bodyContentMethodParameterIndex = var7_11;
        this.bodyContentType = bodyContentType;
        this.bodyJavaType = bodyJavaType;
    }

    public String getFullyQualifiedMethodName() {
        return this.fullyQualifiedMethodName;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public void setSchemeAndHost(Object[] swaggerMethodArguments, UrlBuilder urlBuilder) {
        String substitutedHost = this.applySubstitutions(this.rawHost, this.hostSubstitutions, swaggerMethodArguments);
        String[] substitutedHostParts = PATTERN_COLON_SLASH_SLASH.split(substitutedHost);
        if (substitutedHostParts.length >= 2) {
            urlBuilder.setScheme(substitutedHostParts[0]);
            urlBuilder.setHost(substitutedHostParts[1]);
        } else if (substitutedHostParts.length == 1) {
            urlBuilder.setScheme(substitutedHostParts[0]);
            urlBuilder.setHost(substitutedHost);
        } else {
            urlBuilder.setHost(substitutedHost);
        }
    }

    public String setPath(Object[] methodArguments) {
        return this.applySubstitutions(this.relativePath, this.pathSubstitutions, methodArguments);
    }

    public void setEncodedQueryParameters(Object[] swaggerMethodArguments, UrlBuilder urlBuilder) {
        if (swaggerMethodArguments == null) {
            return;
        }
        for (Substitution substitution : this.querySubstitutions) {
            Object methodArgument;
            String parameterValue;
            int parameterIndex = substitution.getMethodParameterIndex();
            if (0 > parameterIndex || parameterIndex >= swaggerMethodArguments.length || (parameterValue = SwaggerMethodParser.serialize(this.serializer, methodArgument = swaggerMethodArguments[substitution.getMethodParameterIndex()])) == null) continue;
            if (substitution.shouldEncode()) {
                parameterValue = UrlEscapers.QUERY_ESCAPER.escape(parameterValue);
            }
            urlBuilder.setQueryParameter(substitution.getUrlParameterName(), parameterValue);
        }
    }

    public void setHeaders(Object[] swaggerMethodArguments, HttpHeaders httpHeaders) {
        for (HttpHeader header : this.headers) {
            httpHeaders.set(header.getName(), header.getValuesList());
        }
        if (swaggerMethodArguments == null) {
            return;
        }
        for (Substitution headerSubstitution : this.headerSubstitutions) {
            int parameterIndex = headerSubstitution.getMethodParameterIndex();
            if (0 > parameterIndex || parameterIndex >= swaggerMethodArguments.length) continue;
            Object methodArgument = swaggerMethodArguments[headerSubstitution.getMethodParameterIndex()];
            if (methodArgument instanceof Map) {
                Map headerCollection = (Map)methodArgument;
                String headerCollectionPrefix = headerSubstitution.getUrlParameterName();
                for (Map.Entry headerCollectionEntry : headerCollection.entrySet()) {
                    String headerName = headerCollectionPrefix + (String)headerCollectionEntry.getKey();
                    String headerValue = SwaggerMethodParser.serialize(this.serializer, headerCollectionEntry.getValue());
                    if (headerValue == null) continue;
                    httpHeaders.set(headerName, headerValue);
                }
                continue;
            }
            String headerName = headerSubstitution.getUrlParameterName();
            String headerValue = SwaggerMethodParser.serialize(this.serializer, methodArgument);
            if (headerValue == null) continue;
            httpHeaders.set(headerName, headerValue);
        }
    }

    public Context setContext(Object[] swaggerMethodArguments) {
        Context context = CoreUtils.findFirstOfType(swaggerMethodArguments, Context.class);
        return context != null ? context : Context.NONE;
    }

    public RequestOptions setRequestOptions(Object[] swaggerMethodArguments) {
        return CoreUtils.findFirstOfType(swaggerMethodArguments, RequestOptions.class);
    }

    @Override
    public boolean isExpectedResponseStatusCode(int statusCode) {
        return this.expectedStatusCodes == null ? statusCode < 400 : this.expectedStatusCodes.get(statusCode);
    }

    @Override
    public UnexpectedExceptionInformation getUnexpectedException(int code) {
        if (this.exceptionMapping == null) {
            this.exceptionMapping = this.processUnexpectedResponseExceptionTypes();
        }
        return this.exceptionMapping.getOrDefault(code, this.defaultException);
    }

    public Object setBody(Object[] swaggerMethodArguments) {
        Object result = null;
        if (this.bodyContentMethodParameterIndex != null && swaggerMethodArguments != null && 0 <= this.bodyContentMethodParameterIndex && this.bodyContentMethodParameterIndex < swaggerMethodArguments.length) {
            result = swaggerMethodArguments[this.bodyContentMethodParameterIndex];
        }
        if (!CoreUtils.isNullOrEmpty(this.formSubstitutions) && swaggerMethodArguments != null) {
            result = this.formSubstitutions.stream().map(substitution -> SwaggerMethodParser.serializeFormData(this.serializer, substitution.getUrlParameterName(), swaggerMethodArguments[substitution.getMethodParameterIndex()], substitution.shouldEncode())).filter(Objects::nonNull).collect(Collectors.joining("&"));
        }
        return result;
    }

    public String getBodyContentType() {
        return this.bodyContentType;
    }

    @Override
    public Type getReturnType() {
        return this.returnType;
    }

    public Type getBodyJavaType() {
        return this.bodyJavaType;
    }

    @Override
    public Type getReturnValueWireType() {
        return this.returnValueWireType;
    }

    private static String serialize(SerializerAdapter serializer, Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return serializer.serializeRaw(value);
    }

    private static String serializeFormData(SerializerAdapter serializer, String key, Object value, boolean shouldEncode) {
        if (value == null) {
            return null;
        }
        String encodedKey = UrlEscapers.FORM_ESCAPER.escape(key);
        if (value instanceof List) {
            return ((List)value).stream().map(element -> SwaggerMethodParser.serializeAndEncodeFormValue(serializer, element, shouldEncode)).filter(Objects::nonNull).map(formValue -> encodedKey + "=" + formValue).collect(Collectors.joining("&"));
        }
        return encodedKey + "=" + SwaggerMethodParser.serializeAndEncodeFormValue(serializer, value, shouldEncode);
    }

    private static String serializeAndEncodeFormValue(SerializerAdapter serializer, Object value, boolean shouldEncode) {
        if (value == null) {
            return null;
        }
        String serializedValue = serializer.serializeRaw(value);
        return shouldEncode ? UrlEscapers.FORM_ESCAPER.escape(serializedValue) : serializedValue;
    }

    private String applySubstitutions(String originalValue, Iterable<Substitution> substitutions, Object[] methodArguments) {
        String result = originalValue;
        if (methodArguments != null) {
            for (Substitution substitution : substitutions) {
                int substitutionParameterIndex = substitution.getMethodParameterIndex();
                if (0 > substitutionParameterIndex || substitutionParameterIndex >= methodArguments.length) continue;
                Object methodArgument = methodArguments[substitutionParameterIndex];
                String substitutionValue = SwaggerMethodParser.serialize(this.serializer, methodArgument);
                if (substitutionValue != null && !substitutionValue.isEmpty() && substitution.shouldEncode()) {
                    substitutionValue = UrlEscapers.PATH_ESCAPER.escape(substitutionValue);
                }
                if (substitutionValue == null) {
                    substitutionValue = "";
                }
                result = result.replace("{" + substitution.getUrlParameterName() + "}", substitutionValue);
            }
        }
        return result;
    }

    private Map<Integer, UnexpectedExceptionInformation> processUnexpectedResponseExceptionTypes() {
        HashMap<Integer, UnexpectedExceptionInformation> exceptionHashMap = new HashMap<Integer, UnexpectedExceptionInformation>();
        for (UnexpectedResponseExceptionType exceptionAnnotation : this.unexpectedResponseExceptionTypes) {
            UnexpectedExceptionInformation exception = new UnexpectedExceptionInformation(exceptionAnnotation.value());
            if (exceptionAnnotation.code().length == 0) {
                this.defaultException = exception;
                continue;
            }
            for (int statusCode : exceptionAnnotation.code()) {
                exceptionHashMap.put(statusCode, exception);
            }
        }
        if (this.defaultException == null) {
            this.defaultException = new UnexpectedExceptionInformation(HttpResponseException.class);
        }
        return exceptionHashMap;
    }
}

