/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.MockHttpResponse;
import com.azure.core.http.policy.FixedDelay;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RetryPolicy;
import com.azure.core.http.policy.RetryStrategy;
import com.azure.core.http.policy.UserAgentPolicy;
import com.azure.core.util.Configuration;
import com.azure.core.util.Context;
import java.time.Duration;
import java.util.function.Consumer;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;
import reactor.test.StepVerifier;

public class UserAgentTests {
    private static final String USER_AGENT = "User-Agent";

    @ParameterizedTest(name="{displayName} [{index}]")
    @MethodSource(value={"userAgentAndExpectedSupplier"})
    public void validateUserAgentPolicyHandling(UserAgentPolicy userAgentPolicy, String expected) {
        HttpPipeline pipeline = new HttpPipelineBuilder().httpClient((HttpClient)new ValidationHttpClient(request -> Assertions.assertEquals((Object)expected, (Object)request.getHeaders().getValue(USER_AGENT)))).policies(new HttpPipelinePolicy[]{userAgentPolicy}).build();
        StepVerifier.create((Publisher)pipeline.send(new HttpRequest(HttpMethod.GET, "http://localhost"))).assertNext(response -> Assertions.assertEquals((int)200, (int)response.getStatusCode())).verifyComplete();
    }

    @ParameterizedTest(name="{displayName} [{index}]")
    @MethodSource(value={"userAgentAndExpectedSupplier"})
    public void userAgentPolicyAfterRetryPolicy(UserAgentPolicy userAgentPolicy, String expected) {
        HttpPipeline pipeline = new HttpPipelineBuilder().httpClient((HttpClient)new RetryValidationHttpClient(request -> Assertions.assertEquals((Object)expected, (Object)request.getHeaders().getValue(USER_AGENT)))).policies(new HttpPipelinePolicy[]{new RetryPolicy((RetryStrategy)new FixedDelay(5, Duration.ofMillis(10L)))}).policies(new HttpPipelinePolicy[]{userAgentPolicy}).build();
        StepVerifier.create((Publisher)pipeline.send(new HttpRequest(HttpMethod.GET, "http://localhost"))).assertNext(response -> Assertions.assertEquals((int)200, (int)response.getStatusCode())).verifyComplete();
    }

    @ParameterizedTest(name="{displayName} [{index}]")
    @MethodSource(value={"userAgentAndExpectedSupplier"})
    public void multipleUserAgentPolicies(UserAgentPolicy userAgentPolicy, String expected) {
        HttpPipeline pipeline = new HttpPipelineBuilder().httpClient((HttpClient)new ValidationHttpClient(request -> Assertions.assertEquals((Object)expected, (Object)request.getHeaders().getValue(USER_AGENT)))).policies(new HttpPipelinePolicy[]{userAgentPolicy, userAgentPolicy}).build();
        StepVerifier.create((Publisher)pipeline.send(new HttpRequest(HttpMethod.GET, "http://localhost"))).assertNext(response -> Assertions.assertEquals((int)200, (int)response.getStatusCode())).verifyComplete();
    }

    @ParameterizedTest(name="{displayName} [{index}]")
    @MethodSource(value={"userAgentAndExpectedSupplier"})
    public void overrideUserAgentContext(UserAgentPolicy userAgentPolicy, String expected) {
        String overrideUserAgent = "overrideUserAgent";
        HttpPipeline pipeline = new HttpPipelineBuilder().httpClient((HttpClient)new ValidationHttpClient(request -> Assertions.assertEquals((Object)overrideUserAgent, (Object)request.getHeaders().getValue(USER_AGENT)))).policies(new HttpPipelinePolicy[]{userAgentPolicy}).build();
        StepVerifier.create((Publisher)pipeline.send(new HttpRequest(HttpMethod.GET, "http://localhost"), new Context((Object)"Override-User-Agent", (Object)overrideUserAgent))).assertNext(response -> Assertions.assertEquals((int)200, (int)response.getStatusCode())).verifyComplete();
    }

    @ParameterizedTest(name="{displayName} [{index}]")
    @MethodSource(value={"userAgentAndExpectedSupplier"})
    public void appendUserAgentContext(UserAgentPolicy userAgentPolicy, String expected) {
        String appendUserAgent = "appendUserAgent";
        HttpPipeline pipeline = new HttpPipelineBuilder().httpClient((HttpClient)new ValidationHttpClient(request -> Assertions.assertEquals((Object)(expected + " " + appendUserAgent), (Object)request.getHeaders().getValue(USER_AGENT)))).policies(new HttpPipelinePolicy[]{userAgentPolicy}).build();
        StepVerifier.create((Publisher)pipeline.send(new HttpRequest(HttpMethod.GET, "http://localhost"), new Context((Object)"Append-User-Agent", (Object)appendUserAgent))).assertNext(response -> Assertions.assertEquals((int)200, (int)response.getStatusCode())).verifyComplete();
    }

    private static Stream<Arguments> userAgentAndExpectedSupplier() {
        String defaultUserAgent = "azsdk-java";
        String sdkName = "sdkName";
        String sdkVersion = "sdkVersion";
        String baseUserAgent = String.format("%s-%s/%s", defaultUserAgent, sdkName, sdkVersion);
        String applicationId = "applicationId";
        String platformInfo = String.format("%s; %s; %s", Configuration.getGlobalConfiguration().get("java.version"), Configuration.getGlobalConfiguration().get("os.name"), Configuration.getGlobalConfiguration().get("os.version"));
        Configuration enabledTelemetryConfiguration = new Configuration().put("AZURE_TELEMETRY_DISABLED", "false");
        Configuration disabledTelemetryConfiguration = new Configuration().put("AZURE_TELEMETRY_DISABLED", "true");
        return Stream.of(Arguments.of((Object[])new Object[]{new UserAgentPolicy(), defaultUserAgent}), Arguments.of((Object[])new Object[]{new UserAgentPolicy("AutoRest-Java"), "AutoRest-Java"}), Arguments.of((Object[])new Object[]{new UserAgentPolicy(null, sdkName, sdkVersion, disabledTelemetryConfiguration), baseUserAgent}), Arguments.of((Object[])new Object[]{new UserAgentPolicy(sdkName, sdkVersion, disabledTelemetryConfiguration, () -> "1.0"), baseUserAgent}), Arguments.of((Object[])new Object[]{new UserAgentPolicy("applicationId", "sdkName", "sdkVersion", disabledTelemetryConfiguration), String.format("%s %s", applicationId, baseUserAgent)}), Arguments.of((Object[])new Object[]{new UserAgentPolicy(null, "sdkName", "sdkVersion", enabledTelemetryConfiguration), String.format("%s (%s)", baseUserAgent, platformInfo)}), Arguments.of((Object[])new Object[]{new UserAgentPolicy(sdkName, sdkVersion, enabledTelemetryConfiguration, () -> "1.0"), String.format("%s (%s)", baseUserAgent, platformInfo)}), Arguments.of((Object[])new Object[]{new UserAgentPolicy("applicationId", "sdkName", "sdkVersion", enabledTelemetryConfiguration), String.format("%s %s (%s)", applicationId, baseUserAgent, platformInfo)}));
    }

    private static class RetryValidationHttpClient
    implements HttpClient {
        private final Consumer<HttpRequest> validator;
        private int retryCount = 0;

        RetryValidationHttpClient(Consumer<HttpRequest> validator) {
            this.validator = validator;
        }

        public Mono<HttpResponse> send(HttpRequest request) {
            if (this.retryCount < 5) {
                ++this.retryCount;
                return Mono.error((Throwable)new RuntimeException("Activating retry policy"));
            }
            this.validator.accept(request);
            return Mono.just((Object)((Object)new MockHttpResponse(request, 200)));
        }
    }

    private static class ValidationHttpClient
    implements HttpClient {
        private final Consumer<HttpRequest> validator;

        ValidationHttpClient(Consumer<HttpRequest> validator) {
            this.validator = validator;
        }

        public Mono<HttpResponse> send(HttpRequest request) {
            this.validator.accept(request);
            return Mono.just((Object)((Object)new MockHttpResponse(request, 200)));
        }
    }
}

