/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.policy;

import com.azure.core.http.HttpClient;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpPipelineBuilder;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.clients.NoOpHttpClient;
import com.azure.core.http.policy.AddHeadersFromContextPolicy;
import com.azure.core.http.policy.HttpPipelinePolicy;
import com.azure.core.http.policy.RequestIdPolicy;
import com.azure.core.util.Context;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class AddHeadersFromContextPolicyTest {
    private final HttpResponse mockResponse = new HttpResponse(null){

        public int getStatusCode() {
            return 500;
        }

        public String getHeaderValue(String name) {
            return null;
        }

        public HttpHeaders getHeaders() {
            return new HttpHeaders();
        }

        public Mono<byte[]> getBodyAsByteArray() {
            return Mono.empty();
        }

        public Flux<ByteBuffer> getBody() {
            return Flux.empty();
        }

        public Mono<String> getBodyAsString() {
            return Mono.empty();
        }

        public Mono<String> getBodyAsString(Charset charset) {
            return Mono.empty();
        }
    };

    @Test
    public void clientProvidedMultipleHeaderTest() throws Exception {
        final String customRequestId = "request-id-value";
        HttpHeaders headers = new HttpHeaders();
        headers.set("x-ms-client-request-id", customRequestId);
        headers.set("my-header1", "my-header1-value");
        headers.set("my-header2", "my-header2-value");
        HttpPipeline pipeline = new HttpPipelineBuilder().httpClient((HttpClient)new NoOpHttpClient(){

            @Override
            public Mono<HttpResponse> send(HttpRequest request) {
                Assertions.assertEquals((Object)request.getHeaders().getValue("x-ms-client-request-id"), (Object)customRequestId);
                Assertions.assertEquals((Object)request.getHeaders().getValue("my-header1"), (Object)"my-header1-value");
                Assertions.assertEquals((Object)request.getHeaders().getValue("my-header2"), (Object)"my-header2-value");
                return Mono.just((Object)AddHeadersFromContextPolicyTest.this.mockResponse);
            }
        }).policies(new HttpPipelinePolicy[]{new RequestIdPolicy()}).policies(new HttpPipelinePolicy[]{new AddHeadersFromContextPolicy()}).build();
        pipeline.send(new HttpRequest(HttpMethod.GET, new URL("http://localhost/")), new Context((Object)"azure-http-headers-key", (Object)headers)).block();
    }
}

