/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.rest;

import com.azure.core.http.rest.OnlyOneContinuablePage;
import com.azure.core.util.paging.PageRetriever;
import java.util.concurrent.atomic.AtomicInteger;
import reactor.core.publisher.Flux;

public class OnlyOnePageRetriever
implements PageRetriever<Integer, OnlyOneContinuablePage> {
    private final AtomicInteger getCount = new AtomicInteger();
    private final int pageCount;

    public OnlyOnePageRetriever(int pageCount) {
        this.pageCount = pageCount;
    }

    public Flux<OnlyOneContinuablePage> get(Integer continuationToken, Integer pageSize) {
        this.getCount.getAndIncrement();
        if (continuationToken != null && continuationToken == this.pageCount - 1) {
            pageSize = pageSize == null ? 10 : pageSize;
            return Flux.just((Object)new OnlyOneContinuablePage(continuationToken, null, pageSize));
        }
        continuationToken = continuationToken == null ? 0 : continuationToken;
        pageSize = pageSize == null ? 10 : pageSize;
        return Flux.just((Object)new OnlyOneContinuablePage(continuationToken, continuationToken + 1, pageSize));
    }

    public int getGetCount() {
        return this.getCount.get();
    }
}

