/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.rest;

import com.azure.core.http.rest.PagedFluxBase;
import com.azure.core.http.rest.PagedIterableBase;
import com.azure.core.http.rest.PagedResponse;
import java.util.function.Function;
import java.util.function.Supplier;
import reactor.core.publisher.Mono;

public class PagedIterableBaseJavaDocCodeSnippets {
    public void streamByPageSnippet() {
        CustomPagedFlux<String> customPagedFlux = this.createCustomInstance();
        PagedIterableBase customPagedIterableResponse = new PagedIterableBase(customPagedFlux);
        customPagedIterableResponse.streamByPage().forEach(resp -> {
            System.out.printf("Response headers are %s. Url %s  and status code %d %n", resp.getHeaders(), resp.getRequest().getUrl(), resp.getStatusCode());
            resp.getElements().forEach(value -> System.out.printf("Response value is %s %n", value));
        });
    }

    public void iterateByPageSnippet() {
        CustomPagedFlux<String> customPagedFlux = this.createCustomInstance();
        PagedIterableBase customPagedIterableResponse = new PagedIterableBase(customPagedFlux);
        customPagedIterableResponse.iterableByPage().forEach(resp -> {
            System.out.printf("Response headers are %s. Url %s  and status code %d %n", resp.getHeaders(), resp.getRequest().getUrl(), resp.getStatusCode());
            resp.getElements().forEach(value -> System.out.printf("Response value is %s %n", value));
        });
    }

    public void iterableByPageWhileSnippet() {
        CustomPagedFlux<String> customPagedFlux = this.createCustomInstance();
        PagedIterableBase customPagedIterableResponse = new PagedIterableBase(customPagedFlux);
        for (PagedResponse resp : customPagedIterableResponse.iterableByPage()) {
            System.out.printf("Response headers are %s. Url %s  and status code %d %n", resp.getHeaders(), resp.getRequest().getUrl(), resp.getStatusCode());
            resp.getElements().forEach(value -> System.out.printf("Response value is %s %n", value));
        }
    }

    CustomPagedFlux<String> createCustomInstance() {
        Supplier firstPageRetriever = () -> this.getFirstPage();
        Function nextPageRetriever = continuationToken -> this.getNextPage((String)continuationToken);
        CustomPagedFlux<String> pagedFlux = new CustomPagedFlux<String>(firstPageRetriever, nextPageRetriever);
        return pagedFlux;
    }

    private Mono<PagedResponse<String>> getNextPage(String continuationToken) {
        return null;
    }

    private Mono<PagedResponse<String>> getFirstPage() {
        return null;
    }

    static class CustomPagedFlux<String>
    extends PagedFluxBase<String, PagedResponse<String>> {
        CustomPagedFlux(Supplier<Mono<PagedResponse<String>>> firstPageRetriever) {
            super(firstPageRetriever);
        }

        CustomPagedFlux(Supplier<Mono<PagedResponse<String>>> firstPageRetriever, Function<String, Mono<PagedResponse<String>>> nextPageRetriever) {
            super(firstPageRetriever, nextPageRetriever);
        }
    }
}

