/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.rest;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.rest.OnlyOneContinuablePage;
import com.azure.core.http.rest.OnlyOnePageRetriever;
import com.azure.core.http.rest.OnlyOnePagedFlux;
import com.azure.core.http.rest.OnlyOnePagedIterable;
import com.azure.core.http.rest.PagedFlux;
import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.util.paging.ContinuablePagedFlux;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class PagedIterableTest {
    private static final int DEFAULT_PAGE_COUNT = 4;
    private final HttpHeaders httpHeaders = new HttpHeaders().set("header1", "value1").set("header2", "value2");
    private final HttpRequest httpRequest = new HttpRequest(HttpMethod.GET, "http://localhost");
    private final String deserializedHeaders = "header1,value1,header2,value2";
    private List<PagedResponse<Integer>> pagedResponses;
    private List<PagedResponse<String>> pagedStringResponses;

    @ParameterizedTest
    @ValueSource(ints={0, 5})
    public void streamByPage(int numberOfPages) {
        PagedFlux<Integer> pagedFlux = this.getIntegerPagedFlux(numberOfPages);
        PagedIterable pagedIterable = new PagedIterable(pagedFlux);
        List pages = pagedIterable.streamByPage().collect(Collectors.toList());
        Assertions.assertEquals((int)numberOfPages, (int)pages.size());
        Assertions.assertEquals(this.pagedResponses, pages);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 5})
    public void iterateByPage(int numberOfPages) {
        PagedFlux<Integer> pagedFlux = this.getIntegerPagedFlux(numberOfPages);
        PagedIterable pagedIterable = new PagedIterable(pagedFlux);
        ArrayList pages = new ArrayList();
        pagedIterable.iterableByPage().iterator().forEachRemaining(pages::add);
        Assertions.assertEquals((int)numberOfPages, (int)pages.size());
        Assertions.assertEquals(this.pagedResponses, pages);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 5})
    public void streamByT(int numberOfPages) {
        PagedFlux<Integer> pagedFlux = this.getIntegerPagedFlux(numberOfPages);
        PagedIterable pagedIterable = new PagedIterable(pagedFlux);
        List values = pagedIterable.stream().collect(Collectors.toList());
        Assertions.assertEquals((int)(numberOfPages * 3), (int)values.size());
        Assertions.assertEquals(Stream.iterate(0, i -> i + 1).limit((long)numberOfPages * 3L).collect(Collectors.toList()), values);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 5})
    public void iterateByT(int numberOfPages) {
        PagedFlux<Integer> pagedFlux = this.getIntegerPagedFlux(numberOfPages);
        PagedIterable pagedIterable = new PagedIterable(pagedFlux);
        ArrayList values = new ArrayList();
        pagedIterable.iterator().forEachRemaining(values::add);
        Assertions.assertEquals((int)(numberOfPages * 3), (int)values.size());
        Assertions.assertEquals(Stream.iterate(0, i -> i + 1).limit((long)numberOfPages * 3L).collect(Collectors.toList()), values);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 5})
    public void streamByPageMap(int numberOfPages) {
        PagedFlux<Integer> pagedFlux = this.getIntegerPagedFlux(numberOfPages);
        PagedIterable pagedIterable = new PagedIterable(pagedFlux);
        List pages = pagedIterable.mapPage(String::valueOf).streamByPage().collect(Collectors.toList());
        Assertions.assertEquals((int)numberOfPages, (int)pages.size());
        for (int i = 0; i < numberOfPages; ++i) {
            Assertions.assertEquals((Object)this.pagedStringResponses.get(i).getValue(), (Object)((PagedResponse)pages.get(i)).getValue());
        }
    }

    @ParameterizedTest
    @ValueSource(ints={0, 5})
    public void iterateByPageMap(int numberOfPages) {
        PagedFlux<Integer> pagedFlux = this.getIntegerPagedFlux(numberOfPages);
        PagedIterable pagedIterable = new PagedIterable(pagedFlux);
        ArrayList pages = new ArrayList();
        pagedIterable.mapPage(String::valueOf).iterableByPage().iterator().forEachRemaining(pages::add);
        Assertions.assertEquals((int)numberOfPages, (int)pages.size());
        for (int i = 0; i < numberOfPages; ++i) {
            Assertions.assertEquals((Object)this.pagedStringResponses.get(i).getValue(), (Object)((PagedResponse)pages.get(i)).getValue());
        }
    }

    @ParameterizedTest
    @ValueSource(ints={0, 5})
    public void streamByTMap(int numberOfPages) {
        PagedFlux<Integer> pagedFlux = this.getIntegerPagedFlux(numberOfPages);
        PagedIterable pagedIterable = new PagedIterable(pagedFlux);
        List values = pagedIterable.mapPage(String::valueOf).stream().collect(Collectors.toList());
        Assertions.assertEquals((int)(numberOfPages * 3), (int)values.size());
        Assertions.assertEquals(Stream.iterate(0, i -> i + 1).limit((long)numberOfPages * 3L).map(String::valueOf).collect(Collectors.toList()), values);
    }

    @ParameterizedTest
    @ValueSource(ints={0, 5})
    public void iterateByTMap(int numberOfPages) {
        PagedFlux<Integer> pagedFlux = this.getIntegerPagedFlux(numberOfPages);
        PagedIterable pagedIterable = new PagedIterable(pagedFlux);
        ArrayList values = new ArrayList();
        pagedIterable.mapPage(String::valueOf).iterator().forEachRemaining(values::add);
        Assertions.assertEquals((int)(numberOfPages * 3), (int)values.size());
        Assertions.assertEquals(Stream.iterate(0, i -> i + 1).limit((long)numberOfPages * 3L).map(String::valueOf).collect(Collectors.toList()), values);
    }

    @Test
    public void streamFirstPage() {
        TestPagedFlux<Integer> pagedFlux = this.getTestPagedFlux(5);
        PagedIterable pagedIterable = new PagedIterable(pagedFlux);
        Assertions.assertEquals(this.pagedResponses.get(0), pagedIterable.streamByPage().limit(1L).collect(Collectors.toList()).get(0));
        Assertions.assertEquals((int)0, (int)pagedFlux.getNextPageRetrievals());
    }

    @Test
    public void iterateFirstPage() {
        TestPagedFlux<Integer> pagedFlux = this.getTestPagedFlux(5);
        PagedIterable pagedIterable = new PagedIterable(pagedFlux);
        Assertions.assertEquals(this.pagedResponses.get(0), pagedIterable.iterableByPage().iterator().next());
        Assertions.assertEquals((int)0, (int)pagedFlux.getNextPageRetrievals());
    }

    @Test
    public void streamFirstValue() {
        TestPagedFlux<Integer> pagedFlux = this.getTestPagedFlux(5);
        PagedIterable pagedIterable = new PagedIterable(pagedFlux);
        Integer firstValue = (Integer)this.pagedResponses.get(0).getValue().get(0);
        Assertions.assertEquals((Integer)firstValue, (Integer)((Integer)pagedIterable.stream().limit(1L).collect(Collectors.toList()).get(0)));
    }

    @Test
    public void iterateFirstValue() {
        TestPagedFlux<Integer> pagedFlux = this.getTestPagedFlux(5);
        PagedIterable pagedIterable = new PagedIterable(pagedFlux);
        Integer firstValue = (Integer)this.pagedResponses.get(0).getValue().get(0);
        Assertions.assertEquals((Integer)firstValue, (Integer)((Integer)pagedIterable.iterator().next()));
        Assertions.assertEquals((int)0, (int)pagedFlux.getNextPageRetrievals());
    }

    @Test
    public void pagedIterableWithPageSize() {
        int expectedPageSize = 5;
        HttpHeaders headers = new HttpHeaders();
        HttpRequest request = new HttpRequest(HttpMethod.GET, "http://localhost");
        Function<String, PagedResponse> pagedResponseSupplier = continuationToken -> new PagedResponseBase(request, 200, headers, Collections.emptyList(), continuationToken, null);
        PagedFlux singlePageFlux = new PagedFlux(pageSize -> {
            Assertions.assertEquals((int)5, (Integer)pageSize);
            return Mono.just((Object)((PagedResponse)pagedResponseSupplier.apply(null)));
        });
        PagedIterable singlePageIterable = new PagedIterable(singlePageFlux);
        Iterator pageIterator = singlePageIterable.iterableByPage(5).iterator();
        Assertions.assertTrue((boolean)pageIterator.hasNext());
        pageIterator.next();
        Assertions.assertFalse((boolean)pageIterator.hasNext());
        Assertions.assertEquals((long)1L, (long)singlePageIterable.streamByPage(5).count());
        String expectedContinuationToken = "0";
        PagedFlux multiPageFlux = new PagedFlux(pageSize -> {
            Assertions.assertEquals((int)5, (Integer)pageSize);
            return Mono.just((Object)((PagedResponse)pagedResponseSupplier.apply("0")));
        }, (continuationToken, pageSize) -> {
            Assertions.assertEquals((int)5, (Integer)pageSize);
            Assertions.assertEquals((Object)"0", (Object)continuationToken);
            return Mono.just((Object)((PagedResponse)pagedResponseSupplier.apply(null)));
        });
        PagedIterable multiPageIterator = new PagedIterable(multiPageFlux);
        pageIterator = multiPageIterator.iterableByPage(5).iterator();
        Assertions.assertTrue((boolean)pageIterator.hasNext());
        pageIterator.next();
        Assertions.assertTrue((boolean)pageIterator.hasNext());
        pageIterator.next();
        Assertions.assertFalse((boolean)pageIterator.hasNext());
        Assertions.assertEquals((long)2L, (long)multiPageIterator.streamByPage(5).count());
    }

    private PagedFlux<Integer> getIntegerPagedFlux(int numberOfPages) {
        this.createPagedResponse(numberOfPages);
        return new PagedFlux(() -> this.pagedResponses.isEmpty() ? Mono.empty() : Mono.just(this.pagedResponses.get(0)), continuationToken -> this.getNextPage((String)continuationToken, this.pagedResponses));
    }

    private TestPagedFlux<Integer> getTestPagedFlux(int numberOfPages) {
        this.createPagedResponse(numberOfPages);
        return new TestPagedFlux<Integer>(() -> this.pagedResponses.isEmpty() ? Mono.empty() : Mono.just(this.pagedResponses.get(0)), continuationToken -> this.getNextPage((String)continuationToken, this.pagedResponses));
    }

    private void createPagedResponse(int numberOfPages) {
        this.pagedResponses = IntStream.range(0, numberOfPages).boxed().map(i -> this.createPagedResponse(this.httpRequest, this.httpHeaders, "header1,value1,header2,value2", numberOfPages, this::getItems, (int)i)).collect(Collectors.toList());
        this.pagedStringResponses = IntStream.range(0, numberOfPages).boxed().map(i -> this.createPagedResponse(this.httpRequest, this.httpHeaders, "header1,value1,header2,value2", numberOfPages, this::getStringItems, (int)i)).collect(Collectors.toList());
    }

    private <T> PagedResponseBase<String, T> createPagedResponse(HttpRequest httpRequest, HttpHeaders headers, String deserializedHeaders, int numberOfPages, Function<Integer, List<T>> valueSupplier, int i) {
        return new PagedResponseBase(httpRequest, 200, headers, valueSupplier.apply(i), i < numberOfPages - 1 ? String.valueOf(i + 1) : null, (Object)deserializedHeaders);
    }

    private Mono<PagedResponse<Integer>> getNextPage(String continuationToken, List<PagedResponse<Integer>> pagedResponses) {
        if (continuationToken == null || continuationToken.isEmpty()) {
            return Mono.empty();
        }
        int parsedToken = Integer.parseInt(continuationToken);
        if (parsedToken >= pagedResponses.size()) {
            return Mono.empty();
        }
        return Mono.just(pagedResponses.get(parsedToken));
    }

    private List<Integer> getItems(int i) {
        return IntStream.range(i * 3, i * 3 + 3).boxed().collect(Collectors.toList());
    }

    private List<String> getStringItems(int i) {
        return IntStream.range(i * 3, i * 3 + 3).boxed().map(String::valueOf).collect(Collectors.toList());
    }

    @Test
    public void streamFindFirstOnlyRetrievesOnePage() {
        OnlyOnePageRetriever pageRetriever = new OnlyOnePageRetriever(4);
        OnlyOnePagedIterable pagedIterable = new OnlyOnePagedIterable((ContinuablePagedFlux<Integer, Integer, OnlyOneContinuablePage>)new OnlyOnePagedFlux(() -> pageRetriever));
        pagedIterable.stream().count();
        Assertions.assertEquals((int)4, (int)pageRetriever.getGetCount());
        Integer next = pagedIterable.stream().findFirst().orElse(0);
        PagedIterableTest.sleep();
        Assertions.assertEquals((int)1, (int)(pageRetriever.getGetCount() - 4));
    }

    @Test
    public void streamParallelDoesNotRetrieveMorePagesThanExpected() {
        int pageCount = 10000;
        OnlyOnePageRetriever pageRetriever = new OnlyOnePageRetriever(pageCount);
        OnlyOnePagedIterable pagedIterable = new OnlyOnePagedIterable((ContinuablePagedFlux<Integer, Integer, OnlyOneContinuablePage>)new OnlyOnePagedFlux(() -> pageRetriever));
        ((Stream)pagedIterable.stream().parallel()).count();
        Assertions.assertEquals((int)pageCount, (int)pageRetriever.getGetCount());
    }

    @Test
    public void iterateNextOnlyRetrievesOnePage() {
        OnlyOnePageRetriever pageRetriever = new OnlyOnePageRetriever(4);
        OnlyOnePagedIterable pagedIterable = new OnlyOnePagedIterable((ContinuablePagedFlux<Integer, Integer, OnlyOneContinuablePage>)new OnlyOnePagedFlux(() -> pageRetriever));
        pagedIterable.iterator().forEachRemaining(ignored -> {});
        Assertions.assertEquals((int)4, (int)pageRetriever.getGetCount());
        Integer next = (Integer)pagedIterable.iterator().next();
        PagedIterableTest.sleep();
        Assertions.assertEquals((int)1, (int)(pageRetriever.getGetCount() - 4));
    }

    @Test
    public void streamByPageFindFirstOnlyRetrievesOnePage() {
        OnlyOnePageRetriever pageRetriever = new OnlyOnePageRetriever(4);
        OnlyOnePagedIterable pagedIterable = new OnlyOnePagedIterable((ContinuablePagedFlux<Integer, Integer, OnlyOneContinuablePage>)new OnlyOnePagedFlux(() -> pageRetriever));
        pagedIterable.streamByPage().count();
        Assertions.assertEquals((int)4, (int)pageRetriever.getGetCount());
        OnlyOneContinuablePage page = (OnlyOneContinuablePage)pagedIterable.streamByPage().findFirst().get();
        PagedIterableTest.sleep();
        Assertions.assertEquals((int)1, (int)(pageRetriever.getGetCount() - 4));
    }

    @Test
    public void streamParallelByPageDoesNotRetrieveMorePagesThanExpected() {
        int pageCount = 10000;
        OnlyOnePageRetriever pageRetriever = new OnlyOnePageRetriever(pageCount);
        OnlyOnePagedIterable pagedIterable = new OnlyOnePagedIterable((ContinuablePagedFlux<Integer, Integer, OnlyOneContinuablePage>)new OnlyOnePagedFlux(() -> pageRetriever));
        ((Stream)pagedIterable.streamByPage().parallel()).count();
        Assertions.assertEquals((int)pageCount, (int)pageRetriever.getGetCount());
    }

    @Test
    public void iterateByPageNextOnlyRetrievesOnePage() {
        OnlyOnePageRetriever pageRetriever = new OnlyOnePageRetriever(4);
        OnlyOnePagedIterable pagedIterable = new OnlyOnePagedIterable((ContinuablePagedFlux<Integer, Integer, OnlyOneContinuablePage>)new OnlyOnePagedFlux(() -> pageRetriever));
        pagedIterable.iterableByPage().iterator().forEachRemaining(ignored -> {});
        Assertions.assertEquals((int)4, (int)pageRetriever.getGetCount());
        OnlyOneContinuablePage page = (OnlyOneContinuablePage)pagedIterable.iterableByPage().iterator().next();
        PagedIterableTest.sleep();
        Assertions.assertEquals((int)1, (int)(pageRetriever.getGetCount() - 4));
    }

    private static void sleep() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException(ex);
        }
    }

    private static class TestPagedFlux<T>
    extends PagedFlux<T> {
        private int nextPageRetrievals = 0;

        TestPagedFlux(Supplier<Mono<PagedResponse<T>>> firstPageRetriever, Function<String, Mono<PagedResponse<T>>> nextPageRetriever) {
            super(firstPageRetriever, nextPageRetriever);
        }

        public Flux<PagedResponse<T>> byPage(String continuationToken) {
            ++this.nextPageRetrievals;
            return super.byPage(continuationToken);
        }

        int getNextPageRetrievals() {
            return this.nextPageRetrievals;
        }
    }
}

