/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.rest;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpMethod;
import com.azure.core.http.HttpRequest;
import com.azure.core.http.rest.RequestOptions;
import com.azure.core.util.BinaryData;
import java.net.MalformedURLException;
import java.net.URL;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.test.StepVerifier;

public class RequestOptionsTests {
    @Test
    public void addQueryParam() throws MalformedURLException {
        HttpRequest request = new HttpRequest(HttpMethod.POST, new URL("http://request.url"));
        RequestOptions options = new RequestOptions().addQueryParam("foo", "bar").addQueryParam("$skipToken", "1");
        options.getRequestCallback().accept(request);
        Assertions.assertTrue((boolean)request.getUrl().toString().contains("?foo=bar&%24skipToken=1"));
    }

    @Test
    public void addHeader() throws MalformedURLException {
        HttpRequest request = new HttpRequest(HttpMethod.POST, new URL("http://request.url"));
        RequestOptions options = new RequestOptions().addHeader("x-ms-foo", "bar").addHeader("Content-Type", "application/json");
        options.getRequestCallback().accept(request);
        HttpHeaders headers = request.getHeaders();
        Assertions.assertEquals((Object)"bar", (Object)headers.getValue("x-ms-foo"));
        Assertions.assertEquals((Object)"application/json", (Object)headers.getValue("Content-Type"));
    }

    @Test
    public void setBody() throws MalformedURLException {
        HttpRequest request = new HttpRequest(HttpMethod.POST, new URL("http://request.url"));
        String expected = "{\"id\":\"123\"}";
        RequestOptions options = new RequestOptions().setBody(BinaryData.fromString((String)expected));
        options.getRequestCallback().accept(request);
        StepVerifier.create((Publisher)BinaryData.fromFlux((Flux)request.getBody()).map(BinaryData::toString)).expectNext((Object)expected).verifyComplete();
    }

    @Test
    public void addRequestCallback() throws MalformedURLException {
        HttpRequest request = new HttpRequest(HttpMethod.POST, new URL("http://request.url"));
        RequestOptions options = new RequestOptions().addHeader("x-ms-foo", "bar").addRequestCallback(r -> r.setHttpMethod(HttpMethod.GET)).addRequestCallback(r -> r.setUrl("https://request.url")).addQueryParam("$skipToken", "1").addRequestCallback(r -> r.setHeader("x-ms-foo", "baz"));
        options.getRequestCallback().accept(request);
        HttpHeaders headers = request.getHeaders();
        Assertions.assertEquals((Object)"baz", (Object)headers.getValue("x-ms-foo"));
        Assertions.assertEquals((Object)HttpMethod.GET, (Object)request.getHttpMethod());
        Assertions.assertEquals((Object)"https://request.url?%24skipToken=1", (Object)request.getUrl().toString());
    }
}

