/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation;

import com.azure.core.implementation.Option;
import com.azure.core.implementation.OptionModule;
import com.azure.core.util.serializer.JacksonAdapter;
import com.azure.core.util.serializer.SerializerEncoding;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.Module;
import java.io.IOException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class OptionSerializerTests {
    private static final JacksonAdapter ADAPTER;

    @Test
    public void canSerializeExplicitNull() throws IOException {
        PatchModel model = new PatchModel();
        model.setSku((Option<String>)Option.of(null));
        String serialized = ADAPTER.serialize((Object)model, SerializerEncoding.JSON);
        Assertions.assertEquals((Object)"{\"sku\":null}", (Object)serialized);
        model.setSku((Option<String>)Option.empty());
        serialized = ADAPTER.serialize((Object)model, SerializerEncoding.JSON);
        Assertions.assertEquals((Object)"{\"sku\":null}", (Object)serialized);
    }

    @Test
    public void shouldIgnoreImplicitNull() throws IOException {
        PatchModel model = new PatchModel();
        String serialized = ADAPTER.serialize((Object)model, SerializerEncoding.JSON);
        Assertions.assertEquals((Object)"{}", (Object)serialized);
    }

    @Test
    public void shouldIgnoreUninitialized() throws IOException {
        PatchModel model = new PatchModel();
        model.setSku((Option<String>)Option.uninitialized());
        String serialized = ADAPTER.serialize((Object)model, SerializerEncoding.JSON);
        Assertions.assertEquals((Object)"{}", (Object)serialized);
    }

    @Test
    public void canSerializeNonNullValue() throws IOException {
        PatchModel model = new PatchModel();
        model.setSku((Option<String>)Option.of((Object)"basic"));
        String serialized = ADAPTER.serialize((Object)model, SerializerEncoding.JSON);
        Assertions.assertEquals((Object)"{\"sku\":\"basic\"}", (Object)serialized);
    }

    @Test
    public void canSerializeRawType() throws IOException {
        Option rawOption = Option.of((Object)new RawModel().setName("test"));
        String serialized = ADAPTER.serialize((Object)rawOption, SerializerEncoding.JSON);
        Assertions.assertEquals((Object)"{\"name\":\"test\"}", (Object)serialized);
        Option rawOption1 = Option.of((Object)"test");
        String serialized1 = ADAPTER.serialize((Object)rawOption1, SerializerEncoding.JSON);
        Assertions.assertEquals((Object)"\"test\"", (Object)serialized1);
    }

    static {
        JacksonAdapter adapter = new JacksonAdapter();
        adapter.serializer().registerModule((Module)new OptionModule());
        ADAPTER = adapter;
    }

    private static class RawModel {
        @JsonProperty(value="name")
        private String name;

        private RawModel() {
        }

        RawModel setName(String name) {
            this.name = name;
            return this;
        }
    }

    private static class PatchModel {
        @JsonProperty(value="sku")
        private Option<String> sku;

        private PatchModel() {
        }

        PatchModel setSku(Option<String> sku) {
            this.sku = sku;
            return this;
        }
    }
}

