/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation;

import com.azure.core.implementation.RetriableDownloadFlux;
import com.azure.core.util.FluxUtil;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.test.StepVerifier;

public class RetriableDownloadFluxTests {
    @Test
    public void initialDownloadIsEmpty() {
        RetriableDownloadFlux retriableDownloadFlux = new RetriableDownloadFlux(Flux::empty, (ignoredThrowable, ignoredOffset) -> Flux.empty(), 0, 0L);
        StepVerifier.create((Publisher)FluxUtil.collectBytesInByteBufferStream((Flux)retriableDownloadFlux)).assertNext(bytes -> Assertions.assertEquals((int)0, (int)((byte[])bytes).length)).verifyComplete();
    }

    @Test
    public void initialDownloadIsAnErrorButRetries() {
        RetriableDownloadFlux retriableDownloadFlux = new RetriableDownloadFlux(() -> Flux.error((Throwable)new RuntimeException()), (ignoredThrowable, ignoredOffset) -> Flux.empty(), 1, 0L);
        StepVerifier.create((Publisher)FluxUtil.collectBytesInByteBufferStream((Flux)retriableDownloadFlux)).assertNext(bytes -> Assertions.assertEquals((int)0, (int)((byte[])bytes).length)).verifyComplete();
    }

    @Test
    public void initialDownloadAndRetryErrorButRetriesUntilCompletion() {
        AtomicInteger retryCount = new AtomicInteger(0);
        RetriableDownloadFlux retriableDownloadFlux = new RetriableDownloadFlux(() -> Flux.error((Throwable)new RuntimeException()), (throwable, offset) -> {
            if (retryCount.getAndIncrement() == 0) {
                return Flux.error((Throwable)new RuntimeException());
            }
            return Flux.empty();
        }, 2, 0L);
        StepVerifier.create((Publisher)FluxUtil.collectBytesInByteBufferStream((Flux)retriableDownloadFlux)).assertNext(bytes -> Assertions.assertEquals((int)0, (int)((byte[])bytes).length)).verifyComplete();
    }

    @Test
    public void initialDownloadIsAnErrorAndNoRetriesAreAvailable() {
        RetriableDownloadFlux retriableDownloadFlux = new RetriableDownloadFlux(() -> Flux.error((Throwable)new RuntimeException()), (ignoredThrowable, ignoredOffset) -> Flux.empty(), 0, 0L);
        StepVerifier.create((Publisher)FluxUtil.collectBytesInByteBufferStream((Flux)retriableDownloadFlux)).verifyError(RuntimeException.class);
    }

    @Test
    public void initialDownloadIsANonRetriableError() {
        RetriableDownloadFlux retriableDownloadFlux = new RetriableDownloadFlux(() -> Flux.error((Throwable)new RuntimeException()), (throwable, offset) -> {
            if (!(throwable instanceof IOException)) {
                return Flux.error((Throwable)throwable);
            }
            return Flux.empty();
        }, 1, 0L);
        StepVerifier.create((Publisher)FluxUtil.collectBytesInByteBufferStream((Flux)retriableDownloadFlux)).verifyError(RuntimeException.class);
    }

    @Test
    public void retryFailsWithNonRetriableError() {
        RetriableDownloadFlux retriableDownloadFlux = new RetriableDownloadFlux(() -> Flux.error((Throwable)new IOException()), (throwable, offset) -> {
            if (!(throwable instanceof IOException)) {
                return Flux.error((Throwable)throwable);
            }
            return Flux.error((Throwable)new RuntimeException());
        }, 1, 0L);
        StepVerifier.create((Publisher)FluxUtil.collectBytesInByteBufferStream((Flux)retriableDownloadFlux)).verifyError(RuntimeException.class);
    }

    @Test
    public void allRetriesAreConsumed() {
        RetriableDownloadFlux retriableDownloadFlux = new RetriableDownloadFlux(() -> Flux.error((Throwable)new RuntimeException()), (throwable, offset) -> Flux.error((Throwable)new RuntimeException()), 100, 0L);
        StepVerifier.create((Publisher)FluxUtil.collectBytesInByteBufferStream((Flux)retriableDownloadFlux)).verifyError(RuntimeException.class);
    }

    @Test
    public void multipleSubscriptionsWorkAppropriately() {
        RetriableDownloadFlux retriableDownloadFlux = new RetriableDownloadFlux(() -> RetriableDownloadFluxTests.generateFromOffset(0L), (throwable, offset) -> RetriableDownloadFluxTests.generateFromOffset(offset), 1, 0L);
        byte[] expected = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        StepVerifier.create((Publisher)Flux.range((int)0, (int)100).parallel().flatMap(ignored -> FluxUtil.collectBytesInByteBufferStream((Flux)retriableDownloadFlux)).map(bytes -> {
            Assertions.assertArrayEquals((byte[])expected, (byte[])bytes);
            return bytes;
        }).then()).verifyComplete();
    }

    @Test
    public void downloadFromAnInitialOffset() {
        RetriableDownloadFlux retriableDownloadFlux = new RetriableDownloadFlux(() -> Flux.error((Throwable)new IOException()), (throwable, offset) -> {
            if (!(throwable instanceof IOException)) {
                return Flux.error((Throwable)throwable);
            }
            return RetriableDownloadFluxTests.generateFromOffset(offset);
        }, 1, 5L);
        byte[] expected = new byte[]{0, 0, 0, 0, 0};
        StepVerifier.create((Publisher)FluxUtil.collectBytesInByteBufferStream((Flux)retriableDownloadFlux)).assertNext(bytes -> Assertions.assertArrayEquals((byte[])expected, (byte[])bytes)).verifyComplete();
    }

    private static Flux<ByteBuffer> generateFromOffset(long offset) {
        return Flux.generate(() -> offset, (count, sink) -> {
            if (count >= 10L) {
                sink.complete();
            } else {
                sink.next((Object)ByteBuffer.wrap(new byte[]{0}));
            }
            return count + 1L;
        });
    }
}

