/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.models;

import com.azure.core.models.CloudEvent;
import com.azure.core.models.CloudEventDataFormat;
import com.azure.core.util.BinaryData;
import java.nio.charset.StandardCharsets;
import java.util.List;

public class CloudEventJavaDocCodeSnippet {
    public void createCloudEvent() {
        byte[] exampleBytes = "Hello World".getBytes(StandardCharsets.UTF_8);
        CloudEvent cloudEvent = new CloudEvent("/cloudevents/example/source", "Example.EventType", BinaryData.fromBytes((byte[])exampleBytes), CloudEventDataFormat.BYTES, "application/octet-stream");
        User user = new User("Stephen", "James");
        CloudEvent cloudEventDataObject = new CloudEvent("/cloudevents/example/source", "Example.EventType", BinaryData.fromObject((Object)user), CloudEventDataFormat.JSON, "application/json");
        CloudEvent cloudEventDataStr = new CloudEvent("/cloudevents/example/source", "Example.EventType", BinaryData.fromObject((Object)"Hello World"), CloudEventDataFormat.JSON, "text/plain");
        CloudEvent cloudEventDataInt = new CloudEvent("/cloudevents/example/source", "Example.EventType", BinaryData.fromObject((Object)1), CloudEventDataFormat.JSON, "int");
        CloudEvent cloudEventDataBool = new CloudEvent("/cloudevents/example/source", "Example.EventType", BinaryData.fromObject((Object)true), CloudEventDataFormat.JSON, "bool");
        CloudEvent cloudEventDataNull = new CloudEvent("/cloudevents/example/source", "Example.EventType", BinaryData.fromObject(null), CloudEventDataFormat.JSON, "null");
        String jsonStringForData = "\"Hello World\"";
        CloudEvent cloudEventDataJsonStr = new CloudEvent("/cloudevents/example/source", "Example.EventType", BinaryData.fromString((String)jsonStringForData), CloudEventDataFormat.JSON, "text/plain");
    }

    public void fromJsonStringWithDataJson() {
        String cloudEventJsonString = "<A CloudEvent Json String>";
        List cloudEventList = CloudEvent.fromString((String)cloudEventJsonString);
        CloudEvent cloudEvent = (CloudEvent)cloudEventList.get(0);
        BinaryData cloudEventData = cloudEvent.getData();
        byte[] bytesValue = cloudEventData.toBytes();
        User objectValue = (User)cloudEventData.toObject(User.class);
        int intValue = (Integer)cloudEventData.toObject(Integer.class);
        boolean boolValue = (Boolean)cloudEventData.toObject(Boolean.class);
        String stringValue = (String)cloudEventData.toObject(String.class);
        String jsonStringValue = cloudEventData.toString();
    }

    private static class User {
        private final String firstName;
        private final String lastName;

        User(String firstName, String lastName) {
            this.firstName = firstName;
            this.lastName = lastName;
        }

        public String getFirstName() {
            return this.firstName;
        }

        public String getLastName() {
            return this.lastName;
        }
    }
}

