/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.models;

import com.azure.core.implementation.serializer.DefaultJsonSerializer;
import com.azure.core.models.CloudEvent;
import com.azure.core.models.CloudEventDataFormat;
import com.azure.core.util.BinaryData;
import com.azure.core.util.serializer.ObjectSerializer;
import com.azure.core.util.serializer.TypeReference;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class CloudEventTests {
    private static final DefaultJsonSerializer SERIALIZER = new DefaultJsonSerializer();

    @Test
    public void testRoundTripCloudEvents() throws IOException {
        String cloudEventJson = this.getTestPayloadFromFile("CloudEventDifferentDataTypes.json");
        CloudEvent cloudEvent = (CloudEvent)CloudEvent.fromString((String)cloudEventJson).get(0);
        HashMap<String, Object> map = new HashMap<String, Object>(){
            {
                this.put("str", "str value");
                this.put("number", 1.3);
                this.put("integer", 1);
                this.put("bool", true);
                this.put("null", null);
                this.put("array", new ArrayList<Integer>(){
                    {
                        this.add(1);
                        this.add(2);
                        this.add(3);
                    }
                });
                this.put("object", new HashMap<String, String>(){
                    {
                        this.put("okey", "ovalue");
                    }
                });
            }
        };
        Assertions.assertNotNull((Object)cloudEvent);
        Assertions.assertEquals((Object)"/testresource", (Object)cloudEvent.getSource());
        Assertions.assertEquals((Object)"Microsoft.MockPublisher.TestEvent", (Object)cloudEvent.getType());
        Assertions.assertEquals((Object)OffsetDateTime.parse("2020-07-21T18:41:31.166Z"), (Object)cloudEvent.getTime());
        Assertions.assertEquals((Object)"9ddf9b10-fe3d-4a16-94bc-c0298924ded1", (Object)cloudEvent.getId());
        Assertions.assertEquals((Object)"1.0", (Object)cloudEvent.getSpecVersion());
        Assertions.assertEquals((Object)"testsubject", (Object)cloudEvent.getSubject());
        Assertions.assertEquals((Object)"/testschema", (Object)cloudEvent.getDataSchema());
        Assertions.assertEquals((Object)"application/json", (Object)cloudEvent.getDataContentType());
        Assertions.assertEquals((Object)map, (Object)cloudEvent.getData().toObject(Map.class, (ObjectSerializer)SERIALIZER));
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            SERIALIZER.serialize((OutputStream)bos, (Object)cloudEvent);
            String serialized = bos.toString();
            this.assertMapAndJsonNode((Map<String, Object>)map, serialized);
            CloudEvent cloudEvent2 = (CloudEvent)CloudEvent.fromString((String)serialized).get(0);
            Assertions.assertEquals((Object)"/testresource", (Object)cloudEvent2.getSource());
            Assertions.assertEquals((Object)"Microsoft.MockPublisher.TestEvent", (Object)cloudEvent2.getType());
            Assertions.assertEquals((Object)OffsetDateTime.parse("2020-07-21T18:41:31.166Z"), (Object)cloudEvent2.getTime());
            Assertions.assertEquals((Object)"9ddf9b10-fe3d-4a16-94bc-c0298924ded1", (Object)cloudEvent2.getId());
            Assertions.assertEquals((Object)"1.0", (Object)cloudEvent2.getSpecVersion());
            Assertions.assertEquals((Object)"testsubject", (Object)cloudEvent2.getSubject());
            Assertions.assertEquals((Object)"/testschema", (Object)cloudEvent2.getDataSchema());
            Assertions.assertEquals((Object)"application/json", (Object)cloudEvent2.getDataContentType());
            BinaryData data2 = cloudEvent.getData();
            Map deserializedData2 = (Map)data2.toObject((TypeReference)new TypeReference<Map<String, Object>>(){}, (ObjectSerializer)SERIALIZER);
            Assertions.assertEquals((Object)map, (Object)deserializedData2);
        }
    }

    @Test
    public void deserializeCloudEventsFailValidation() throws IOException {
        String cloudEventJson = this.getTestPayloadFromFile("CloudEventNoType.json");
        Assertions.assertThrows(IllegalArgumentException.class, () -> CloudEvent.fromString((String)cloudEventJson));
    }

    @Test
    public void deserializeCloudEventsSkipValidation() throws IOException {
        String cloudEventJson = this.getTestPayloadFromFile("CloudEventNoType.json");
        Assertions.assertDoesNotThrow(() -> CloudEvent.fromString((String)cloudEventJson, (boolean)true));
    }

    @Test
    public void deserializeCloudEventWithoutArrayBrackets() throws IOException {
        String cloudEventJson = this.getTestPayloadFromFile("CloudEventNoArray.json");
        List events = CloudEvent.fromString((String)cloudEventJson);
        Assertions.assertNotNull((Object)events);
        Assertions.assertEquals((int)1, (int)events.size());
        ContosoItemReceivedEventData data = (ContosoItemReceivedEventData)((CloudEvent)events.get(0)).getData().toObject(ContosoItemReceivedEventData.class, (ObjectSerializer)SERIALIZER);
        Assertions.assertNotNull((Object)data);
        Assertions.assertEquals((Object)"512d38b6-c7b8-40c8-89fe-f46f9e9622b6", (Object)data.getItemSku());
        Map additionalProperties = ((CloudEvent)events.get(0)).getExtensionAttributes();
        Assertions.assertNotNull((Object)additionalProperties);
        Assertions.assertTrue((boolean)additionalProperties.containsKey("foo"));
        Assertions.assertEquals((Object)"bar", additionalProperties.get("foo"));
    }

    @Test
    public void deserializeCloudEventWithNullData() throws IOException {
        String cloudEventJson = this.getTestPayloadFromFile("CloudEventNullData.json");
        List events = CloudEvent.fromString((String)cloudEventJson);
        Assertions.assertNotNull((Object)events);
        Assertions.assertEquals((int)1, (int)events.size());
        Assertions.assertNull((Object)((CloudEvent)events.get(0)).getData());
    }

    @Test
    public void deserializeCloudEventWithBinaryData() throws IOException {
        String cloudEventJson = this.getTestPayloadFromFile("CloudEventBinaryData.json");
        List events = CloudEvent.fromString((String)cloudEventJson);
        Assertions.assertNotNull((Object)events);
        Assertions.assertEquals((int)1, (int)events.size());
        byte[] eventData = ((CloudEvent)events.get(0)).getData().toBytes();
        Assertions.assertNotNull((Object)eventData);
        Assertions.assertArrayEquals((byte[])Base64.getDecoder().decode("c2FtcGxlYmluYXJ5ZGF0YQ=="), (byte[])eventData);
    }

    @Test
    public void deserializeCloudEventJsonData() throws IOException {
        String cloudEventJson = this.getTestPayloadFromFile("CloudEventJsonData.json");
        List events = CloudEvent.fromString((String)cloudEventJson);
        Assertions.assertNotNull((Object)events);
        Assertions.assertEquals((int)1, (int)events.size());
        ContosoItemReceivedEventData data = (ContosoItemReceivedEventData)((CloudEvent)events.get(0)).getData().toObject(ContosoItemReceivedEventData.class, (ObjectSerializer)SERIALIZER);
        Assertions.assertNotNull((Object)data);
        Assertions.assertEquals((Object)"512d38b6-c7b8-40c8-89fe-f46f9e9622b6", (Object)data.getItemSku());
        Map additionalProperties = ((CloudEvent)events.get(0)).getExtensionAttributes();
        Assertions.assertNotNull((Object)additionalProperties);
        Assertions.assertTrue((boolean)additionalProperties.containsKey("foo"));
        Assertions.assertEquals((Object)"bar", additionalProperties.get("foo"));
    }

    @Test
    public void deserializeCloudEventXmlData() throws IOException {
        String cloudEventJson = this.getTestPayloadFromFile("CloudEventXmlData.json");
        List events = CloudEvent.fromString((String)cloudEventJson);
        Assertions.assertNotNull((Object)events);
        Assertions.assertEquals((int)1, (int)events.size());
        Assertions.assertEquals(((CloudEvent)events.get(0)).getExtensionAttributes().get("comexampleothervalue"), (Object)5);
        String xmlData = (String)((CloudEvent)events.get(0)).getData().toObject(String.class, (ObjectSerializer)SERIALIZER);
        Assertions.assertEquals((Object)"<much wow=\"xml\"/>", (Object)xmlData);
    }

    @Test
    public void serializeByteData() throws IOException {
        String dataPayload = "AAA";
        BinaryData binaryData = BinaryData.fromBytes((byte[])"AAA".getBytes(StandardCharsets.UTF_8));
        CloudEvent cloudEvent = new CloudEvent("/testSource", "CloudEvent.Test", binaryData, CloudEventDataFormat.BYTES, "bytes").setDataSchema("/testSchema").setSubject("testSubject").setTime(OffsetDateTime.now()).setSpecVersion("1.0").addExtensionAttribute("foo", (Object)"value");
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            SERIALIZER.serialize((OutputStream)bos, (Object)cloudEvent);
            String serializedString = bos.toString();
            CloudEvent deserializedCloudEvent = (CloudEvent)CloudEvent.fromString((String)serializedString).get(0);
            Assertions.assertEquals((Object)cloudEvent.getData().toString(), (Object)deserializedCloudEvent.getData().toString());
            Assertions.assertEquals((Object)"AAA", (Object)cloudEvent.getData().toString());
            this.compareCloudEventContent(cloudEvent, deserializedCloudEvent);
        }
    }

    @Test
    public void serializeJsonData() throws IOException {
        HashMap<String, Object> mapData = new HashMap<String, Object>(){
            {
                this.put("Field1", "Value1");
                this.put("Field2", "Value2");
            }
        };
        BinaryData binaryData = BinaryData.fromObject((Object)mapData, (ObjectSerializer)SERIALIZER);
        CloudEvent cloudEvent = new CloudEvent("/testSource", "CloudEvent.Test", binaryData, CloudEventDataFormat.JSON, "application/json").setDataSchema("/testSchema").setSubject("testSubject").setTime(OffsetDateTime.now()).setSpecVersion("1.0").addExtensionAttribute("foo", (Object)"value");
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            SERIALIZER.serialize((OutputStream)bos, (Object)cloudEvent);
            String serializedString = bos.toString();
            CloudEvent deserializedCloudEvent = (CloudEvent)CloudEvent.fromString((String)serializedString).get(0);
            Assertions.assertEquals((Object)mapData, (Object)deserializedCloudEvent.getData().toObject((TypeReference)new TypeReference<Map<String, Object>>(){}, (ObjectSerializer)SERIALIZER));
            this.compareCloudEventContent(cloudEvent, deserializedCloudEvent);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"primitiveDataValues"})
    public void serializePrimitiveData(Object dataValue) throws IOException {
        BinaryData binaryData = BinaryData.fromObject((Object)dataValue, (ObjectSerializer)SERIALIZER);
        CloudEvent cloudEvent = new CloudEvent("/testSource", "CloudEvent.Test", binaryData, CloudEventDataFormat.JSON, "application/json").setDataSchema("/testSchema").setSubject("testSubject").setTime(OffsetDateTime.now()).setSpecVersion("1.0");
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            SERIALIZER.serialize((OutputStream)bos, (Object)cloudEvent);
            String serializedString = bos.toString();
            ObjectMapper objectMapper = new ObjectMapper();
            JsonNode jsonNode = objectMapper.readTree(serializedString).get("data");
            if (jsonNode.isInt()) {
                Assertions.assertEquals((Object)dataValue, (Object)jsonNode.asInt());
            } else if (jsonNode.isDouble()) {
                Assertions.assertEquals((Object)dataValue, (Object)jsonNode.asDouble());
            } else if (jsonNode.isBoolean()) {
                Assertions.assertEquals((Object)dataValue, (Object)jsonNode.asBoolean());
            } else if (jsonNode.isTextual()) {
                Assertions.assertEquals((Object)dataValue, (Object)jsonNode.asText());
            } else {
                Assertions.fail((String)"Wrong JsonNode type. The serialized String might be wrong.");
            }
            CloudEvent deserializedCloudEvent = (CloudEvent)CloudEvent.fromString((String)serializedString).get(0);
            Assertions.assertEquals((Object)dataValue, (Object)deserializedCloudEvent.getData().toObject(dataValue.getClass(), (ObjectSerializer)SERIALIZER));
            this.compareCloudEventContent(cloudEvent, deserializedCloudEvent);
        }
    }

    private static Stream<Arguments> primitiveDataValues() {
        return Stream.of(Arguments.of((Object[])new Object[]{"str"}), Arguments.of((Object[])new Object[]{1}), Arguments.of((Object[])new Object[]{1.1}), Arguments.of((Object[])new Object[]{true}), Arguments.of((Object[])new Object[]{false}));
    }

    @Test
    public void serializeStringDataAsObject() throws IOException {
        String dataPayload = "AAA";
        BinaryData binaryData = BinaryData.fromObject((Object)"AAA", (ObjectSerializer)SERIALIZER);
        CloudEvent cloudEvent = new CloudEvent("/testSource", "CloudEvent.Test", binaryData, CloudEventDataFormat.JSON, "application/json").setDataSchema("/testSchema").setSubject("testSubject").setTime(OffsetDateTime.now()).setSpecVersion("1.0").addExtensionAttribute("foo", (Object)"value");
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            SERIALIZER.serialize((OutputStream)bos, (Object)cloudEvent);
            String serializedString = bos.toString();
            CloudEvent deserializedCloudEvent = (CloudEvent)CloudEvent.fromString((String)serializedString).get(0);
            Assertions.assertEquals((Object)"AAA", (Object)deserializedCloudEvent.getData().toObject(String.class, (ObjectSerializer)SERIALIZER));
            this.compareCloudEventContent(cloudEvent, deserializedCloudEvent);
        }
    }

    @Test
    public void serializeStringDataNonJsonLiteral() {
        String dataPayload = "AAA";
        BinaryData binaryData = BinaryData.fromString((String)"AAA");
        Assertions.assertThrows(IllegalArgumentException.class, () -> new CloudEvent("/testSource", "CloudEvent.Test", binaryData, CloudEventDataFormat.JSON, "application/json").setDataSchema("/testSchema").setSubject("testSubject").setTime(OffsetDateTime.now()).setSpecVersion("1.0").addExtensionAttribute("foo", (Object)"value"));
    }

    @Test
    public void serializeStringDataJsonLiteral() throws IOException {
        BinaryData binaryData = BinaryData.fromString((String)"{\"foo\":\"value\"}");
        CloudEvent cloudEvent = new CloudEvent("/testSource", "CloudEvent.Test", binaryData, CloudEventDataFormat.JSON, "application/json").setDataSchema("/testSchema").setSubject("testSubject").setTime(OffsetDateTime.now()).setSpecVersion("1.0").addExtensionAttribute("foo", (Object)"value");
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            SERIALIZER.serialize((OutputStream)bos, (Object)cloudEvent);
            String serializedString = bos.toString();
            CloudEvent deserializedCloudEvent = (CloudEvent)CloudEvent.fromString((String)serializedString).get(0);
            Assertions.assertEquals((Object)"{\"foo\":\"value\"}", (Object)deserializedCloudEvent.getData().toString());
            Map deserializedMap = (Map)deserializedCloudEvent.getData().toObject((TypeReference)new TypeReference<Map<String, String>>(){}, (ObjectSerializer)SERIALIZER);
            Assertions.assertEquals((Object)"value", deserializedMap.get("foo"));
            this.compareCloudEventContent(cloudEvent, deserializedCloudEvent);
        }
    }

    @Test
    public void serializeNullBinaryData() throws IOException {
        CloudEvent cloudEvent = new CloudEvent("/testSource", "CloudEvent.Test", null, CloudEventDataFormat.JSON, "application/json").setDataSchema("/testSchema").setSubject("testSubject").setTime(OffsetDateTime.now()).setSpecVersion("1.0").addExtensionAttribute("foo", (Object)"value");
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            SERIALIZER.serialize((OutputStream)bos, (Object)cloudEvent);
            String serializedString = bos.toString();
            CloudEvent deserializedCloudEvent = (CloudEvent)CloudEvent.fromString((String)serializedString).get(0);
            Assertions.assertNull((Object)deserializedCloudEvent.getData());
            Assertions.assertEquals((Object)"value", deserializedCloudEvent.getExtensionAttributes().get("foo"));
            this.compareCloudEventContent(cloudEvent, deserializedCloudEvent);
        }
    }

    @Test
    public void serializeBinaryDataFromNull() throws IOException {
        CloudEvent cloudEvent = new CloudEvent("/testSource", "CloudEvent.Test", null, CloudEventDataFormat.JSON, "application/json").setDataSchema("/testSchema").setSubject("testSubject").setTime(OffsetDateTime.now()).setSpecVersion("1.0").addExtensionAttribute("foo", (Object)"value");
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();){
            SERIALIZER.serialize((OutputStream)bos, (Object)cloudEvent);
            String serializedString = bos.toString();
            CloudEvent deserializedCloudEvent = (CloudEvent)CloudEvent.fromString((String)serializedString).get(0);
            Assertions.assertNull((Object)deserializedCloudEvent.getData());
            Assertions.assertEquals((Object)"value", deserializedCloudEvent.getExtensionAttributes().get("foo"));
            this.compareCloudEventContent(cloudEvent, deserializedCloudEvent);
        }
    }

    @ParameterizedTest
    @MethodSource(value={"addAttributeIllegalArgumentTestData"})
    public void addAttributeIllegalArgument(String attributeName, Object value) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new CloudEvent("/testsrouce", "testtype", BinaryData.fromObject((Object)"str", (ObjectSerializer)SERIALIZER), CloudEventDataFormat.JSON, "application/json").addExtensionAttribute(attributeName, value));
    }

    private static Stream<Arguments> addAttributeIllegalArgumentTestData() {
        return Stream.of(Arguments.of((Object[])new Object[]{"a_b", "value"}), Arguments.of((Object[])new Object[]{"Ab", 1}));
    }

    @ParameterizedTest
    @MethodSource(value={"addAttributeNullPointerTestData"})
    public void addAttributeNullPointer(String attributeName, Object value) {
        Assertions.assertThrows(NullPointerException.class, () -> new CloudEvent("/testsrouce", "testtype", BinaryData.fromObject((Object)"str", (ObjectSerializer)SERIALIZER), CloudEventDataFormat.JSON, "application/json").addExtensionAttribute(attributeName, value));
    }

    private static Stream<Arguments> addAttributeNullPointerTestData() {
        return Stream.of(Arguments.of((Object[])new Object[]{null, "value"}), Arguments.of((Object[])new Object[]{"name", null}));
    }

    @Test
    public void addAttribute() {
        Assertions.assertDoesNotThrow(() -> new CloudEvent("/testsrouce", "testtype", BinaryData.fromObject((Object)"str", (ObjectSerializer)SERIALIZER), CloudEventDataFormat.JSON, "application/json").addExtensionAttribute("name", (Object)"value"));
    }

    private String getTestPayloadFromFile(String fileName) throws IOException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        try (InputStream inputStream = classLoader.getResourceAsStream("CloudEvent/" + fileName);){
            byte[] bytes = new byte[inputStream.available()];
            inputStream.read(bytes);
            String string = new String(bytes);
            return string;
        }
    }

    private void compareCloudEventContent(CloudEvent cloudEvent, CloudEvent deserializedCloudEvent) {
        Assertions.assertEquals((Object)cloudEvent.getSpecVersion(), (Object)deserializedCloudEvent.getSpecVersion());
        Assertions.assertEquals((Object)cloudEvent.getDataSchema(), (Object)deserializedCloudEvent.getDataSchema());
        Assertions.assertEquals((Object)cloudEvent.getDataContentType(), (Object)deserializedCloudEvent.getDataContentType());
        Assertions.assertEquals((Object)cloudEvent.getId(), (Object)deserializedCloudEvent.getId());
        Assertions.assertEquals((Object)cloudEvent.getExtensionAttributes(), (Object)deserializedCloudEvent.getExtensionAttributes());
        Assertions.assertEquals((Object)cloudEvent.getSource(), (Object)deserializedCloudEvent.getSource());
        Assertions.assertEquals((Object)cloudEvent.getSubject(), (Object)deserializedCloudEvent.getSubject());
        Assertions.assertEquals((Object)cloudEvent.getTime().toInstant(), (Object)deserializedCloudEvent.getTime().toInstant());
        Assertions.assertEquals((Object)cloudEvent.getType(), (Object)deserializedCloudEvent.getType());
    }

    private void assertMapAndJsonNode(Map<String, Object> map, String jsonString) throws JsonProcessingException {
        ObjectMapper objectMapper = new ObjectMapper();
        JsonNode jsonNode = objectMapper.readTree(jsonString);
        this.assertMapAndJsonNode(map, jsonNode.get("data"));
    }

    private void assertMapAndJsonNode(Map<String, Object> map, JsonNode jsonNode) {
        map.forEach((key, value) -> {
            if (value instanceof Map) {
                this.assertMapAndJsonNode((Map<String, Object>)((Map)map.get(key)), jsonNode.get(key));
            } else if (value instanceof String) {
                Assertions.assertEquals((Object)value, (Object)jsonNode.get(key).asText());
            } else if (value instanceof Boolean) {
                Assertions.assertEquals((Object)value, (Object)jsonNode.get(key).asBoolean());
            } else if (value instanceof Integer) {
                Assertions.assertEquals((Object)value, (Object)jsonNode.get(key).asInt());
            } else if (value instanceof Double) {
                Assertions.assertEquals((Object)value, (Object)jsonNode.get(key).asDouble());
            } else if (value instanceof List) {
                List elements = (List)value;
                JsonNode arrayNode = jsonNode.get(key);
                for (int i = 0; i < elements.size(); ++i) {
                    Assertions.assertEquals(elements.get(i), (Object)arrayNode.get(i).asInt());
                }
            }
        });
    }

    private static class ContosoItemReceivedEventData {
        @JsonProperty(value="itemSku", access=JsonProperty.Access.WRITE_ONLY)
        private String itemSku;
        @JsonProperty(value="itemUri", access=JsonProperty.Access.WRITE_ONLY)
        private String itemUri;

        private ContosoItemReceivedEventData() {
        }

        public String getItemSku() {
            return this.itemSku;
        }

        public String getItemUri() {
            return this.itemUri;
        }
    }
}

