/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.models;

import com.azure.core.models.GeoArray;
import com.azure.core.models.GeoLineString;
import com.azure.core.models.GeoLineStringCollection;
import com.azure.core.models.GeoLinearRing;
import com.azure.core.models.GeoPoint;
import com.azure.core.models.GeoPointCollection;
import com.azure.core.models.GeoPolygon;
import com.azure.core.models.GeoPolygonCollection;
import com.azure.core.models.GeoPosition;
import java.util.Arrays;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class GeoArrayTests {
    @Test
    public void pointCoordinates() {
        GeoPoint point = new GeoPoint(1.0, 2.0);
        Assertions.assertEquals((int)2, (int)point.getCoordinates().count());
        Assertions.assertEquals((double)1.0, (double)point.getCoordinates().get(0));
        Assertions.assertEquals((double)2.0, (double)point.getCoordinates().get(1));
        Assertions.assertThrows(IndexOutOfBoundsException.class, () -> point.getCoordinates().get(2));
    }

    @Test
    public void pointCoordinatesWithAltitude() {
        GeoPoint point = new GeoPoint(1.0, 2.0, Double.valueOf(3.0));
        Assertions.assertEquals((int)3, (int)point.getCoordinates().count());
        Assertions.assertEquals((double)1.0, (double)point.getCoordinates().get(0));
        Assertions.assertEquals((double)2.0, (double)point.getCoordinates().get(1));
        Assertions.assertEquals((double)3.0, (double)point.getCoordinates().get(2));
    }

    @Test
    public void pointCollectionCoordinates() {
        GeoPointCollection pointCollection = new GeoPointCollection(Arrays.asList(new GeoPoint(1.0, 2.0), new GeoPoint(3.0, 4.0)));
        Assertions.assertEquals((int)2, (int)pointCollection.getCoordinates().size());
        Assertions.assertEquals((double)1.0, (double)((GeoPosition)pointCollection.getCoordinates().get(0)).get(0));
        Assertions.assertEquals((double)2.0, (double)((GeoPosition)pointCollection.getCoordinates().get(0)).get(1));
        Assertions.assertEquals((double)3.0, (double)((GeoPosition)pointCollection.getCoordinates().get(1)).get(0));
        Assertions.assertEquals((double)4.0, (double)((GeoPosition)pointCollection.getCoordinates().get(1)).get(1));
    }

    @Test
    public void lineCoordinates() {
        GeoLineString line = new GeoLineString(Arrays.asList(new GeoPosition(1.0, 2.0), new GeoPosition(3.0, 4.0), new GeoPosition(5.0, 6.0)));
        Assertions.assertEquals((int)3, (int)line.getCoordinates().size());
        Assertions.assertEquals((double)1.0, (double)((GeoPosition)line.getCoordinates().get(0)).get(0));
        Assertions.assertEquals((double)2.0, (double)((GeoPosition)line.getCoordinates().get(0)).get(1));
        Assertions.assertEquals((double)3.0, (double)((GeoPosition)line.getCoordinates().get(1)).get(0));
        Assertions.assertEquals((double)4.0, (double)((GeoPosition)line.getCoordinates().get(1)).get(1));
        Assertions.assertEquals((double)5.0, (double)((GeoPosition)line.getCoordinates().get(2)).get(0));
        Assertions.assertEquals((double)6.0, (double)((GeoPosition)line.getCoordinates().get(2)).get(1));
    }

    @Test
    public void lineCollectionCoordinates() {
        GeoLineStringCollection lineCollection = new GeoLineStringCollection(Arrays.asList(new GeoLineString(Arrays.asList(new GeoPosition(1.0, 2.0), new GeoPosition(3.0, 4.0))), new GeoLineString(Arrays.asList(new GeoPosition(5.0, 6.0), new GeoPosition(7.0, 8.0)))));
        Assertions.assertEquals((int)2, (int)lineCollection.getCoordinates().size());
        Assertions.assertEquals((double)1.0, (double)((GeoPosition)((GeoArray)lineCollection.getCoordinates().get(0)).get(0)).get(0));
        Assertions.assertEquals((double)2.0, (double)((GeoPosition)((GeoArray)lineCollection.getCoordinates().get(0)).get(0)).get(1));
        Assertions.assertEquals((double)3.0, (double)((GeoPosition)((GeoArray)lineCollection.getCoordinates().get(0)).get(1)).get(0));
        Assertions.assertEquals((double)4.0, (double)((GeoPosition)((GeoArray)lineCollection.getCoordinates().get(0)).get(1)).get(1));
        Assertions.assertEquals((double)5.0, (double)((GeoPosition)((GeoArray)lineCollection.getCoordinates().get(1)).get(0)).get(0));
        Assertions.assertEquals((double)6.0, (double)((GeoPosition)((GeoArray)lineCollection.getCoordinates().get(1)).get(0)).get(1));
        Assertions.assertEquals((double)7.0, (double)((GeoPosition)((GeoArray)lineCollection.getCoordinates().get(1)).get(1)).get(0));
        Assertions.assertEquals((double)8.0, (double)((GeoPosition)((GeoArray)lineCollection.getCoordinates().get(1)).get(1)).get(1));
    }

    @Test
    public void polygonCoordinates() {
        GeoPolygon polygon = new GeoPolygon(Arrays.asList(new GeoLinearRing(Arrays.asList(new GeoPosition(1.0, 1.0), new GeoPosition(1.0, 2.0), new GeoPosition(2.0, 2.0), new GeoPosition(1.0, 1.0))), new GeoLinearRing(Arrays.asList(new GeoPosition(5.0, 5.0), new GeoPosition(5.0, 6.0), new GeoPosition(6.0, 6.0), new GeoPosition(5.0, 5.0)))));
        Assertions.assertEquals((int)2, (int)polygon.getCoordinates().size());
        Assertions.assertEquals((double)1.0, (double)((GeoPosition)((GeoArray)polygon.getCoordinates().get(0)).get(0)).get(0));
        Assertions.assertEquals((double)1.0, (double)((GeoPosition)((GeoArray)polygon.getCoordinates().get(0)).get(0)).get(1));
        Assertions.assertEquals((double)1.0, (double)((GeoPosition)((GeoArray)polygon.getCoordinates().get(0)).get(1)).get(0));
        Assertions.assertEquals((double)2.0, (double)((GeoPosition)((GeoArray)polygon.getCoordinates().get(0)).get(1)).get(1));
        Assertions.assertEquals((double)2.0, (double)((GeoPosition)((GeoArray)polygon.getCoordinates().get(0)).get(2)).get(0));
        Assertions.assertEquals((double)2.0, (double)((GeoPosition)((GeoArray)polygon.getCoordinates().get(0)).get(2)).get(1));
        Assertions.assertEquals((double)1.0, (double)((GeoPosition)((GeoArray)polygon.getCoordinates().get(0)).get(3)).get(0));
        Assertions.assertEquals((double)1.0, (double)((GeoPosition)((GeoArray)polygon.getCoordinates().get(0)).get(3)).get(1));
        Assertions.assertEquals((double)5.0, (double)((GeoPosition)((GeoArray)polygon.getCoordinates().get(1)).get(0)).get(0));
        Assertions.assertEquals((double)5.0, (double)((GeoPosition)((GeoArray)polygon.getCoordinates().get(1)).get(0)).get(1));
        Assertions.assertEquals((double)5.0, (double)((GeoPosition)((GeoArray)polygon.getCoordinates().get(1)).get(1)).get(0));
        Assertions.assertEquals((double)6.0, (double)((GeoPosition)((GeoArray)polygon.getCoordinates().get(1)).get(1)).get(1));
        Assertions.assertEquals((double)6.0, (double)((GeoPosition)((GeoArray)polygon.getCoordinates().get(1)).get(2)).get(0));
        Assertions.assertEquals((double)6.0, (double)((GeoPosition)((GeoArray)polygon.getCoordinates().get(1)).get(2)).get(1));
        Assertions.assertEquals((double)5.0, (double)((GeoPosition)((GeoArray)polygon.getCoordinates().get(1)).get(3)).get(0));
        Assertions.assertEquals((double)5.0, (double)((GeoPosition)((GeoArray)polygon.getCoordinates().get(1)).get(3)).get(1));
    }

    @Test
    public void polygonCollectionCoordinates() {
        GeoPolygonCollection polygonCollection = new GeoPolygonCollection(Arrays.asList(new GeoPolygon(Arrays.asList(new GeoLinearRing(Arrays.asList(new GeoPosition(1.0, 1.0), new GeoPosition(1.0, 2.0), new GeoPosition(2.0, 2.0), new GeoPosition(1.0, 1.0))), new GeoLinearRing(Arrays.asList(new GeoPosition(5.0, 5.0), new GeoPosition(5.0, 6.0), new GeoPosition(6.0, 6.0), new GeoPosition(5.0, 5.0))))), new GeoPolygon(Arrays.asList(new GeoLinearRing(Arrays.asList(new GeoPosition(9.0, 9.0), new GeoPosition(9.0, 10.0), new GeoPosition(10.0, 10.0), new GeoPosition(9.0, 9.0))), new GeoLinearRing(Arrays.asList(new GeoPosition(13.0, 13.0), new GeoPosition(13.0, 14.0), new GeoPosition(14.0, 14.0), new GeoPosition(13.0, 13.0)))))));
        Assertions.assertEquals((int)2, (int)polygonCollection.getCoordinates().size());
        GeoArray polygonCoordinates = (GeoArray)polygonCollection.getCoordinates().get(0);
        Assertions.assertEquals((double)1.0, (double)((GeoPosition)((GeoArray)polygonCoordinates.get(0)).get(0)).get(0));
        Assertions.assertEquals((double)1.0, (double)((GeoPosition)((GeoArray)polygonCoordinates.get(0)).get(0)).get(0));
        Assertions.assertEquals((double)1.0, (double)((GeoPosition)((GeoArray)polygonCoordinates.get(0)).get(1)).get(0));
        Assertions.assertEquals((double)2.0, (double)((GeoPosition)((GeoArray)polygonCoordinates.get(0)).get(1)).get(1));
        Assertions.assertEquals((double)2.0, (double)((GeoPosition)((GeoArray)polygonCoordinates.get(0)).get(2)).get(0));
        Assertions.assertEquals((double)2.0, (double)((GeoPosition)((GeoArray)polygonCoordinates.get(0)).get(2)).get(1));
        Assertions.assertEquals((double)1.0, (double)((GeoPosition)((GeoArray)polygonCoordinates.get(0)).get(3)).get(0));
        Assertions.assertEquals((double)1.0, (double)((GeoPosition)((GeoArray)polygonCoordinates.get(0)).get(3)).get(1));
        Assertions.assertEquals((double)5.0, (double)((GeoPosition)((GeoArray)polygonCoordinates.get(1)).get(0)).get(0));
        Assertions.assertEquals((double)5.0, (double)((GeoPosition)((GeoArray)polygonCoordinates.get(1)).get(0)).get(1));
        Assertions.assertEquals((double)5.0, (double)((GeoPosition)((GeoArray)polygonCoordinates.get(1)).get(1)).get(0));
        Assertions.assertEquals((double)6.0, (double)((GeoPosition)((GeoArray)polygonCoordinates.get(1)).get(1)).get(1));
        Assertions.assertEquals((double)6.0, (double)((GeoPosition)((GeoArray)polygonCoordinates.get(1)).get(2)).get(0));
        Assertions.assertEquals((double)6.0, (double)((GeoPosition)((GeoArray)polygonCoordinates.get(1)).get(2)).get(1));
        Assertions.assertEquals((double)5.0, (double)((GeoPosition)((GeoArray)polygonCoordinates.get(1)).get(3)).get(0));
        Assertions.assertEquals((double)5.0, (double)((GeoPosition)((GeoArray)polygonCoordinates.get(1)).get(3)).get(1));
        polygonCoordinates = (GeoArray)polygonCollection.getCoordinates().get(1);
        Assertions.assertEquals((double)9.0, (double)((GeoPosition)((GeoArray)polygonCoordinates.get(0)).get(0)).get(0));
        Assertions.assertEquals((double)9.0, (double)((GeoPosition)((GeoArray)polygonCoordinates.get(0)).get(0)).get(1));
        Assertions.assertEquals((double)9.0, (double)((GeoPosition)((GeoArray)polygonCoordinates.get(0)).get(1)).get(0));
        Assertions.assertEquals((double)10.0, (double)((GeoPosition)((GeoArray)polygonCoordinates.get(0)).get(1)).get(1));
        Assertions.assertEquals((double)10.0, (double)((GeoPosition)((GeoArray)polygonCoordinates.get(0)).get(2)).get(0));
        Assertions.assertEquals((double)10.0, (double)((GeoPosition)((GeoArray)polygonCoordinates.get(0)).get(2)).get(1));
        Assertions.assertEquals((double)9.0, (double)((GeoPosition)((GeoArray)polygonCoordinates.get(0)).get(3)).get(0));
        Assertions.assertEquals((double)9.0, (double)((GeoPosition)((GeoArray)polygonCoordinates.get(0)).get(3)).get(1));
        Assertions.assertEquals((double)13.0, (double)((GeoPosition)((GeoArray)polygonCoordinates.get(1)).get(0)).get(0));
        Assertions.assertEquals((double)13.0, (double)((GeoPosition)((GeoArray)polygonCoordinates.get(1)).get(0)).get(1));
        Assertions.assertEquals((double)13.0, (double)((GeoPosition)((GeoArray)polygonCoordinates.get(1)).get(1)).get(0));
        Assertions.assertEquals((double)14.0, (double)((GeoPosition)((GeoArray)polygonCoordinates.get(1)).get(1)).get(1));
        Assertions.assertEquals((double)14.0, (double)((GeoPosition)((GeoArray)polygonCoordinates.get(1)).get(2)).get(0));
        Assertions.assertEquals((double)14.0, (double)((GeoPosition)((GeoArray)polygonCoordinates.get(1)).get(2)).get(1));
        Assertions.assertEquals((double)13.0, (double)((GeoPosition)((GeoArray)polygonCoordinates.get(1)).get(3)).get(0));
        Assertions.assertEquals((double)13.0, (double)((GeoPosition)((GeoArray)polygonCoordinates.get(1)).get(3)).get(1));
    }
}

