/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.models;

import com.azure.core.models.GeoBoundingBox;
import com.azure.core.models.GeoTestHelpers;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class GeoBoundingBoxTests {
    @Test
    public void simpleConstructor() {
        double expectedWest = -180.0;
        double expectedSouth = -90.0;
        double expectedEast = 180.0;
        double expectedNorth = 90.0;
        GeoBoundingBox boundingBox = new GeoBoundingBox(expectedWest, expectedSouth, expectedEast, expectedNorth);
        Assertions.assertEquals((double)expectedWest, (double)boundingBox.getWest());
        Assertions.assertEquals((double)expectedSouth, (double)boundingBox.getSouth());
        Assertions.assertEquals((double)expectedEast, (double)boundingBox.getEast());
        Assertions.assertEquals((double)expectedNorth, (double)boundingBox.getNorth());
        Assertions.assertNull((Object)boundingBox.getMinAltitude());
        Assertions.assertNull((Object)boundingBox.getMaxAltitude());
    }

    @Test
    public void complexConstructor() {
        double expectedWest = -180.0;
        double expectedSouth = -90.0;
        double expectedEast = 180.0;
        double expectedNorth = 90.0;
        double expectedMinAltitude = -1000.0;
        double expectedMaxAltitude = 1000.0;
        GeoBoundingBox boundingBox = new GeoBoundingBox(expectedWest, expectedSouth, expectedEast, expectedNorth, expectedMinAltitude, expectedMaxAltitude);
        Assertions.assertEquals((double)expectedWest, (double)boundingBox.getWest());
        Assertions.assertEquals((double)expectedSouth, (double)boundingBox.getSouth());
        Assertions.assertEquals((double)expectedEast, (double)boundingBox.getEast());
        Assertions.assertEquals((double)expectedNorth, (double)boundingBox.getNorth());
        Assertions.assertEquals((double)expectedMinAltitude, (Double)boundingBox.getMinAltitude());
        Assertions.assertEquals((double)expectedMaxAltitude, (Double)boundingBox.getMaxAltitude());
    }

    @Test
    public void constructorDoesNotValidate() {
        double expectedWest = -200.0;
        double expectedSouth = -100.0;
        double expectedEast = 200.0;
        double expectedNorth = 100.0;
        GeoBoundingBox boundingBox = new GeoBoundingBox(expectedWest, expectedSouth, expectedEast, expectedNorth);
        Assertions.assertEquals((double)expectedWest, (double)boundingBox.getWest());
        Assertions.assertEquals((double)expectedSouth, (double)boundingBox.getSouth());
        Assertions.assertEquals((double)expectedEast, (double)boundingBox.getEast());
        Assertions.assertEquals((double)expectedNorth, (double)boundingBox.getNorth());
    }

    @ParameterizedTest
    @MethodSource(value={"equalsSupplier"})
    public void geoBoundingBoxEquals(GeoBoundingBox boundingBox, Object obj, boolean expected) {
        Assertions.assertEquals((Object)expected, (Object)boundingBox.equals(obj));
    }

    private static Stream<Arguments> equalsSupplier() {
        GeoBoundingBox pikePlaceBoundingBox = GeoTestHelpers.PIKES_PLACE_BOUNDING_BOX.get();
        GeoBoundingBox mtRainierBoundingBox = GeoTestHelpers.MT_RAINIER_BOUNDING_BOX.get();
        return Stream.of(Arguments.of((Object[])new Object[]{pikePlaceBoundingBox, null, false}), Arguments.of((Object[])new Object[]{pikePlaceBoundingBox, 1, false}), Arguments.of((Object[])new Object[]{pikePlaceBoundingBox, pikePlaceBoundingBox, true}), Arguments.of((Object[])new Object[]{mtRainierBoundingBox, mtRainierBoundingBox, true}), Arguments.of((Object[])new Object[]{pikePlaceBoundingBox, mtRainierBoundingBox, false}), Arguments.of((Object[])new Object[]{mtRainierBoundingBox, pikePlaceBoundingBox, false}), Arguments.of((Object[])new Object[]{pikePlaceBoundingBox, GeoTestHelpers.PIKES_PLACE_BOUNDING_BOX.get(), true}), Arguments.of((Object[])new Object[]{mtRainierBoundingBox, GeoTestHelpers.MT_RAINIER_BOUNDING_BOX.get(), true}));
    }
}

