/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.models;

import com.azure.core.models.GeoBoundingBox;
import com.azure.core.models.GeoLineString;
import com.azure.core.models.GeoLineStringCollection;
import com.azure.core.models.GeoTestHelpers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class GeoLineStringCollectionTests {
    @Test
    public void nullLinesThrows() {
        Assertions.assertThrows(NullPointerException.class, () -> new GeoLineStringCollection(null));
    }

    @Test
    public void simpleConstructor() {
        List<GeoLineString> expectedLines = Arrays.asList(GeoTestHelpers.SQUARE_LINE.get(), GeoTestHelpers.TRIANGLE_LINE.get());
        GeoLineStringCollection multiLine = new GeoLineStringCollection(expectedLines);
        Assertions.assertEquals(expectedLines, (Object)multiLine.getLines());
        Assertions.assertNull((Object)multiLine.getBoundingBox());
        Assertions.assertNull((Object)multiLine.getCustomProperties());
    }

    @Test
    public void complexConstructor() {
        List<GeoLineString> expectedLines = Arrays.asList(GeoTestHelpers.SQUARE_LINE.get(), GeoTestHelpers.TRIANGLE_LINE.get());
        GeoBoundingBox boundingBox = new GeoBoundingBox(0.0, 0.0, 1.0, 1.0);
        Map<String, String> properties = Collections.singletonMap("key", "value");
        GeoLineStringCollection multiLine = new GeoLineStringCollection(expectedLines, boundingBox, properties);
        Assertions.assertEquals(expectedLines, (Object)multiLine.getLines());
        Assertions.assertEquals((Object)boundingBox, (Object)multiLine.getBoundingBox());
        Assertions.assertEquals(properties, (Object)multiLine.getCustomProperties());
    }

    @Test
    public void constructorCopiesLines() {
        ArrayList<GeoLineString> expectedLines = new ArrayList<GeoLineString>();
        expectedLines.add(GeoTestHelpers.SQUARE_LINE.get());
        expectedLines.add(GeoTestHelpers.TRIANGLE_LINE.get());
        GeoLineStringCollection multiLine = new GeoLineStringCollection(expectedLines);
        Assertions.assertEquals(expectedLines, (Object)multiLine.getLines());
        expectedLines.add(GeoTestHelpers.RECTANGLE_LINE.get());
        Assertions.assertNotEquals(expectedLines, (Object)multiLine.getLines());
    }

    @ParameterizedTest
    @MethodSource(value={"equalsSupplier"})
    public void multiLineGeometriesEqual(GeoLineStringCollection multiLine, Object obj, boolean expected) {
        Assertions.assertEquals((Object)expected, (Object)multiLine.equals(obj));
    }

    private static Stream<Arguments> equalsSupplier() {
        List<GeoLineString> lines = Arrays.asList(GeoTestHelpers.SQUARE_LINE.get(), GeoTestHelpers.RECTANGLE_LINE.get());
        List<GeoLineString> lines1 = Arrays.asList(GeoTestHelpers.SQUARE_LINE.get(), GeoTestHelpers.TRIANGLE_LINE.get());
        GeoBoundingBox boundingBox = new GeoBoundingBox(0.0, 0.0, 1.0, 1.0);
        Map<String, String> properties = Collections.singletonMap("key", "value");
        GeoLineStringCollection multiLine = new GeoLineStringCollection(lines);
        GeoLineStringCollection multiLine1 = new GeoLineStringCollection(lines1, boundingBox, properties);
        return Stream.of(Arguments.of((Object[])new Object[]{multiLine, null, false}), Arguments.of((Object[])new Object[]{multiLine, 1, false}), Arguments.of((Object[])new Object[]{multiLine, multiLine, true}), Arguments.of((Object[])new Object[]{multiLine1, multiLine1, true}), Arguments.of((Object[])new Object[]{multiLine, multiLine1, false}), Arguments.of((Object[])new Object[]{multiLine1, multiLine, false}), Arguments.of((Object[])new Object[]{multiLine, new GeoLineStringCollection(lines), true}), Arguments.of((Object[])new Object[]{multiLine1, new GeoLineStringCollection(lines1, boundingBox, properties), true}));
    }
}

