/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.models;

import com.azure.core.models.GeoBoundingBox;
import com.azure.core.models.GeoObject;
import com.azure.core.models.GeoObjectType;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class GeoObjectTests {
    @Test
    public void defaultGeo() {
        ConcreteGeoObject geoObject = new ConcreteGeoObject(null, null);
        Assertions.assertNull((Object)geoObject.getCustomProperties());
        Assertions.assertNull((Object)geoObject.getBoundingBox());
    }

    @Test
    public void geoObjectCopiesPropertiesToUnmodifiableMap() {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        properties.put("key", "value");
        ConcreteGeoObject geoObject = new ConcreteGeoObject(null, properties);
        Assertions.assertEquals(properties, (Object)geoObject.getCustomProperties());
        properties.put("key2", "value2");
        Assertions.assertNotEquals(properties, (Object)geoObject.getCustomProperties());
        Assertions.assertThrows(UnsupportedOperationException.class, () -> geoObject.getCustomProperties().put("key2", "value2"));
    }

    @ParameterizedTest
    @MethodSource(value={"equalsSupplier"})
    public void geometriesEqual(GeoObject geoObject, Object obj, boolean expected) {
        Assertions.assertEquals((Object)expected, (Object)geoObject.equals(obj));
    }

    private static Stream<Arguments> equalsSupplier() {
        ConcreteGeoObject geoObject = new ConcreteGeoObject(null, null);
        ConcreteGeoObject geoObject1 = new ConcreteGeoObject(null, Collections.singletonMap("key", "value"));
        return Stream.of(Arguments.of((Object[])new Object[]{geoObject, null, false}), Arguments.of((Object[])new Object[]{geoObject, 1, false}), Arguments.of((Object[])new Object[]{geoObject, geoObject, true}), Arguments.of((Object[])new Object[]{geoObject1, geoObject1, true}), Arguments.of((Object[])new Object[]{geoObject, geoObject1, false}), Arguments.of((Object[])new Object[]{geoObject1, geoObject, false}), Arguments.of((Object[])new Object[]{geoObject, new ConcreteGeoObject(null, null), true}), Arguments.of((Object[])new Object[]{geoObject1, new ConcreteGeoObject(null, Collections.singletonMap("key", "value")), true}));
    }

    private static final class ConcreteGeoObject
    extends GeoObject {
        ConcreteGeoObject(GeoBoundingBox boundingBox, Map<String, Object> properties) {
            super(boundingBox, properties);
        }

        public GeoObjectType getType() {
            return null;
        }
    }
}

