/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.models;

import com.azure.core.models.GeoBoundingBox;
import com.azure.core.models.GeoPoint;
import com.azure.core.models.GeoPointCollection;
import com.azure.core.models.GeoPosition;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class GeoPointCollectionTests {
    @Test
    public void nullPointsThrows() {
        Assertions.assertThrows(NullPointerException.class, () -> new GeoPointCollection(null));
    }

    @Test
    public void simpleConstructor() {
        List<GeoPoint> points = Arrays.asList(new GeoPoint(new GeoPosition(0.0, 0.0)), new GeoPoint(new GeoPosition(1.0, 1.0)));
        GeoPointCollection multiPoint = new GeoPointCollection(points);
        Assertions.assertEquals(points, (Object)multiPoint.getPoints());
        Assertions.assertNull((Object)multiPoint.getBoundingBox());
        Assertions.assertNull((Object)multiPoint.getCustomProperties());
    }

    @Test
    public void complexConstructor() {
        List<GeoPoint> points = Arrays.asList(new GeoPoint(new GeoPosition(0.0, 0.0)), new GeoPoint(new GeoPosition(1.0, 1.0)));
        GeoBoundingBox boundingBox = new GeoBoundingBox(0.0, 0.0, 1.0, 1.0);
        Map<String, String> properties = Collections.singletonMap("key", "value");
        GeoPointCollection multiPoint = new GeoPointCollection(points, boundingBox, properties);
        Assertions.assertEquals(points, (Object)multiPoint.getPoints());
        Assertions.assertEquals((Object)boundingBox, (Object)multiPoint.getBoundingBox());
        Assertions.assertEquals(properties, (Object)multiPoint.getCustomProperties());
    }

    @Test
    public void constructorCopiesPoints() {
        ArrayList<GeoPoint> points = new ArrayList<GeoPoint>();
        points.add(new GeoPoint(new GeoPosition(0.0, 0.0)));
        points.add(new GeoPoint(new GeoPosition(1.0, 1.0)));
        GeoPointCollection multiPoint = new GeoPointCollection(points);
        Assertions.assertEquals(points, (Object)multiPoint.getPoints());
        points.add(new GeoPoint(new GeoPosition(0.0, 1.0)));
        Assertions.assertNotEquals(points, (Object)multiPoint.getPoints());
    }

    @ParameterizedTest
    @MethodSource(value={"equalsSupplier"})
    public void multiPointGeometriesEquals(GeoPointCollection multiPoint, Object obj, boolean expected) {
        Assertions.assertEquals((Object)expected, (Object)multiPoint.equals(obj));
    }

    private static Stream<Arguments> equalsSupplier() {
        List<GeoPoint> points = Arrays.asList(new GeoPoint(new GeoPosition(0.0, 0.0)), new GeoPoint(new GeoPosition(1.0, 1.0)));
        List<GeoPoint> points1 = Arrays.asList(new GeoPoint(new GeoPosition(0.0, 0.0)), new GeoPoint(new GeoPosition(0.0, 1.0)));
        GeoBoundingBox boundingBox = new GeoBoundingBox(0.0, 0.0, 1.0, 1.0);
        Map<String, String> properties = Collections.singletonMap("key", "value");
        GeoPointCollection multiPoint = new GeoPointCollection(points);
        GeoPointCollection multiPoint1 = new GeoPointCollection(points1, boundingBox, properties);
        return Stream.of(Arguments.of((Object[])new Object[]{multiPoint, null, false}), Arguments.of((Object[])new Object[]{multiPoint, 1, false}), Arguments.of((Object[])new Object[]{multiPoint, multiPoint, true}), Arguments.of((Object[])new Object[]{multiPoint1, multiPoint1, true}), Arguments.of((Object[])new Object[]{multiPoint, multiPoint1, false}), Arguments.of((Object[])new Object[]{multiPoint1, multiPoint, false}), Arguments.of((Object[])new Object[]{multiPoint, new GeoPointCollection(points), true}), Arguments.of((Object[])new Object[]{multiPoint1, new GeoPointCollection(points1, boundingBox, properties), true}));
    }
}

