/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import com.azure.core.http.HttpMethod;
import com.azure.core.util.AuthorizationChallengeHandler;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class AuthorizationChallengeHandlerTests {
    private static final String REALM = "realm";
    private static final String QOP = "qop";
    private static final String ALGORITHM = "algorithm";
    private static final String NONCE = "nonce";
    private static final String NEXT_NONCE = "nextnonce";
    private static final String OPAQUE = "opaque";
    private static final String USERHASH = "userhash";
    private static final String RESPONSE = "response";
    private static final String USERNAME = "username";
    private static final String DEFAULT_USERNAME = "Mufasa";
    private static final String DEFAULT_PASSWORD = "Circle Of Life";
    private static final String EXPECTED_BASIC = "Basic " + Base64.getEncoder().encodeToString(String.format("%s:%s", "Mufasa", "Circle Of Life").getBytes(StandardCharsets.UTF_8));
    private AutoCloseable openMocks;

    @BeforeEach
    public void prepareForTest() {
        this.openMocks = MockitoAnnotations.openMocks((Object)this);
    }

    @AfterEach
    public void clearMocks() throws Exception {
        this.openMocks.close();
    }

    @Test
    public void handleBasic() {
        AuthorizationChallengeHandler challengeHandler = AuthorizationChallengeHandlerTests.prepareChallengeHandler(DEFAULT_USERNAME, DEFAULT_PASSWORD);
        Assertions.assertEquals((Object)EXPECTED_BASIC, (Object)challengeHandler.handleBasic());
    }

    @Test
    public void pipelineBasic() {
        AuthorizationChallengeHandler challengeHandler = AuthorizationChallengeHandlerTests.prepareChallengeHandler(DEFAULT_USERNAME, DEFAULT_PASSWORD);
        Assertions.assertEquals((Object)EXPECTED_BASIC, (Object)challengeHandler.handleBasic());
        Assertions.assertEquals((Object)EXPECTED_BASIC, (Object)challengeHandler.attemptToPipelineAuthorization(null, null, null));
    }

    @Test
    public void pipelineBasicWithoutInitialHandleFails() {
        AuthorizationChallengeHandler challengeHandler = AuthorizationChallengeHandlerTests.prepareChallengeHandler(DEFAULT_USERNAME, DEFAULT_PASSWORD);
        Assertions.assertNull((Object)challengeHandler.attemptToPipelineAuthorization(null, null, null));
    }

    @Test
    public void md5DigestAuthorization() {
        AuthorizationChallengeHandler challengeHandler = AuthorizationChallengeHandlerTests.prepareChallengeHandler(DEFAULT_USERNAME, DEFAULT_PASSWORD);
        String expectedResponse = "6629fae49393a05397450978507c4ef1";
        String method = HttpMethod.GET.toString();
        String uri = "/dir/index.html";
        Map<String, String> challenge = AuthorizationChallengeHandlerTests.createChallenge("testrealm@host.com", "auth", "MD5", "dcd98b7102dd2f0e8b11d0f600bfb0c093", "5ccc069c403ebaf9f0171e9517f40e41", null);
        Mockito.when((Object)challengeHandler.generateNonce()).thenReturn((Object)"0a4f113b");
        String authorizationHeader = challengeHandler.handleDigest(method, uri, Collections.singletonList(challenge), () -> new byte[0]);
        Assertions.assertNotNull((Object)authorizationHeader);
        Assertions.assertEquals((Object)expectedResponse, (Object)AuthorizationChallengeHandlerTests.extractValue(authorizationHeader, RESPONSE));
    }

    @Test
    public void pipelineDigest() {
        AuthorizationChallengeHandler challengeHandler = AuthorizationChallengeHandlerTests.prepareChallengeHandler(DEFAULT_USERNAME, DEFAULT_PASSWORD);
        String expectedResponse = "6629fae49393a05397450978507c4ef1";
        String method = HttpMethod.GET.toString();
        String uri = "/dir/index.html";
        Map<String, String> challenge = AuthorizationChallengeHandlerTests.createChallenge("testrealm@host.com", "auth", "MD5", "dcd98b7102dd2f0e8b11d0f600bfb0c093", "5ccc069c403ebaf9f0171e9517f40e41", null);
        Mockito.when((Object)challengeHandler.generateNonce()).thenReturn((Object)"0a4f113b");
        String authorizationHeader = challengeHandler.handleDigest(method, uri, Collections.singletonList(challenge), () -> new byte[0]);
        Assertions.assertNotNull((Object)authorizationHeader);
        Assertions.assertEquals((Object)expectedResponse, (Object)AuthorizationChallengeHandlerTests.extractValue(authorizationHeader, RESPONSE));
        authorizationHeader = challengeHandler.attemptToPipelineAuthorization(method, uri, () -> new byte[0]);
        Assertions.assertNotNull((Object)authorizationHeader);
        Assertions.assertEquals((int)2, (int)Integer.parseInt(AuthorizationChallengeHandlerTests.extractValue(authorizationHeader, "nc")));
        String expectedPipelineResponse = "15b6bb427e3fecd23a43cb702ce447d5";
        Assertions.assertEquals((Object)expectedPipelineResponse, (Object)AuthorizationChallengeHandlerTests.extractValue(authorizationHeader, RESPONSE));
    }

    @Test
    public void pipelineDigestWithoutInitialHandleFails() {
        AuthorizationChallengeHandler challengeHandler = AuthorizationChallengeHandlerTests.prepareChallengeHandler(DEFAULT_USERNAME, DEFAULT_PASSWORD);
        Assertions.assertNull((Object)challengeHandler.attemptToPipelineAuthorization(null, null, null));
    }

    @Test
    public void sha256DigestAuthorization() {
        AuthorizationChallengeHandler challengeHandler = AuthorizationChallengeHandlerTests.prepareChallengeHandler(DEFAULT_USERNAME, "Circle of Life");
        String expectedResponse = "753927fa0e85d155564e2e272a28d1802ca10daf4496794697cf8db5856cb6c1";
        String method = HttpMethod.GET.toString();
        String uri = "/dir/index.html";
        Map<String, String> challenge = AuthorizationChallengeHandlerTests.createChallenge("http-auth@example.org", "auth", "SHA-256", "7ypf/xlj9XXwfDPEoM4URrv/xwf94BcCAzFZH4GiTo0v", "FQhe/qaU925kfnzjCev0ciny7QMkPqMAFRtzCUYo5tdS", null);
        Mockito.when((Object)challengeHandler.generateNonce()).thenReturn((Object)"f2/wE4q74E6zIJEtWaHKaf5wv/H5QzzpXusqGemxURZJ");
        String authorizationHandler = challengeHandler.handleDigest(method, uri, Collections.singletonList(challenge), () -> new byte[0]);
        Assertions.assertNotNull((Object)authorizationHandler);
        Assertions.assertEquals((Object)expectedResponse, (Object)AuthorizationChallengeHandlerTests.extractValue(authorizationHandler, RESPONSE));
    }

    @Test
    public void preferSha256OverMd5DigestAuthorization() {
        AuthorizationChallengeHandler challengeHandler = AuthorizationChallengeHandlerTests.prepareChallengeHandler(DEFAULT_USERNAME, "Circle of Life");
        String expectedResponse = "753927fa0e85d155564e2e272a28d1802ca10daf4496794697cf8db5856cb6c1";
        String method = HttpMethod.GET.toString();
        String uri = "/dir/index.html";
        Map<String, String> md5Challenge = AuthorizationChallengeHandlerTests.createChallenge("http-auth@example.org", "auth", "MD5", "7ypf/xlj9XXwfDPEoM4URrv/xwf94BcCAzFZH4GiTo0v", "FQhe/qaU925kfnzjCev0ciny7QMkPqMAFRtzCUYo5tdS", null);
        Map<String, String> sha256Challenge = AuthorizationChallengeHandlerTests.createChallenge("http-auth@example.org", "auth", "SHA-256", "7ypf/xlj9XXwfDPEoM4URrv/xwf94BcCAzFZH4GiTo0v", "FQhe/qaU925kfnzjCev0ciny7QMkPqMAFRtzCUYo5tdS", null);
        Mockito.when((Object)challengeHandler.generateNonce()).thenReturn((Object)"f2/wE4q74E6zIJEtWaHKaf5wv/H5QzzpXusqGemxURZJ");
        String authorizationHandler = challengeHandler.handleDigest(method, uri, Arrays.asList(md5Challenge, sha256Challenge), () -> new byte[0]);
        Assertions.assertNotNull((Object)authorizationHandler);
        Assertions.assertEquals((Object)expectedResponse, (Object)AuthorizationChallengeHandlerTests.extractValue(authorizationHandler, RESPONSE));
    }

    @Test
    public void digestAuthorizationDefaultAlgorithmIsMd5() {
        AuthorizationChallengeHandler challengeHandler = AuthorizationChallengeHandlerTests.prepareChallengeHandler(DEFAULT_USERNAME, DEFAULT_PASSWORD);
        String expectedResponse = "6629fae49393a05397450978507c4ef1";
        String method = HttpMethod.GET.toString();
        String uri = "/dir/index.html";
        Map<String, String> challenge = AuthorizationChallengeHandlerTests.createChallenge("testrealm@host.com", "auth", null, "dcd98b7102dd2f0e8b11d0f600bfb0c093", "5ccc069c403ebaf9f0171e9517f40e41", null);
        Mockito.when((Object)challengeHandler.generateNonce()).thenReturn((Object)"0a4f113b");
        String authorizationHeader = challengeHandler.handleDigest(method, uri, Collections.singletonList(challenge), () -> new byte[0]);
        Assertions.assertNotNull((Object)authorizationHeader);
        Assertions.assertEquals((Object)expectedResponse, (Object)AuthorizationChallengeHandlerTests.extractValue(authorizationHeader, RESPONSE));
    }

    @Test
    public void userHashDigestAuthorization() {
        AuthorizationChallengeHandler challengeHandler = AuthorizationChallengeHandlerTests.prepareChallengeHandler("J\u00e4s\u00f8n Doe", "Secret, or not?");
        String expectedResponse = "ae66e67d6b427bd3f120414a82e4acff38e8ecd9101d6c861229025f607a79dd";
        String expectedUsername = "488869477bf257147b804c45308cd62ac4e25eb717b12b298c79e62dcea254ec";
        String method = HttpMethod.GET.toString();
        String uri = "/doe.json";
        Map<String, String> challenge = AuthorizationChallengeHandlerTests.createChallenge("api@example.org", "auth", "SHA-512-256", "5TsQWLVdgBdmrQ0XsxbDODV+57QdFR34I9HAbC/RVvkK", "HRPCssKJSGjCrkzDg8OhwpzCiGPChXYjwrI2QmXDnsOS", true);
        Mockito.when((Object)challengeHandler.generateNonce()).thenReturn((Object)"NTg6RKcb9boFIAS3KrFK9BGeh+iDa/sm6jUMp2wds69v");
        String authorizationHeader = challengeHandler.handleDigest(method, uri, Collections.singletonList(challenge), () -> new byte[0]);
        Assertions.assertNotNull((Object)authorizationHeader);
        Assertions.assertEquals((Object)expectedUsername, (Object)AuthorizationChallengeHandlerTests.extractValue(authorizationHeader, USERNAME));
        Assertions.assertEquals((Object)expectedResponse, (Object)AuthorizationChallengeHandlerTests.extractValue(authorizationHeader, RESPONSE));
    }

    @Test
    public void unknownQop() {
        AuthorizationChallengeHandler challengeHandler = AuthorizationChallengeHandlerTests.prepareChallengeHandler(DEFAULT_USERNAME, DEFAULT_PASSWORD);
        String expectedResponse = "670fd8c2df070c60b045671b8b24ff02";
        String method = HttpMethod.GET.toString();
        String uri = "/dir/index.html";
        Map<String, String> challenge = AuthorizationChallengeHandlerTests.createChallenge("testrealm@host.com", "unknownQop", "MD5", "dcd98b7102dd2f0e8b11d0f600bfb0c093", "5ccc069c403ebaf9f0171e9517f40e41", null);
        Mockito.when((Object)challengeHandler.generateNonce()).thenReturn((Object)"0a4f113b");
        String authorizationHeader = challengeHandler.handleDigest(method, uri, Collections.singletonList(challenge), () -> new byte[0]);
        Assertions.assertNotNull((Object)authorizationHeader);
        Assertions.assertEquals((Object)expectedResponse, (Object)AuthorizationChallengeHandlerTests.extractValue(authorizationHeader, RESPONSE));
    }

    @Test
    public void md5DigestWithAuthInt() {
        AuthorizationChallengeHandler challengeHandler = AuthorizationChallengeHandlerTests.prepareChallengeHandler(DEFAULT_USERNAME, DEFAULT_PASSWORD);
        String expectedResponse = "f7b13069066cfdda58d5accbc02a6b98";
        String method = HttpMethod.GET.toString();
        String uri = "/dir/index.html";
        Map<String, String> challenge = AuthorizationChallengeHandlerTests.createChallenge("testrealm@host.com", "auth-int", "MD5", "dcd98b7102dd2f0e8b11d0f600bfb0c093", "5ccc069c403ebaf9f0171e9517f40e41", null);
        Mockito.when((Object)challengeHandler.generateNonce()).thenReturn((Object)"0a4f113b");
        String authorizationHeader = challengeHandler.handleDigest(method, uri, Collections.singletonList(challenge), () -> "Hello World!".getBytes(StandardCharsets.UTF_8));
        Assertions.assertNotNull((Object)authorizationHeader);
        Assertions.assertEquals((Object)expectedResponse, (Object)AuthorizationChallengeHandlerTests.extractValue(authorizationHeader, RESPONSE));
    }

    @Test
    public void md5DigestWithSessAlgorithm() {
        AuthorizationChallengeHandler challengeHandler = AuthorizationChallengeHandlerTests.prepareChallengeHandler(DEFAULT_USERNAME, DEFAULT_PASSWORD);
        String expectedResponse = "4726bc10c33fa6cb357eb27807b1cce8";
        String method = HttpMethod.GET.toString();
        String uri = "/dir/index.html";
        Map<String, String> challenge = AuthorizationChallengeHandlerTests.createChallenge("testrealm@host.com", "", "MD5-sess", "dcd98b7102dd2f0e8b11d0f600bfb0c093", "5ccc069c403ebaf9f0171e9517f40e41", null);
        Mockito.when((Object)challengeHandler.generateNonce()).thenReturn((Object)"0a4f113b");
        String authorizationHeader = challengeHandler.handleDigest(method, uri, Collections.singletonList(challenge), () -> new byte[0]);
        Assertions.assertNotNull((Object)authorizationHeader);
        Assertions.assertEquals((Object)expectedResponse, (Object)AuthorizationChallengeHandlerTests.extractValue(authorizationHeader, RESPONSE));
    }

    @Test
    public void unsupportedAlgorithmReturnsNull() {
        List<Map<String, String>> challenges = Collections.singletonList(AuthorizationChallengeHandlerTests.createChallenge(REALM, "auth", "SHA3", NONCE, OPAQUE, null));
        Assertions.assertNull((Object)new AuthorizationChallengeHandler(DEFAULT_USERNAME, DEFAULT_PASSWORD).handleDigest(HttpMethod.GET.name(), "/get", challenges, () -> new byte[0]));
    }

    @Test
    public void unknownAlgorithmIsSkipped() {
        List<Map<String, String>> challenges = Collections.singletonList(AuthorizationChallengeHandlerTests.createChallenge(REALM, "auth", "SHA9000", NONCE, OPAQUE, null));
        Assertions.assertNull((Object)new AuthorizationChallengeHandler(DEFAULT_USERNAME, DEFAULT_PASSWORD).handleDigest(HttpMethod.GET.name(), "/get", challenges, () -> new byte[0]));
    }

    @Test
    public void consumeAuthenticationInfoHeader() {
        AuthorizationChallengeHandler challengeHandler = AuthorizationChallengeHandlerTests.prepareChallengeHandler(DEFAULT_USERNAME, DEFAULT_PASSWORD);
        String method = HttpMethod.GET.name();
        String uri = "/dir/index.html";
        String nonce = "dcd98b7102dd2f0e8b11d0f600bfb0c093";
        Map<String, String> challenge = AuthorizationChallengeHandlerTests.createChallenge(REALM, "auth", "MD5", nonce, OPAQUE, null);
        String authorizationHeader = challengeHandler.handleDigest(method, uri, Collections.singletonList(challenge), () -> new byte[0]);
        Assertions.assertNotNull((Object)authorizationHeader);
        String nextNonce = "5ccc069c403ebaf9f0171e9517f40e41";
        challengeHandler.consumeAuthenticationInfoHeader(Collections.singletonMap(NEXT_NONCE, nextNonce));
        authorizationHeader = challengeHandler.attemptToPipelineAuthorization(method, uri, () -> new byte[0]);
        Assertions.assertNotNull((Object)authorizationHeader);
        Assertions.assertEquals((Object)nextNonce, (Object)AuthorizationChallengeHandlerTests.extractValue(authorizationHeader, NONCE));
    }

    @ParameterizedTest
    @MethodSource(value={"nullOrEmptyAuthenticationInfoHeadersSupplier"})
    public void consumingNullOrEmptyAuthenticationInfoHeadersDoesNotUpdate(Map<String, String> authenticationInfo) {
        AuthorizationChallengeHandler challengeHandler = AuthorizationChallengeHandlerTests.prepareChallengeHandler(DEFAULT_USERNAME, DEFAULT_PASSWORD);
        String expectedResponse = "6629fae49393a05397450978507c4ef1";
        String method = HttpMethod.GET.toString();
        String uri = "/dir/index.html";
        String nonce = "dcd98b7102dd2f0e8b11d0f600bfb0c093";
        Map<String, String> challenge = AuthorizationChallengeHandlerTests.createChallenge("testrealm@host.com", "auth", "MD5", nonce, "5ccc069c403ebaf9f0171e9517f40e41", null);
        Mockito.when((Object)challengeHandler.generateNonce()).thenReturn((Object)"0a4f113b");
        String authorizationHeader = challengeHandler.handleDigest(method, uri, Collections.singletonList(challenge), () -> new byte[0]);
        Assertions.assertNotNull((Object)authorizationHeader);
        Assertions.assertEquals((Object)expectedResponse, (Object)AuthorizationChallengeHandlerTests.extractValue(authorizationHeader, RESPONSE));
        challengeHandler.consumeAuthenticationInfoHeader(authenticationInfo);
        authorizationHeader = challengeHandler.handleDigest(method, uri, Collections.singletonList(challenge), () -> new byte[0]);
        Assertions.assertNotNull((Object)authorizationHeader);
        Assertions.assertEquals((Object)nonce, (Object)AuthorizationChallengeHandlerTests.extractValue(authorizationHeader, NONCE));
    }

    private static Stream<Arguments> nullOrEmptyAuthenticationInfoHeadersSupplier() {
        return Stream.of(Arguments.of((Object[])new Object[]{null}), Arguments.of((Object[])new Object[]{Collections.emptyMap()}));
    }

    @ParameterizedTest
    @MethodSource(value={"parseAuthenticationOrAuthorizationHeaderSupplier"})
    public void parseAuthenticationOrAuthorizationHeader(String header, int expectedSize, Map<String, String> expectedMap) {
        Map parsedMap = AuthorizationChallengeHandler.parseAuthenticationOrAuthorizationHeader((String)header);
        Assertions.assertEquals((int)expectedSize, (int)parsedMap.size());
        Assertions.assertEquals(expectedMap, (Object)parsedMap);
    }

    private static Stream<Arguments> parseAuthenticationOrAuthorizationHeaderSupplier() {
        String nextNonce = "abf7395deb";
        HashMap<String, String> expectedMultiMap = new HashMap<String, String>();
        expectedMultiMap.put("nc", "00000001");
        expectedMultiMap.put(NEXT_NONCE, nextNonce);
        return Stream.of(Arguments.of((Object[])new Object[]{null, 0, Collections.emptyMap()}), Arguments.of((Object[])new Object[]{"", 0, Collections.emptyMap()}), Arguments.of((Object[])new Object[]{"nextnonce=\"" + nextNonce + "\"", 1, Collections.singletonMap(NEXT_NONCE, nextNonce)}), Arguments.of((Object[])new Object[]{"nc=00000001, nextnonce=\"" + nextNonce + "\"", 2, expectedMultiMap}));
    }

    private static AuthorizationChallengeHandler prepareChallengeHandler(String username, String password) {
        return (AuthorizationChallengeHandler)Mockito.spy((Object)new AuthorizationChallengeHandler(username, password));
    }

    private static Map<String, String> createChallenge(String realm, String qop, String algorithm, String nonce, String opaque, Boolean userhash) {
        HashMap<String, String> challenge = new HashMap<String, String>();
        challenge.put(REALM, realm);
        challenge.put(QOP, qop);
        challenge.put(NONCE, nonce);
        challenge.put(OPAQUE, opaque);
        if (algorithm != null) {
            challenge.put(ALGORITHM, algorithm);
        }
        if (userhash != null) {
            challenge.put(USERHASH, String.valueOf(userhash));
        }
        return challenge;
    }

    private static String extractValue(String authorizationHeader, String valueKey) {
        String authorizationInfo = authorizationHeader.split(" ", 2)[1];
        return Stream.of(authorizationInfo.split(",")).map(String::trim).map(info -> info.split("=", 2)).filter(kvp -> kvp[0].equalsIgnoreCase(valueKey)).map(kvp -> kvp[1].replace("\"", "")).findFirst().get();
    }
}

