/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import com.azure.core.util.BinaryData;
import com.azure.core.util.MyFileChannel;
import com.azure.core.util.Person;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.JsonSerializer;
import com.azure.core.util.serializer.ObjectSerializer;
import com.azure.core.util.serializer.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.ReadOnlyBufferException;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.spi.FileSystemProvider;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.test.StepVerifier;

public class BinaryDataTest {
    private static final ObjectSerializer CUSTOM_SERIALIZER = new MyJsonSerializer();

    @Test
    public void fromCustomObject() {
        Person actualValue = new Person().setName("John Doe").setAge(50);
        Person expectedValue = new Person().setName("John Doe").setAge(50);
        BinaryData data = BinaryData.fromObject((Object)actualValue, (ObjectSerializer)CUSTOM_SERIALIZER);
        Assertions.assertEquals((Object)expectedValue, (Object)data.toObject(TypeReference.createInstance(expectedValue.getClass()), CUSTOM_SERIALIZER));
    }

    @Test
    public void fromDouble() {
        Double actualValue = Double.valueOf("10.1");
        Double expectedValue = Double.valueOf("10.1");
        BinaryData data = BinaryData.fromObject((Object)actualValue, (ObjectSerializer)CUSTOM_SERIALIZER);
        Assertions.assertEquals((Double)expectedValue, (Double)((Double)data.toObject(TypeReference.createInstance(expectedValue.getClass()), CUSTOM_SERIALIZER)));
    }

    @Test
    public void anyTypeToByteArray() {
        Person actualValue = new Person().setName("John Doe").setAge(50);
        byte[] expectedValue = "{\"name\":\"John Doe\",\"age\":50}".getBytes(StandardCharsets.UTF_8);
        BinaryData data = BinaryData.fromObject((Object)actualValue, (ObjectSerializer)CUSTOM_SERIALIZER);
        Assertions.assertArrayEquals((byte[])expectedValue, (byte[])data.toBytes());
    }

    @Test
    public void createFromString() {
        String expected = "Doe";
        BinaryData data = BinaryData.fromString((String)"Doe");
        Assertions.assertArrayEquals((byte[])"Doe".getBytes(), (byte[])data.toBytes());
        Assertions.assertEquals((Object)"Doe", (Object)data.toString());
    }

    @Test
    public void createFromByteArray() {
        byte[] expected = "Doe".getBytes(StandardCharsets.UTF_8);
        BinaryData data = BinaryData.fromBytes((byte[])expected);
        Assertions.assertArrayEquals((byte[])expected, (byte[])data.toBytes());
    }

    @Test
    public void createFromNullStream() throws IOException {
        Assertions.assertThrows(NullPointerException.class, () -> BinaryData.fromStream(null));
    }

    @Test
    public void createFromNullByteArray() {
        Assertions.assertThrows(NullPointerException.class, () -> BinaryData.fromBytes(null));
    }

    @Test
    public void createFromNullObject() {
        Assertions.assertThrows(NullPointerException.class, () -> BinaryData.fromObject(null, null));
    }

    @Test
    public void createFromNullFile() {
        Assertions.assertThrows(NullPointerException.class, () -> BinaryData.fromFile(null));
    }

    @Test
    public void createFromNullFlux() {
        StepVerifier.create((Publisher)BinaryData.fromFlux(null)).verifyError(NullPointerException.class);
    }

    @Test
    public void createFromStream() throws IOException {
        byte[] expected = "Doe".getBytes(StandardCharsets.UTF_8);
        BinaryData data = BinaryData.fromStream((InputStream)new ByteArrayInputStream(expected));
        Assertions.assertArrayEquals((byte[])expected, (byte[])data.toBytes());
    }

    @Test
    public void createFromLargeStreamAndReadAsFlux() {
        byte[] expected = String.join((CharSequence)"", Collections.nCopies(809200, "A")).concat("A").getBytes(StandardCharsets.UTF_8);
        BinaryData data = BinaryData.fromStream((InputStream)new ByteArrayInputStream(expected));
        StepVerifier.create((Publisher)data.toFluxByteBuffer()).assertNext(bb -> Assertions.assertEquals((Object)String.join((CharSequence)"", Collections.nCopies(8092, "A")), (Object)StandardCharsets.UTF_8.decode((ByteBuffer)bb).toString())).expectNextCount(99L).assertNext(bb -> Assertions.assertEquals((Object)"A", (Object)StandardCharsets.UTF_8.decode((ByteBuffer)bb).toString())).verifyComplete();
    }

    @Test
    public void createFromEmptyStream() throws IOException {
        byte[] expected = "".getBytes();
        BinaryData data = BinaryData.fromStream((InputStream)new ByteArrayInputStream(expected));
        Assertions.assertArrayEquals((byte[])expected, (byte[])data.toBytes());
    }

    @Test
    public void createFromFlux() {
        byte[] data = "Doe".getBytes(StandardCharsets.UTF_8);
        Flux expectedFlux = Flux.just((Object[])new ByteBuffer[]{ByteBuffer.wrap(data), ByteBuffer.wrap(data)});
        byte[] expected = "DoeDoe".getBytes(StandardCharsets.UTF_8);
        StepVerifier.create((Publisher)BinaryData.fromFlux((Flux)expectedFlux)).assertNext(actual -> Assertions.assertArrayEquals((byte[])expected, (byte[])actual.toBytes())).verifyComplete();
    }

    @Test
    public void createFromStreamAsync() {
        byte[] expected = "Doe".getBytes(StandardCharsets.UTF_8);
        StepVerifier.create((Publisher)BinaryData.fromStreamAsync((InputStream)new ByteArrayInputStream(expected))).assertNext(actual -> Assertions.assertArrayEquals((byte[])expected, (byte[])actual.toBytes())).verifyComplete();
    }

    @Test
    public void createFromObjectAsync() {
        Person expected = new Person().setName("Jon").setAge(50);
        TypeReference personTypeReference = TypeReference.createInstance(Person.class);
        StepVerifier.create((Publisher)BinaryData.fromObjectAsync((Object)expected, (ObjectSerializer)CUSTOM_SERIALIZER).flatMap(binaryData -> binaryData.toObjectAsync(personTypeReference, CUSTOM_SERIALIZER))).assertNext(actual -> Assertions.assertEquals((Object)expected, (Object)actual)).verifyComplete();
    }

    @Test
    public void createFromObjectAsyncWithGenerics() {
        Person person1 = new Person().setName("Jon").setAge(50);
        Person person2 = new Person().setName("Jack").setAge(25);
        ArrayList<Person> personList = new ArrayList<Person>();
        personList.add(person1);
        personList.add(person2);
        TypeReference<List<Person>> personListTypeReference = new TypeReference<List<Person>>(){};
        StepVerifier.create((Publisher)BinaryData.fromObjectAsync(personList, (ObjectSerializer)CUSTOM_SERIALIZER).flatMap(arg_0 -> BinaryDataTest.lambda$createFromObjectAsyncWithGenerics$10((TypeReference)personListTypeReference, arg_0))).assertNext(persons -> {
            Assertions.assertEquals((int)2, (int)persons.size());
            Assertions.assertEquals((Object)"Jon", (Object)((Person)persons.get(0)).getName());
            Assertions.assertEquals((Object)"Jack", (Object)((Person)persons.get(1)).getName());
            Assertions.assertEquals((int)50, (int)((Person)persons.get(0)).getAge());
            Assertions.assertEquals((int)25, (int)((Person)persons.get(1)).getAge());
        }).verifyComplete();
    }

    @Test
    public void createFromEmptyString() {
        String expected = "";
        BinaryData data = BinaryData.fromString((String)"");
        Assertions.assertArrayEquals((byte[])"".getBytes(), (byte[])data.toBytes());
        Assertions.assertEquals((Object)"", (Object)data.toString());
    }

    @Test
    public void createFromEmptyByteArray() {
        byte[] expected = new byte[]{};
        BinaryData data = BinaryData.fromBytes((byte[])expected);
        Assertions.assertArrayEquals((byte[])expected, (byte[])data.toBytes());
    }

    @Test
    public void createFromNullString() {
        String expected = null;
        Assertions.assertThrows(NullPointerException.class, () -> BinaryData.fromString((String)expected));
    }

    @Test
    public void toReadOnlyByteBufferThrowsOnMutation() {
        BinaryData binaryData = BinaryData.fromString((String)"Hello");
        Assertions.assertThrows(ReadOnlyBufferException.class, () -> binaryData.toByteBuffer().put((byte)0));
    }

    @Test
    public void fromCustomObjectWithDefaultSerializer() {
        Person actualValue = new Person().setName("John Doe").setAge(50);
        Person expectedValue = new Person().setName("John Doe").setAge(50);
        BinaryData data = BinaryData.fromObject((Object)actualValue);
        Assertions.assertEquals((Object)expectedValue, (Object)data.toObject(TypeReference.createInstance(expectedValue.getClass())));
    }

    @Test
    public void fromDoubleWithDefaultSerializer() {
        Double actualValue = Double.valueOf("10.1");
        Double expectedValue = Double.valueOf("10.1");
        BinaryData data = BinaryData.fromObject((Object)actualValue);
        Assertions.assertEquals((Double)expectedValue, (Double)((Double)data.toObject(TypeReference.createInstance(expectedValue.getClass()))));
    }

    @Test
    public void anyTypeToByteArrayWithDefaultSerializer() {
        Person actualValue = new Person().setName("John Doe").setAge(50);
        byte[] expectedValue = "{\"name\":\"John Doe\",\"age\":50}".getBytes(StandardCharsets.UTF_8);
        BinaryData data = BinaryData.fromObject((Object)actualValue);
        Assertions.assertArrayEquals((byte[])expectedValue, (byte[])data.toBytes());
    }

    @Test
    public void createFromObjectAsyncWithDefaultSerializer() {
        Person expected = new Person().setName("Jon").setAge(50);
        StepVerifier.create((Publisher)BinaryData.fromObjectAsync((Object)expected).flatMap(binaryData -> binaryData.toObjectAsync(TypeReference.createInstance(Person.class)))).assertNext(actual -> Assertions.assertEquals((Object)expected, (Object)actual)).verifyComplete();
    }

    @Test
    public void createFromObjectAsyncWithGenericsWithDefaultSerializer() {
        Person person1 = new Person().setName("Jon").setAge(50);
        Person person2 = new Person().setName("Jack").setAge(25);
        ArrayList<Person> personList = new ArrayList<Person>();
        personList.add(person1);
        personList.add(person2);
        StepVerifier.create((Publisher)BinaryData.fromObjectAsync(personList).flatMap(binaryData -> binaryData.toObjectAsync((TypeReference)new TypeReference<List<Person>>(){}))).assertNext(persons -> {
            Assertions.assertEquals((int)2, (int)persons.size());
            Assertions.assertEquals((Object)"Jon", (Object)((Person)persons.get(0)).getName());
            Assertions.assertEquals((Object)"Jack", (Object)((Person)persons.get(1)).getName());
            Assertions.assertEquals((int)50, (int)((Person)persons.get(0)).getAge());
            Assertions.assertEquals((int)25, (int)((Person)persons.get(1)).getAge());
        }).verifyComplete();
    }

    @Test
    public void fileChannelOpenErrorReturnsReactively() {
        Path notARealPath = Paths.get("fake", new String[0]);
        Assertions.assertThrows(UncheckedIOException.class, () -> BinaryData.fromFile((Path)notARealPath));
    }

    @Test
    public void fileChannelCloseErrorReturnsReactively() throws IOException {
        MyFileChannel myFileChannel = (MyFileChannel)Mockito.spy(MyFileChannel.class);
        Mockito.when((Object)myFileChannel.map((FileChannel.MapMode)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).thenReturn((Object)((MappedByteBuffer)Mockito.mock(MappedByteBuffer.class)));
        ((MyFileChannel)Mockito.doThrow(IOException.class).when((Object)myFileChannel)).implCloseChannel();
        FileSystemProvider fileSystemProvider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Mockito.when((Object)fileSystemProvider.newFileChannel((Path)ArgumentMatchers.any(), (Set)ArgumentMatchers.any(), (FileAttribute[])ArgumentMatchers.any())).thenReturn((Object)myFileChannel);
        FileSystem fileSystem = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)fileSystem.provider()).thenReturn((Object)fileSystemProvider);
        Path path = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)path.getFileSystem()).thenReturn((Object)fileSystem);
        File file = (File)Mockito.mock(File.class);
        Mockito.when((Object)file.length()).thenReturn((Object)1024L);
        Mockito.when((Object)file.exists()).thenReturn((Object)true);
        Mockito.when((Object)path.toFile()).thenReturn((Object)file);
        BinaryData binaryData = BinaryData.fromFile((Path)path);
        StepVerifier.create((Publisher)binaryData.toFluxByteBuffer()).thenConsumeWhile(Objects::nonNull).verifyError(IOException.class);
    }

    @Test
    public void fileChannelIsClosedWhenMapErrors() throws IOException {
        MyFileChannel myFileChannel = (MyFileChannel)Mockito.spy(MyFileChannel.class);
        Mockito.when((Object)myFileChannel.map((FileChannel.MapMode)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).thenThrow(IOException.class);
        FileSystemProvider fileSystemProvider = (FileSystemProvider)Mockito.mock(FileSystemProvider.class);
        Mockito.when((Object)fileSystemProvider.newFileChannel((Path)ArgumentMatchers.any(), (Set)ArgumentMatchers.any(), (FileAttribute[])ArgumentMatchers.any())).thenReturn((Object)myFileChannel);
        FileSystem fileSystem = (FileSystem)Mockito.mock(FileSystem.class);
        Mockito.when((Object)fileSystem.provider()).thenReturn((Object)fileSystemProvider);
        Path path = (Path)Mockito.mock(Path.class);
        Mockito.when((Object)path.getFileSystem()).thenReturn((Object)fileSystem);
        File file = (File)Mockito.mock(File.class);
        Mockito.when((Object)file.length()).thenReturn((Object)1024L);
        Mockito.when((Object)file.exists()).thenReturn((Object)true);
        Mockito.when((Object)path.toFile()).thenReturn((Object)file);
        BinaryData binaryData = BinaryData.fromFile((Path)path);
        StepVerifier.create((Publisher)binaryData.toFluxByteBuffer()).thenConsumeWhile(Objects::nonNull).verifyError(IOException.class);
        Assertions.assertFalse((boolean)myFileChannel.isOpen());
    }

    @Test
    public void fluxContent() {
        Mono binaryDataMono = BinaryData.fromFlux((Flux)Flux.just((Object)ByteBuffer.wrap("Hello".getBytes(StandardCharsets.UTF_8))).delayElements(Duration.ofMillis(10L)));
        StepVerifier.create((Publisher)binaryDataMono).assertNext(binaryData -> Assertions.assertEquals((Object)"Hello", (Object)new String(binaryData.toBytes()))).verifyComplete();
    }

    @Test
    public void testFromFile() throws Exception {
        Path file = Files.createTempFile("binaryDataFromFile" + UUID.randomUUID(), ".txt", new FileAttribute[0]);
        file.toFile().deleteOnExit();
        try (FileWriter fileWriter = new FileWriter(file.toFile());){
            fileWriter.write("The quick brown fox jumps over the lazy dog");
        }
        BinaryData data = BinaryData.fromFile((Path)file);
        Assertions.assertEquals((Object)"The quick brown fox jumps over the lazy dog", (Object)data.toString());
    }

    @Test
    public void testFromFileToFlux() throws Exception {
        Path file = Files.createTempFile("binaryDataFromFile" + UUID.randomUUID(), ".txt", new FileAttribute[0]);
        file.toFile().deleteOnExit();
        try (FileWriter fileWriter = new FileWriter(file.toFile());){
            fileWriter.write("The quick brown fox jumps over the lazy dog");
        }
        BinaryData data = BinaryData.fromFile((Path)file);
        StepVerifier.create((Publisher)data.toFluxByteBuffer()).assertNext(bb -> Assertions.assertEquals((Object)"The quick brown fox jumps over the lazy dog", (Object)StandardCharsets.UTF_8.decode((ByteBuffer)bb).toString())).verifyComplete();
    }

    private static /* synthetic */ Mono lambda$createFromObjectAsyncWithGenerics$10(TypeReference personListTypeReference, BinaryData binaryData) {
        return binaryData.toObjectAsync(personListTypeReference, CUSTOM_SERIALIZER);
    }

    public static class MyJsonSerializer
    implements JsonSerializer {
        private final ClientLogger logger = new ClientLogger(MyJsonSerializer.class);
        private final ObjectMapper mapper = new ObjectMapper();
        private final TypeFactory typeFactory = this.mapper.getTypeFactory();

        public <T> T deserialize(InputStream stream, TypeReference<T> typeReference) {
            if (stream == null) {
                return null;
            }
            try {
                return (T)this.mapper.readValue(stream, this.typeFactory.constructType(typeReference.getJavaType()));
            }
            catch (IOException ex) {
                throw this.logger.logExceptionAsError((RuntimeException)new UncheckedIOException(ex));
            }
        }

        public <T> Mono<T> deserializeAsync(InputStream stream, TypeReference<T> typeReference) {
            return Mono.fromCallable(() -> this.deserialize(stream, typeReference));
        }

        public void serialize(OutputStream stream, Object value) {
            try {
                this.mapper.writeValue(stream, value);
            }
            catch (IOException ex) {
                throw this.logger.logExceptionAsError((RuntimeException)new UncheckedIOException(ex));
            }
        }

        public Mono<Void> serializeAsync(OutputStream stream, Object value) {
            return Mono.fromRunnable(() -> this.serialize(stream, value));
        }
    }
}

