/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import com.azure.core.util.BufferedFluxByteBuffer;
import com.azure.core.util.FluxUtil;
import java.nio.ByteBuffer;
import java.security.SecureRandom;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.test.StepVerifier;

public class BufferedFluxByteBufferTests {
    @Test
    public void coldBufferIsBuffered() {
        byte[] randomBytes = new byte[0x100000];
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.nextBytes(randomBytes);
        BufferedFluxByteBuffer bufferedFluxByteBuffer = new BufferedFluxByteBuffer(Flux.fromArray((Object[])BufferedFluxByteBufferTests.splitBytesIntoBuffers(randomBytes)));
        StepVerifier.create((Publisher)FluxUtil.collectBytesInByteBufferStream((Flux)bufferedFluxByteBuffer)).assertNext(bytes -> Assertions.assertArrayEquals((byte[])randomBytes, (byte[])bytes)).verifyComplete();
        StepVerifier.create((Publisher)FluxUtil.collectBytesInByteBufferStream((Flux)bufferedFluxByteBuffer)).assertNext(bytes -> Assertions.assertArrayEquals((byte[])randomBytes, (byte[])bytes)).verifyComplete();
    }

    @Test
    public void hotBufferIsBuffered() {
        byte[] randomBytes = new byte[0x100000];
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.nextBytes(randomBytes);
        BufferedFluxByteBuffer bufferedFluxByteBuffer = new BufferedFluxByteBuffer(Flux.fromArray((Object[])BufferedFluxByteBufferTests.splitBytesIntoBuffers(randomBytes)).share());
        StepVerifier.create((Publisher)FluxUtil.collectBytesInByteBufferStream((Flux)bufferedFluxByteBuffer)).assertNext(bytes -> Assertions.assertArrayEquals((byte[])randomBytes, (byte[])bytes)).verifyComplete();
        StepVerifier.create((Publisher)FluxUtil.collectBytesInByteBufferStream((Flux)bufferedFluxByteBuffer)).assertNext(bytes -> Assertions.assertArrayEquals((byte[])randomBytes, (byte[])bytes)).verifyComplete();
    }

    private static ByteBuffer[] splitBytesIntoBuffers(byte[] bytes) {
        int expectedBuffers = (int)Math.ceil((double)bytes.length / 1024.0);
        ByteBuffer[] buffers = new ByteBuffer[expectedBuffers];
        for (int i = 0; i < expectedBuffers; ++i) {
            int bufferLength = Math.min(1024, bytes.length - 1024 * i);
            buffers[i] = ByteBuffer.wrap(bytes, i * 1024, bufferLength);
        }
        return buffers;
    }
}

