/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import com.azure.core.util.ClientOptions;
import com.azure.core.util.Header;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class ClientOptionsTest {
    @Test
    public void testNullHeaders() {
        boolean expectedTotal = false;
        ClientOptions clientOptions = new ClientOptions().setHeaders(null);
        Iterable headers = clientOptions.getHeaders();
        Assertions.assertNotNull((Object)headers);
        int actualCount = 0;
        for (Header value : headers) {
            ++actualCount;
        }
        Assertions.assertEquals((int)0, (int)actualCount);
    }

    @ParameterizedTest
    @MethodSource(value={"invalidApplicationId"})
    public void testMaxApplicationId(String applicationId) {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new ClientOptions().setApplicationId(applicationId));
    }

    @Test
    public void testSetApplicationId() {
        String expected = "AzCopy/10.0.4-Preview";
        Assertions.assertEquals((Object)expected, (Object)new ClientOptions().setApplicationId(expected).getApplicationId());
    }

    private static Stream<Arguments> invalidApplicationId() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{"AppId-0123456789012345678912345"}), Arguments.arguments((Object[])new Object[]{"AppId 78912345"}));
    }
}

