/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import com.azure.core.http.HttpHeaders;
import com.azure.core.http.policy.HttpLogOptions;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.Configuration;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.Header;
import com.azure.core.util.logging.ClientLogger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class CoreUtilsTests {
    private static final byte[] BYTES = "Hello world!".getBytes(StandardCharsets.UTF_8);
    private static final byte[] UTF_8_BOM = new byte[]{-17, -69, -65};
    private static final byte[] UTF_16BE_BOM = new byte[]{-2, -1};
    private static final byte[] UTF_16LE_BOM = new byte[]{-1, -2};
    private static final byte[] UTF_32BE_BOM = new byte[]{0, 0, -2, -1};
    private static final byte[] UTF_32LE_BOM = new byte[]{-1, -2, 0, 0};
    private static final String TIMEOUT_PROPERTY_NAME = "TIMEOUT_PROPERTY_NAME";

    @Test
    public void findFirstOfTypeEmptyArgs() {
        Assertions.assertNull((Object)CoreUtils.findFirstOfType(null, Integer.class));
    }

    @Test
    public void findFirstOfTypeWithOneOfType() {
        int expected = 1;
        Object[] args = new Object[]{"string", expected};
        Integer actual = (Integer)CoreUtils.findFirstOfType((Object[])args, Integer.class);
        Assertions.assertEquals((int)expected, (Integer)actual);
    }

    @Test
    public void findFirstOfTypeWithMultipleOfType() {
        int expected = 1;
        Object[] args = new Object[]{"string", expected, 10};
        Integer actual = (Integer)CoreUtils.findFirstOfType((Object[])args, Integer.class);
        Assertions.assertEquals((int)expected, (Integer)actual);
    }

    @Test
    public void findFirstOfTypeWithNoneOfType() {
        Object[] args = new Object[]{"string", "anotherString"};
        Assertions.assertNull((Object)CoreUtils.findFirstOfType((Object[])args, Integer.class));
    }

    @Test
    public void testProperties() {
        Assertions.assertNotNull(CoreUtils.getProperties((String)"azure-core.properties").get("version"));
        Assertions.assertNotNull(CoreUtils.getProperties((String)"azure-core.properties").get("name"));
        Assertions.assertTrue((boolean)((String)CoreUtils.getProperties((String)"azure-core.properties").get("version")).matches("\\d+\\.\\d+\\.\\d+(-beta\\.\\d+)?"));
    }

    @Test
    public void testMissingProperties() {
        Assertions.assertNotNull((Object)CoreUtils.getProperties((String)"foo.properties"));
        Assertions.assertTrue((boolean)CoreUtils.getProperties((String)"foo.properties").isEmpty());
        Assertions.assertNull(CoreUtils.getProperties((String)"azure-core.properties").get("foo"));
    }

    @ParameterizedTest
    @MethodSource(value={"cloneIntArraySupplier"})
    public void cloneIntArray(int[] intArray, int[] expected) {
        Assertions.assertArrayEquals((int[])expected, (int[])CoreUtils.clone((int[])intArray));
    }

    private static Stream<Arguments> cloneIntArraySupplier() {
        return Stream.of(Arguments.of((Object[])new Object[]{null, null}), Arguments.of((Object[])new Object[]{new int[0], new int[0]}), Arguments.of((Object[])new Object[]{new int[]{1, 2, 3}, new int[]{1, 2, 3}}));
    }

    @ParameterizedTest
    @MethodSource(value={"cloneGenericArraySupplier"})
    public <T> void cloneGenericArray(T[] genericArray, T[] expected) {
        Assertions.assertArrayEquals((Object[])expected, (Object[])CoreUtils.clone((Object[])genericArray));
    }

    private static Stream<Arguments> cloneGenericArraySupplier() {
        return Stream.of(Arguments.of((Object[])new Object[]{null, null}), Arguments.of((Object[])new Object[]{new String[0], new String[0]}), Arguments.of((Object[])new Object[]{new String[]{"1", "2", "3"}, new String[]{"1", "2", "3"}}));
    }

    @ParameterizedTest
    @MethodSource(value={"isNullOrEmptyCollectionSupplier"})
    public void isNullOrEmptyCollection(Collection<?> collection, boolean expected) {
        Assertions.assertEquals((Object)expected, (Object)CoreUtils.isNullOrEmpty(collection));
    }

    private static Stream<Arguments> isNullOrEmptyCollectionSupplier() {
        return Stream.of(Arguments.of((Object[])new Object[]{null, true}), Arguments.of((Object[])new Object[]{new ArrayList(), true}), Arguments.of((Object[])new Object[]{Collections.singletonList(1), false}));
    }

    @ParameterizedTest
    @MethodSource(value={"arrayToStringSupplier"})
    public <T> void arrayToString(T[] array, Function<T, String> mapper, String expected) {
        Assertions.assertEquals((Object)expected, (Object)CoreUtils.arrayToString((Object[])array, mapper));
    }

    private static Stream<Arguments> arrayToStringSupplier() {
        Function<Object, String> toStringFunction = String::valueOf;
        return Stream.of(Arguments.of((Object[])new Object[]{null, null, null}), Arguments.of((Object[])new Object[]{new String[0], toStringFunction, null}), Arguments.of((Object[])new Object[]{new String[]{""}, toStringFunction, ""}), Arguments.of((Object[])new Object[]{new String[]{"Hello world!"}, toStringFunction, "Hello world!"}), Arguments.of((Object[])new Object[]{new String[]{"1", "2", "3"}, toStringFunction, "1,2,3"}));
    }

    @ParameterizedTest
    @MethodSource(value={"bomAwareToStringSupplier"})
    public void bomAwareToString(byte[] bytes, String contentType, String expected) {
        Assertions.assertEquals((Object)expected, (Object)CoreUtils.bomAwareToString((byte[])bytes, (String)contentType));
    }

    private static Stream<Arguments> bomAwareToStringSupplier() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{null, null, null}), Arguments.arguments((Object[])new Object[]{BYTES, null, new String(BYTES, StandardCharsets.UTF_8)}), Arguments.arguments((Object[])new Object[]{BYTES, "charset=UTF-16BE", new String(BYTES, StandardCharsets.UTF_16BE)}), Arguments.arguments((Object[])new Object[]{BYTES, "charset=invalid", new String(BYTES, StandardCharsets.UTF_8)}), Arguments.arguments((Object[])new Object[]{CoreUtilsTests.addBom(UTF_8_BOM), null, new String(BYTES, StandardCharsets.UTF_8)}), Arguments.arguments((Object[])new Object[]{CoreUtilsTests.addBom(UTF_16BE_BOM), null, new String(BYTES, StandardCharsets.UTF_16BE)}), Arguments.arguments((Object[])new Object[]{CoreUtilsTests.addBom(UTF_16LE_BOM), null, new String(BYTES, StandardCharsets.UTF_16LE)}), Arguments.arguments((Object[])new Object[]{CoreUtilsTests.addBom(UTF_32BE_BOM), null, new String(BYTES, Charset.forName("UTF-32BE"))}), Arguments.arguments((Object[])new Object[]{CoreUtilsTests.addBom(UTF_32LE_BOM), null, new String(BYTES, Charset.forName("UTF-32LE"))}), Arguments.arguments((Object[])new Object[]{CoreUtilsTests.addBom(UTF_8_BOM), "charset=UTF-8", new String(BYTES, StandardCharsets.UTF_8)}), Arguments.arguments((Object[])new Object[]{CoreUtilsTests.addBom(UTF_8_BOM), "charset=UTF-16BE", new String(BYTES, StandardCharsets.UTF_8)}));
    }

    private static byte[] addBom(byte[] arr1) {
        byte[] mergedArray = new byte[arr1.length + BYTES.length];
        System.arraycopy(arr1, 0, mergedArray, 0, arr1.length);
        System.arraycopy(BYTES, 0, mergedArray, arr1.length, BYTES.length);
        return mergedArray;
    }

    @ParameterizedTest
    @MethodSource(value={"getApplicationIdSupplier"})
    public void getApplicationId(ClientOptions clientOptions, HttpLogOptions logOptions, String expected) {
        Assertions.assertEquals((Object)expected, (Object)CoreUtils.getApplicationId((ClientOptions)clientOptions, (HttpLogOptions)logOptions));
    }

    private static Stream<Arguments> getApplicationIdSupplier() {
        String clientOptionApplicationId = "clientOptions";
        String logOptionsApplicationId = "logOptions";
        ClientOptions clientOptionsWithApplicationId = new ClientOptions().setApplicationId(clientOptionApplicationId);
        ClientOptions clientOptionsWithoutApplicationId = new ClientOptions();
        HttpLogOptions logOptionsWithApplicationId = new HttpLogOptions().setApplicationId(logOptionsApplicationId);
        HttpLogOptions logOptionsWithoutApplicationId = new HttpLogOptions();
        return Stream.of(Arguments.of((Object[])new Object[]{clientOptionsWithApplicationId, logOptionsWithApplicationId, clientOptionApplicationId}), Arguments.of((Object[])new Object[]{clientOptionsWithApplicationId, logOptionsWithoutApplicationId, clientOptionApplicationId}), Arguments.of((Object[])new Object[]{clientOptionsWithApplicationId, null, clientOptionApplicationId}), Arguments.of((Object[])new Object[]{clientOptionsWithoutApplicationId, logOptionsWithApplicationId, logOptionsApplicationId}), Arguments.of((Object[])new Object[]{clientOptionsWithoutApplicationId, logOptionsWithoutApplicationId, null}), Arguments.of((Object[])new Object[]{clientOptionsWithoutApplicationId, null, null}), Arguments.of((Object[])new Object[]{null, logOptionsWithApplicationId, logOptionsApplicationId}), Arguments.of((Object[])new Object[]{null, logOptionsWithoutApplicationId, null}), Arguments.of((Object[])new Object[]{null, null, null}));
    }

    @ParameterizedTest
    @MethodSource(value={"createHttpHeadersFromClientOptionsSupplier"})
    public void createHttpHeadersFromClientOptions(ClientOptions clientOptions, HttpHeaders expected) {
        HttpHeaders actual = CoreUtils.createHttpHeadersFromClientOptions((ClientOptions)clientOptions);
        if (expected == null) {
            Assertions.assertNull((Object)actual);
        } else {
            Assertions.assertEquals((Object)expected.toMap(), (Object)actual.toMap());
        }
    }

    private static Stream<Arguments> createHttpHeadersFromClientOptionsSupplier() {
        ArrayList<Header> multipleHeadersList = new ArrayList<Header>();
        multipleHeadersList.add(new Header("a", "header"));
        multipleHeadersList.add(new Header("another", "headerValue"));
        HashMap<String, String> multipleHeadersMap = new HashMap<String, String>();
        multipleHeadersMap.put("a", "header");
        multipleHeadersMap.put("another", "headerValue");
        return Stream.of(Arguments.of((Object[])new Object[]{null, null}), Arguments.of((Object[])new Object[]{new ClientOptions(), null}), Arguments.of((Object[])new Object[]{new ClientOptions().setHeaders(Collections.singletonList(new Header("a", "header"))), new HttpHeaders(Collections.singletonMap("a", "header"))}), Arguments.of((Object[])new Object[]{new ClientOptions().setHeaders(multipleHeadersList), new HttpHeaders(multipleHeadersMap)}));
    }

    @ParameterizedTest
    @MethodSource(value={"getDefaultTimeoutFromEnvironmentSupplier"})
    public void getDefaultTimeoutFromEnvironmentTests(Configuration configuration, Duration defaultTimeout, ClientLogger logger, Duration expectedTimeout) {
        Assertions.assertEquals((Object)expectedTimeout, (Object)CoreUtils.getDefaultTimeoutFromEnvironment((Configuration)configuration, (String)TIMEOUT_PROPERTY_NAME, (Duration)defaultTimeout, (ClientLogger)logger));
    }

    private static Stream<Arguments> getDefaultTimeoutFromEnvironmentSupplier() {
        ClientLogger logger = new ClientLogger(CoreUtilsTests.class);
        return Stream.of(Arguments.of((Object[])new Object[]{Configuration.NONE, Duration.ofMillis(10000L), logger, Duration.ofMillis(10000L)}), Arguments.of((Object[])new Object[]{new Configuration().put(TIMEOUT_PROPERTY_NAME, ""), Duration.ofMillis(10000L), logger, Duration.ofMillis(10000L)}), Arguments.of((Object[])new Object[]{new Configuration().put(TIMEOUT_PROPERTY_NAME, "ten"), Duration.ofMillis(10000L), logger, Duration.ofMillis(10000L)}), Arguments.of((Object[])new Object[]{new Configuration().put(TIMEOUT_PROPERTY_NAME, "-10"), Duration.ofMillis(10000L), logger, Duration.ZERO}), Arguments.of((Object[])new Object[]{new Configuration().put(TIMEOUT_PROPERTY_NAME, "0"), Duration.ofMillis(10000L), logger, Duration.ZERO}), Arguments.of((Object[])new Object[]{new Configuration().put(TIMEOUT_PROPERTY_NAME, "42"), Duration.ofMillis(10000L), logger, Duration.ofMillis(42L)}));
    }
}

