/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import com.azure.core.util.Header;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class HeaderTest {
    @Test
    public void testAddValue() {
        Header header = new Header("a", "b");
        header.addValue("c");
        Assertions.assertEquals((Object)"a:b,c", (Object)header.toString());
    }

    @ParameterizedTest
    @MethodSource
    public void testNullArgsConstructor(String name, String value) {
        Assertions.assertThrows(NullPointerException.class, () -> new Header(name, value));
    }

    @Test
    public void testNameValue() {
        String name = "a";
        String value = "b";
        Header header = new Header(name, value);
        Assertions.assertEquals((Object)value, (Object)header.getValue());
        Assertions.assertEquals((Object)name, (Object)header.getName());
    }

    @Test
    public void testGetValues() {
        String name = "a";
        Object[] values = new String[]{"b", "c"};
        Header header = new Header(name, values[0]);
        header.addValue(values[1]);
        Assertions.assertArrayEquals((Object[])values, (Object[])header.getValues());
    }

    private static Stream<Arguments> testNullArgsConstructor() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{null, "a"}), Arguments.arguments((Object[])new Object[]{null, null}));
    }
}

