/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import com.azure.core.util.QueryParameter;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class QueryParameterTest {
    @Test
    public void testAddValue() {
        QueryParameter parameter = new QueryParameter("a", "b");
        parameter.addValue("c");
        Assertions.assertEquals((Object)"a=b,c", (Object)parameter.toString());
    }

    @ParameterizedTest
    @MethodSource
    public void testNullArgsConstructor(String name, String value) {
        Assertions.assertThrows(NullPointerException.class, () -> new QueryParameter(name, value));
    }

    @Test
    public void testNullValuesConstructor() {
        String name = "a";
        LinkedList values = null;
        Assertions.assertThrows(NullPointerException.class, () -> new QueryParameter(name, (List)values));
    }

    @Test
    public void testNameValue() {
        String name = "a";
        String value = "b";
        QueryParameter parameter = new QueryParameter(name, value);
        Assertions.assertEquals((Object)value, (Object)parameter.getValue());
        Assertions.assertEquals((Object)name, (Object)parameter.getName());
    }

    @Test
    public void testGetValues() {
        String name = "a";
        Object[] values = new String[]{"b", "c"};
        QueryParameter parameter = new QueryParameter(name, values[0]);
        parameter.addValue(values[1]);
        Assertions.assertArrayEquals((Object[])values, (Object[])parameter.getValues());
    }

    private static Stream<Arguments> testNullArgsConstructor() {
        return Stream.of(Arguments.arguments((Object[])new Object[]{null, "a"}), Arguments.arguments((Object[])new Object[]{null, null}));
    }
}

