/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import com.azure.core.util.tracing.SpanKind;
import com.azure.core.util.tracing.StartSpanOptions;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class StartSpanOptionsTests {
    @Test
    public void kindCannotBeNull() {
        Assertions.assertThrows(NullPointerException.class, () -> new StartSpanOptions(null));
    }

    @Test
    public void internalSpan() {
        StartSpanOptions options = new StartSpanOptions(SpanKind.INTERNAL);
        Assertions.assertEquals((Object)SpanKind.INTERNAL, (Object)options.getSpanKind());
        Assertions.assertNull((Object)options.getAttributes());
    }

    @Test
    public void clientSpan() {
        StartSpanOptions options = new StartSpanOptions(SpanKind.CLIENT);
        Assertions.assertEquals((Object)SpanKind.CLIENT, (Object)options.getSpanKind());
        Assertions.assertNull((Object)options.getAttributes());
    }

    @Test
    public void setAttributes() {
        StartSpanOptions options = new StartSpanOptions(SpanKind.CLIENT).setAttribute("foo", (Object)"bar").setAttribute("1", (Object)1);
        Assertions.assertEquals((Object)SpanKind.CLIENT, (Object)options.getSpanKind());
        Assertions.assertEquals((int)2, (int)options.getAttributes().size());
        Assertions.assertEquals((Object)"bar", options.getAttributes().get("foo"));
        Assertions.assertEquals((Object)1, options.getAttributes().get("1"));
    }
}

