/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.util;

import com.azure.core.util.Configuration;
import com.azure.core.util.UserAgentUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class UserAgentUtilTest {
    @Test
    void testUserAgentStringFormat() {
        String javaVersion = System.getProperty("java.version");
        String osName = System.getProperty("os.name");
        String osVersion = System.getProperty("os.version");
        String plaform = "(" + javaVersion + "; " + osName + "; " + osVersion + ")";
        Assertions.assertEquals((Object)("azsdk-java-azure-storage-blob/12.0.0 " + plaform), (Object)UserAgentUtil.toUserAgentString(null, (String)"azure-storage-blob", (String)"12.0.0", null));
        Assertions.assertEquals((Object)("myapp azsdk-java-azure-storage-blob/12.0.0 " + plaform), (Object)UserAgentUtil.toUserAgentString((String)"myapp", (String)"azure-storage-blob", (String)"12.0.0", null));
        Assertions.assertEquals((Object)"azsdk-java-azure-storage-blob/12.0.0", (Object)UserAgentUtil.toUserAgentString(null, (String)"azure-storage-blob", (String)"12.0.0", (Configuration)Configuration.getGlobalConfiguration().clone().put("AZURE_TELEMETRY_DISABLED", "true")));
        Assertions.assertEquals((Object)"myapp azsdk-java-azure-storage-blob/12.0.0", (Object)UserAgentUtil.toUserAgentString((String)"myapp", (String)"azure-storage-blob", (String)"12.0.0", (Configuration)Configuration.getGlobalConfiguration().clone().put("AZURE_TELEMETRY_DISABLED", "true")));
        Assertions.assertThrows(IllegalArgumentException.class, () -> UserAgentUtil.toUserAgentString((String)"ReallyLongApplicationIdentity", (String)"azure-storage-blob", (String)"12.0.0", null));
        Assertions.assertEquals((Object)("myapp azsdk-java-null/null " + plaform), (Object)UserAgentUtil.toUserAgentString((String)"myapp", null, null, null));
    }
}

